/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.checks;

import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import org.apache.commons.lang.SystemUtils;
import org.apache.xalan.Version;
import org.jasig.portal.tools.checks.BaseCheck;
import org.jasig.portal.tools.checks.CheckResult;

public class XalanVersionCheck
extends BaseCheck {
    private final String desiredVersion;

    public XalanVersionCheck(String desiredVersion) {
        if (desiredVersion == null) {
            throw new IllegalArgumentException("XalanVersionCheck requires a particular version String to check for.");
        }
        this.desiredVersion = desiredVersion;
        this.setDescription("Check that the version of Xalan present is [" + this.desiredVersion + "]");
    }

    @Override
    protected CheckResult doCheckInternal() {
        CheckResult result;
        try {
            String versionFound = Version.getVersion();
            if (this.desiredVersion.equals(versionFound)) {
                result = CheckResult.createSuccess("Xalan version [" + versionFound + "] is present.");
            } else {
                CodeSource codeSource;
                String jarLocation = "";
                String locationInfo = "";
                ProtectionDomain protectionDomain = Version.class.getProtectionDomain();
                if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null) {
                    URL location = codeSource.getLocation();
                    jarLocation = location.toString();
                    locationInfo = " loaded from '" + jarLocation + "'";
                }
                StringBuffer message = new StringBuffer();
                message.append("Xalan version [").append(versionFound).append("]");
                message.append(locationInfo).append(" is present, rather than the desired version [");
                message.append(this.desiredVersion).append("]");
                StringBuffer remediation = new StringBuffer();
                if (SystemUtils.IS_OS_MAC_OSX && jarLocation.endsWith("14compatibility.jar")) {
                    remediation.append("Running uPortal on Mac OS X requires you to disable a library that is included in its Java distribution; rename or delete ").append(jarLocation);
                } else {
                    remediation.append("uPortal includes the appropriate version of Xalan; please remove the file ").append(jarLocation).append(" from the classpath.");
                }
                result = CheckResult.createFailure(message.toString(), remediation.toString());
            }
        }
        catch (NoClassDefFoundError ncdfe) {
            result = CheckResult.createFailure("Class org.apache.xalan.Version could not be found.", "Install the xalan jar corresponding to [" + this.desiredVersion + "] in the /lib/endorsed directory of the JRE.");
        }
        return result;
    }
}

