/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.dbloader;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.sql.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.jasig.portal.tools.dbloader.DataXmlHandler;
import org.jasig.portal.tools.dbloader.DbLoaderConfiguration;
import org.jasig.portal.tools.dbloader.IDbLoader;
import org.jasig.portal.tools.dbloader.ITableDataProvider;
import org.jasig.portal.tools.dbloader.TableXmlHandler;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.NonTransientDataAccessResourceException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HibernateDbLoader
implements IDbLoader {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private JdbcTemplate jdbcTemplate;
    private TransactionTemplate transactionTemplate;
    private Dialect dialect;

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionTemplate = new TransactionTemplate(transactionManager);
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public void process(DbLoaderConfiguration configuration) throws ParserConfigurationException, SAXException, IOException {
        String scriptFile;
        ArrayList<String> script = new ArrayList<String>();
        ITableDataProvider tableData = this.loadTables(configuration);
        if (configuration.isDropTables() || configuration.isCreateTables()) {
            Map<String, Table> tables = tableData.getTables();
            Mapping mapping = null;
            String defaultCatalog = null;
            String defaultSchema = null;
            LinkedHashMap<String, DataAccessException> failedSql = new LinkedHashMap<String, DataAccessException>();
            if (configuration.isDropTables()) {
                this.logger.info((Object)"Dropping existing tables");
                List<String> dropScript = this.dropScript(tables.values(), this.dialect, defaultCatalog, defaultSchema);
                for (String sql : dropScript) {
                    this.logger.info((Object)sql);
                    try {
                        this.jdbcTemplate.update(sql);
                    }
                    catch (NonTransientDataAccessResourceException dae) {
                        throw dae;
                    }
                    catch (DataAccessException dae) {
                        failedSql.put(sql, dae);
                    }
                }
                script.addAll(dropScript);
            }
            if (configuration.isCreateTables()) {
                this.logger.info((Object)"Creating tables");
                List<String> createScript = this.createScript(tables.values(), this.dialect, mapping, defaultCatalog, defaultSchema);
                for (String sql : createScript) {
                    this.logger.info((Object)sql);
                    this.jdbcTemplate.update(sql);
                }
                script.addAll(createScript);
            }
            for (Map.Entry failedSqlEntry : failedSql.entrySet()) {
                this.logger.warn((Object)("'" + (String)failedSqlEntry.getKey() + "' failed to execute due to " + failedSqlEntry.getValue()));
            }
        }
        if (configuration.isPopulateTables()) {
            this.logger.info((Object)"Populating database");
            Map<String, Map<String, Integer>> tableColumnTypes = tableData.getTableColumnTypes();
            this.populateTables(configuration, tableColumnTypes);
        }
        if ((scriptFile = configuration.getScriptFile()) != null) {
            ListIterator<String> iterator = script.listIterator();
            while (iterator.hasNext()) {
                String sql = (String)iterator.next();
                iterator.set(sql + ";");
            }
            FileUtils.writeLines((File)new File(scriptFile), script);
        }
    }

    protected ITableDataProvider loadTables(DbLoaderConfiguration configuration) throws ParserConfigurationException, SAXException, IOException {
        Resource tablesFile = configuration.getTablesFile();
        if (!tablesFile.exists()) {
            throw new IllegalArgumentException("Could not find tables file: " + configuration.getTablesFile());
        }
        SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
        TableXmlHandler dh = new TableXmlHandler(this.dialect);
        saxParser.parse(new InputSource(tablesFile.getInputStream()), (DefaultHandler)dh);
        return dh;
    }

    protected Dialect getDialect(String dialectName) {
        Dialect dialect;
        try {
            Class<?> dialectClass = Class.forName(dialectName);
            dialect = (Dialect)dialectClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No Hibernate Dialect Class found for configured Dialect '" + dialectName + "'", e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("No Hibernate Dialect Class found for configured Dialect '" + dialectName + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("No Hibernate Dialect Class found for configured Dialect '" + dialectName + "'", e);
        }
        return dialect;
    }

    protected List<String> dropScript(Collection<Table> tables, Dialect dialect, String defaultCatalog, String defaultSchema) {
        ArrayList<String> script = new ArrayList<String>(tables.size() * 2);
        if (dialect.dropConstraints()) {
            for (Table table : tables) {
                if (!table.isPhysicalTable()) continue;
                Iterator subIter = table.getForeignKeyIterator();
                while (subIter.hasNext()) {
                    ForeignKey fk = (ForeignKey)subIter.next();
                    if (!fk.isPhysicalConstraint()) continue;
                    script.add(fk.sqlDropString(dialect, defaultCatalog, defaultSchema));
                }
            }
        }
        for (Table table : tables) {
            if (!table.isPhysicalTable()) continue;
            script.add(table.sqlDropString(dialect, defaultCatalog, defaultSchema));
        }
        return script;
    }

    protected List<String> createScript(Collection<Table> tables, Dialect dialect, Mapping mapping, String defaultCatalog, String defaultSchema) {
        ArrayList<String> script = new ArrayList<String>(tables.size() * 2);
        for (Table table : tables) {
            if (!table.isPhysicalTable()) continue;
            script.add(table.sqlCreateString(dialect, mapping, defaultCatalog, defaultSchema));
        }
        for (Table table : tables) {
            Iterator subIter;
            if (!table.isPhysicalTable()) continue;
            if (!dialect.supportsUniqueConstraintInCreateAlterTable()) {
                subIter = table.getUniqueKeyIterator();
                while (subIter.hasNext()) {
                    UniqueKey uk = (UniqueKey)subIter.next();
                    String constraintString = uk.sqlCreateString(dialect, mapping, defaultCatalog, defaultSchema);
                    if (constraintString == null) continue;
                    script.add(constraintString);
                }
            }
            subIter = table.getIndexIterator();
            while (subIter.hasNext()) {
                Index index = (Index)subIter.next();
                script.add(index.sqlCreateString(dialect, mapping, defaultCatalog, defaultSchema));
            }
            if (!dialect.hasAlterTable()) continue;
            subIter = table.getForeignKeyIterator();
            while (subIter.hasNext()) {
                ForeignKey fk = (ForeignKey)subIter.next();
                if (!fk.isPhysicalConstraint()) continue;
                script.add(fk.sqlCreateString(dialect, mapping, defaultCatalog, defaultSchema));
            }
        }
        return script;
    }

    protected void populateTables(DbLoaderConfiguration configuration, Map<String, Map<String, Integer>> tableColumnTypes) throws ParserConfigurationException, SAXException, IOException {
        Resource dataFile = configuration.getDataFile();
        if (!dataFile.exists()) {
            throw new IllegalArgumentException("Could not find data file: " + configuration.getDataFile());
        }
        SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
        DataXmlHandler dh = new DataXmlHandler(this.jdbcTemplate, this.transactionTemplate, tableColumnTypes);
        saxParser.parse(new InputSource(dataFile.getInputStream()), (DefaultHandler)dh);
    }
}

