/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jasig.portal.url.IUrlGenerator;

public class AbstractPortalUrl {
    protected final HttpServletRequest request;
    protected final IUrlGenerator urlGenerator;
    protected final ConcurrentMap<String, List<String>> portalParameters = new ConcurrentHashMap<String, List<String>>();

    protected AbstractPortalUrl(HttpServletRequest request, IUrlGenerator urlGenerator) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Validate.notNull((Object)urlGenerator, (String)"urlGenerator can not be null");
        this.request = request;
        this.urlGenerator = urlGenerator;
    }

    public final Map<String, List<String>> getPortalParameters() {
        return this.portalParameters;
    }

    public final void setPortalParameter(String name, String ... values) {
        Validate.notNull((Object)name, (String)"name can not be null");
        Validate.noNullElements((Object[])values, (String)"values can not be null or contain null elements");
        ArrayList<String> valuesList = new ArrayList<String>(values.length);
        for (String value : values) {
            valuesList.add(value);
        }
        this.portalParameters.put(name, valuesList);
    }

    public final void setPortalParameters(Map<String, List<String>> parameters) {
        this.portalParameters.clear();
        this.portalParameters.putAll(parameters);
    }

    public String toString() {
        return this.portalParameters.toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(-942605321, 2130461357).append(this.portalParameters).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractPortalUrl)) {
            return false;
        }
        AbstractPortalUrl rhs = (AbstractPortalUrl)object;
        return new EqualsBuilder().append(this.portalParameters, rhs.portalParameters).isEquals();
    }
}

