/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.url.AbstractHttpServletRequestWrapper;
import org.jasig.portal.url.IWritableHttpServletRequest;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.jasig.portal.utils.ArrayEnumerator;

public class PortalHttpServletRequestWrapper
extends AbstractHttpServletRequestWrapper
implements IWritableHttpServletRequest {
    public static final String ATTRIBUTE__HTTP_SERVLET_REQUEST = PortalHttpServletRequestWrapper.class.getName() + ".PORTAL_HTTP_SERVLET_REQUEST";
    public static final String ATTRIBUTE__HTTP_SERVLET_RESPONSE = PortalHttpServletRequestWrapper.class.getName() + ".PORTAL_HTTP_SERVLET_RESPONSE";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final HttpServletResponse httpServletResponse;
    private final IUserInstanceManager userInstanceManager;
    private final Map<String, String[]> parameterMap = new HashMap<String, String[]>();

    public PortalHttpServletRequestWrapper(HttpServletRequest request, HttpServletResponse response, IUserInstanceManager userInstanceManager) {
        super(request);
        Validate.notNull((Object)response);
        Validate.notNull((Object)userInstanceManager);
        this.parameterMap.putAll(request.getParameterMap());
        this.httpServletResponse = response;
        this.userInstanceManager = userInstanceManager;
    }

    @Override
    public Object getAttribute(String name) {
        if (ATTRIBUTE__HTTP_SERVLET_REQUEST.equals(name)) {
            return this;
        }
        if (ATTRIBUTE__HTTP_SERVLET_RESPONSE.equals(name)) {
            return this.httpServletResponse;
        }
        return super.getAttribute(name);
    }

    @Override
    public boolean addParameterValue(String name, String value) {
        Validate.notNull((Object)name, (String)"name can not be null");
        Validate.notNull((Object)value, (String)"value can not be null");
        Object[] currentValues = this.parameterMap.get(name);
        String[] newValues = currentValues == null ? new String[]{value} : (String[])ArrayUtils.add((Object[])currentValues, (Object)value);
        this.parameterMap.put(name, newValues);
        return currentValues != null;
    }

    @Override
    public boolean setParameterValue(String name, String value) {
        Validate.notNull((Object)name, (String)"name can not be null");
        Validate.notNull((Object)value, (String)"value can not be null");
        return this.parameterMap.put(name, new String[]{value}) != null;
    }

    @Override
    public boolean setParameterValues(String name, String[] values) {
        Validate.notNull((Object)name, (String)"name can not be null");
        Validate.notNull((Object)values, (String)"values can not be null");
        Validate.noNullElements((Object[])values, (String)"values can not contain null elements");
        return this.parameterMap.put(name, values) != null;
    }

    @Override
    public boolean deleteParameter(String name) {
        Validate.notNull((Object)name, (String)"name can not be null");
        return this.parameterMap.remove(name) != null;
    }

    @Override
    public boolean deleteParameterValue(String name, String value) {
        Validate.notNull((Object)name, (String)"name can not be null");
        Validate.notNull((Object)value, (String)"value can not be null");
        String[] currentValues = this.parameterMap.get(name);
        if (currentValues == null) {
            return false;
        }
        ArrayList<String> newValues = new ArrayList<String>(currentValues.length);
        for (String currentValue : currentValues) {
            if (value == currentValue || value.equals(currentValue)) continue;
            newValues.add(currentValue);
        }
        this.parameterMap.put(name, newValues.toArray(new String[newValues.size()]));
        return currentValues.length != newValues.size();
    }

    @Override
    public String getParameter(String name) {
        Validate.notNull((Object)name, (String)"name can not be null");
        String[] pValues = this.parameterMap.get(name);
        if (pValues != null && pValues.length > 0) {
            return pValues[0];
        }
        return null;
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameterMap.keySet());
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.parameterMap.get(name);
    }

    @Override
    public String getRemoteUser() {
        Principal userPrincipal = this.getUserPrincipal();
        if (userPrincipal == null) {
            return null;
        }
        return userPrincipal.getName();
    }

    @Override
    public Principal getUserPrincipal() {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(this.getWrappedRequest());
        IPerson person = userInstance.getPerson();
        if (person == null || person.isGuest()) {
            return null;
        }
        return person;
    }

    @Override
    public boolean isUserInRole(String role) {
        boolean isUserInRole = super.isUserInRole(role);
        if (isUserInRole) {
            return true;
        }
        IGroupMember groupForRole = GroupService.findGroup(role);
        if (groupForRole == null) {
            EntityIdentifier[] results = GroupService.searchForGroups(role, 1, IPerson.class);
            if (results == null || results.length == 0) {
                return false;
            }
            if (results.length > 1) {
                this.logger.warn((Object)(results.length + " groups were found for role '" + role + "'. The first result will be used."));
            }
            groupForRole = GroupService.getGroupMember(results[0]);
        }
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(this.getWrappedRequest());
        IPerson person = userInstance.getPerson();
        EntityIdentifier personEntityId = person.getEntityIdentifier();
        IGroupMember personGroupMember = GroupService.getGroupMember(personEntityId);
        return personGroupMember.isDeepMemberOf(groupForRole);
    }

    @Override
    public Locale getLocale() {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(this.getWrappedRequest());
        LocaleManager localeManager = userInstance.getLocaleManager();
        Locale[] locales = localeManager.getLocales();
        return locales[0];
    }

    @Override
    public Enumeration<Locale> getLocales() {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(this.getWrappedRequest());
        LocaleManager localeManager = userInstance.getLocaleManager();
        Locale[] locales = localeManager.getLocales();
        return new ArrayEnumerator<Locale>(locales);
    }
}

