/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jasig.portal.url.AbstractPortalUrl;
import org.jasig.portal.url.IPortalLayoutUrl;
import org.jasig.portal.url.IUrlGenerator;

class PortalLayoutUrlImpl
extends AbstractPortalUrl
implements IPortalLayoutUrl {
    private final String targetFolderId;
    private boolean renderInNormal;

    public PortalLayoutUrlImpl(HttpServletRequest request, IUrlGenerator urlGenerator, String targetFolderId) {
        super(request, urlGenerator);
        Validate.notNull((Object)targetFolderId, (String)"targetFolderId can not be null");
        this.targetFolderId = targetFolderId;
    }

    @Override
    public boolean isRenderInNormal() {
        return this.renderInNormal;
    }

    @Override
    public void setRenderInNormal(boolean renderInNormal) {
        this.renderInNormal = renderInNormal;
    }

    @Override
    public String toString() {
        return this.urlGenerator.generatePortalUrl(this.request, this, this.targetFolderId);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(-942605321, 2130461357).appendSuper(super.hashCode()).append(this.renderInNormal).append((Object)this.targetFolderId).toHashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PortalLayoutUrlImpl)) {
            return false;
        }
        PortalLayoutUrlImpl rhs = (PortalLayoutUrlImpl)object;
        return new EqualsBuilder().appendSuper(super.equals(object)).append((Object)this.targetFolderId, (Object)rhs.targetFolderId).append(this.renderInNormal, rhs.renderInNormal).isEquals();
    }
}

