/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.url.AbstractPortalUrl;
import org.jasig.portal.url.IPortalPortletUrl;
import org.jasig.portal.url.IUrlGenerator;

class PortalPortletUrlImpl
extends AbstractPortalUrl
implements IPortalPortletUrl {
    private final IPortletWindowId portletWindowId;
    private final ConcurrentMap<String, List<String>> portletParameters = new ConcurrentHashMap<String, List<String>>();
    private WindowState windowState = null;
    private PortletMode portletMode = null;
    private boolean action = false;

    public PortalPortletUrlImpl(HttpServletRequest request, IUrlGenerator urlGenerator, IPortletWindowId portletWindowId) {
        super(request, urlGenerator);
        Validate.notNull((Object)portletWindowId, (String)"portletWindowId can not be null");
        this.portletWindowId = portletWindowId;
    }

    @Override
    public PortletMode getPortletMode() {
        return this.portletMode;
    }

    @Override
    public Map<String, List<String>> getPortletParameters() {
        return this.portletParameters;
    }

    @Override
    public WindowState getWindowState() {
        return this.windowState;
    }

    @Override
    public boolean isAction() {
        return this.action;
    }

    @Override
    public void setAction(boolean action) {
        this.action = action;
    }

    @Override
    public void setPortletMode(PortletMode portletMode) {
        this.portletMode = portletMode;
    }

    @Override
    public void setPortletParameter(String name, String ... values) {
        Validate.notNull((Object)name, (String)"name can not be null");
        Validate.noNullElements((Object[])values, (String)"values can not be null or contain null elements");
        ArrayList<String> valuesList = new ArrayList<String>(values.length);
        for (String value : values) {
            valuesList.add(value);
        }
        this.portletParameters.put(name, valuesList);
    }

    @Override
    public void setPortletParameters(Map<String, List<String>> parameters) {
        this.portletParameters.clear();
        this.portletParameters.putAll(parameters);
    }

    @Override
    public void setWindowState(WindowState windowState) {
        this.windowState = windowState;
    }

    @Override
    public String toString() {
        return this.urlGenerator.generatePortletUrl(this.request, this, this.portletWindowId);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(-942605321, 2130461357).appendSuper(super.hashCode()).append((Object)this.portletWindowId).append((Object)this.windowState).append((Object)this.portletMode).append(this.action).toHashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PortalPortletUrlImpl)) {
            return false;
        }
        PortalPortletUrlImpl rhs = (PortalPortletUrlImpl)object;
        return new EqualsBuilder().appendSuper(super.equals(object)).append((Object)this.portletWindowId, (Object)rhs.portletWindowId).append((Object)this.windowState, (Object)rhs.windowState).append((Object)this.portletMode, (Object)rhs.portletMode).append(this.action, rhs.action).isEquals();
    }
}

