/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url.processing;

import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlet.url.IPortletRequestParameterManager;
import org.jasig.portal.portlet.url.IPortletUrlSyntaxProvider;
import org.jasig.portal.portlet.url.PortletUrl;
import org.jasig.portal.url.IWritableHttpServletRequest;
import org.jasig.portal.url.processing.IRequestParameterProcessor;
import org.springframework.beans.factory.annotation.Required;

public class PortletRequestParameterProcessor
implements IRequestParameterProcessor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IPortletUrlSyntaxProvider portletUrlSyntaxProvider;
    private IPortletRequestParameterManager portletRequestParameterManager;
    private IPortletWindowRegistry portletWindowRegistry;

    public IPortletUrlSyntaxProvider getPortletUrlSyntaxProvider() {
        return this.portletUrlSyntaxProvider;
    }

    @Required
    public void setPortletUrlSyntaxProvider(IPortletUrlSyntaxProvider portletUrlSyntaxProvider) {
        Validate.notNull((Object)portletUrlSyntaxProvider, (String)"portletUrlSyntaxProvider can not be null");
        this.portletUrlSyntaxProvider = portletUrlSyntaxProvider;
    }

    public IPortletRequestParameterManager getPortletRequestParameterManager() {
        return this.portletRequestParameterManager;
    }

    @Required
    public void setPortletRequestParameterManager(IPortletRequestParameterManager portletRequestParameterManager) {
        Validate.notNull((Object)portletRequestParameterManager, (String)"portletRequestParameterManager can not be null");
        this.portletRequestParameterManager = portletRequestParameterManager;
    }

    public IPortletWindowRegistry getPortletWindowRegistry() {
        return this.portletWindowRegistry;
    }

    @Required
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        Validate.notNull((Object)portletWindowRegistry, (String)"portletWindowRegistry can not be null");
        this.portletWindowRegistry = portletWindowRegistry;
    }

    @Override
    public boolean processParameters(IWritableHttpServletRequest request, HttpServletResponse response) {
        PortletUrl portletUrl = this.portletUrlSyntaxProvider.parsePortletUrl(request);
        this.portletRequestParameterManager.setTargetedPortletUrl(request, portletUrl);
        return true;
    }
}

