/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.jasig.portal.url.processing.RequestParameterProcessingIncompleteException;
import org.jasig.portal.url.support.IChannelRequestParameterManager;

public class ChannelRequestParameterManager
implements IChannelRequestParameterManager {
    protected static final String CHANNEL_PARAMETER_MAP_ATTRIBUTE = ChannelRequestParameterManager.class.getName() + ".CHANNEL_PARAMETER_MAP";
    protected static final Map<String, Map<String, Object[]>> NO_PARAMETERS = Collections.emptyMap();

    @Override
    public Map<String, Object[]> getChannelParameters(HttpServletRequest request, String channelId) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Validate.notNull((Object)channelId, (String)"channelId can not be null");
        Map<String, Map<String, Object[]>> channelParamMaps = this.getAndCheckChannelParameterMaps(request);
        if (channelParamMaps == null) {
            return null;
        }
        return channelParamMaps.get(channelId);
    }

    @Override
    public Set<String> getTargetedChannelIds(HttpServletRequest request) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Map<String, Map<String, Object[]>> channelParamMaps = this.getAndCheckChannelParameterMaps(request);
        if (channelParamMaps == null) {
            return Collections.emptySet();
        }
        return channelParamMaps.keySet();
    }

    @Override
    public void setChannelParameters(HttpServletRequest request, String channelId, Map<String, Object[]> parameters) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Validate.notNull((Object)channelId, (String)"channelId can not be null");
        Validate.notNull(parameters, (String)"parameters can not be null");
        Map<String, Map<String, Object[]>> channelParamMaps = this.getChannelParametersMap(request);
        if (channelParamMaps == NO_PARAMETERS) {
            throw new IllegalStateException("Cannot set channel parameters after setNoChannelParameters(HttpServletRequest) has been called.");
        }
        if (channelParamMaps == null) {
            channelParamMaps = new HashMap<String, Map<String, Object[]>>();
        }
        channelParamMaps.put(channelId, parameters);
        request.setAttribute(CHANNEL_PARAMETER_MAP_ATTRIBUTE, channelParamMaps);
    }

    @Override
    public void setNoChannelParameters(HttpServletRequest request) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Map<String, Map<String, Object[]>> channelParamMaps = this.getChannelParametersMap(request);
        if (channelParamMaps != null) {
            throw new IllegalStateException("Cannot set no channel parameters after setChannelParameters(HttpServletRequest, String, Map) has been called.");
        }
        request.setAttribute(CHANNEL_PARAMETER_MAP_ATTRIBUTE, NO_PARAMETERS);
    }

    protected Map<String, Map<String, Object[]>> getAndCheckChannelParameterMaps(HttpServletRequest request) {
        Map<String, Map<String, Object[]>> channelParamMaps = this.getChannelParametersMap(request);
        if (channelParamMaps == null) {
            throw new RequestParameterProcessingIncompleteException("No channel parameter processing has been completed on this request");
        }
        if (channelParamMaps == NO_PARAMETERS) {
            return null;
        }
        return channelParamMaps;
    }

    protected Map<String, Map<String, Object[]>> getChannelParametersMap(HttpServletRequest request) {
        return (Map)request.getAttribute(CHANNEL_PARAMETER_MAP_ATTRIBUTE);
    }
}

