/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.io.InputStream;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DTDResolver
implements EntityResolver {
    private static final String dtdPath = "/dtd";
    private static final PublicId[] publicIds = new PublicId[]{new PublicId("-//Netscape Communications//DTD RSS 0.91//EN", "rss-0.91.dtd"), new PublicId("-//uPortal//Tables/EN", "tables.dtd"), new PublicId("-//uPortal//PersonDirs/EN", "PersonDirs.dtd"), new PublicId("-//uPortal//Channel Publishing/EN", "channelPublishingDocument.dtd"), new PublicId("-//uPortal//Data/EN", "data.dtd"), new PublicId("-//uPortal//PAGSGroupStore/EN", "PAGSGroupStore.dtd"), new PublicId("-//uPortal//LDAPGroupStore/EN", "LDAPGroupStore.dtd"), new PublicId("-//uPortal//Services/EN", "services.dtd"), new PublicId("-//W3C//DTD XHTML 1.0 Transitional//EN", "xhtml1-transitional.dtd"), new PublicId("-//W3C//DTD XHTML 1.0 Strict//EN", "xhtml1-strict.dtd"), new PublicId("-//W3C//ENTITIES Latin 1 for XHTML//EN", "xhtml-lat1.ent"), new PublicId("-//W3C//ENTITIES Symbols for XHTML//EN", "xhtml-symbol.ent"), new PublicId("-//W3C//ENTITIES Special for XHTML//EN", "xhtml-special.ent")};
    private String dtdName = null;

    public DTDResolver() {
    }

    public DTDResolver(String dtdName) {
        this.dtdName = dtdName;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        InputStream inStream = null;
        if (systemId != null) {
            if (this.dtdName != null && systemId.indexOf(this.dtdName) != -1) {
                inStream = this.getResourceAsStream("/dtd/" + this.dtdName);
            } else if (systemId.trim().equalsIgnoreCase("http://my.netscape.com/publish/formats/rss-0.91.dtd")) {
                inStream = this.getResourceAsStream("/dtd/rss-0.91.dtd");
            }
            if (null != inStream) {
                return new InputSource(inStream);
            }
        }
        if (publicId != null) {
            publicId = publicId.trim();
            for (int i = 0; i < publicIds.length; ++i) {
                if (!publicId.equalsIgnoreCase(DTDResolver.publicIds[i].publicId)) continue;
                inStream = this.getResourceAsStream(DTDResolver.publicIds[i].dtdFile);
                if (null == inStream) break;
                return new InputSource(inStream);
            }
        }
        return null;
    }

    public InputStream getResourceAsStream(String resource) {
        return DTDResolver.class.getResourceAsStream(resource);
    }

    private static class PublicId {
        public String publicId;
        public String dtdFile;

        public PublicId(String publicId, String dtdFile) {
            this.publicId = publicId;
            this.dtdFile = "/dtd/" + dtdFile;
        }
    }
}

