/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentFactory {
    private static final Log log = LogFactory.getLog(DocumentFactory.class);
    protected static DocumentFactory _instance;
    protected static final LocalDocumentBuilder localDocBuilder;
    protected DocumentBuilderFactory dbFactory = null;

    protected static synchronized DocumentFactory instance() {
        if (_instance == null) {
            _instance = new DocumentFactory();
        }
        return _instance;
    }

    protected DocumentFactory() {
        try {
            this.dbFactory = DocumentBuilderFactory.newInstance();
            this.dbFactory.setNamespaceAware(true);
            this.dbFactory.setValidating(false);
        }
        catch (Exception e) {
            log.error((Object)"DocumentFactory: unable to initialize DocumentBuilderFactory", (Throwable)e);
        }
    }

    public static Document getNewDocument() {
        return DocumentFactory.newDocumentBuilder().newDocument();
    }

    static Document __getNewDocument() {
        Document doc = DocumentFactory.newDocumentBuilder().newDocument();
        return doc;
    }

    public static Document getDocumentFromStream(InputStream stream, String publicId) throws IOException, SAXException {
        DocumentBuilder builder = DocumentFactory.newDocumentBuilder();
        InputSource source = new InputSource(stream);
        source.setPublicId(publicId);
        Document doc = builder.parse(source);
        return doc;
    }

    public static Document getDocumentFromStream(InputStream stream, EntityResolver er, String publicId) throws IOException, SAXException {
        DocumentBuilder builder = DocumentFactory.newDocumentBuilder();
        builder.setEntityResolver(er);
        InputSource source = new InputSource(stream);
        source.setPublicId(publicId);
        Document doc = builder.parse(source);
        return doc;
    }

    public static DocumentBuilder newDocumentBuilder() {
        DocumentBuilder builder = (DocumentBuilder)localDocBuilder.get();
        return builder;
    }

    static {
        localDocBuilder = new LocalDocumentBuilder();
    }

    protected static class LocalDocumentBuilder
    extends ThreadLocal {
        protected LocalDocumentBuilder() {
        }

        protected Object initialValue() {
            DocumentBuilder r = null;
            try {
                r = DocumentFactory.instance().dbFactory.newDocumentBuilder();
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
            return r;
        }
    }
}

