/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.utils.ICounterStore;

@Deprecated
public class RDBMCounterStore
implements ICounterStore {
    private static final Log log = LogFactory.getLog(RDBMCounterStore.class);

    @Override
    public synchronized void createCounter(String counterName) throws Exception {
        Connection con = RDBMServices.getConnection();
        Statement createCounterPstmt = null;
        try {
            int updateCount;
            RDBMServices.setAutoCommit(con, false);
            String createCounterInsert = "INSERT INTO UP_SEQUENCE (SEQUENCE_NAME, SEQUENCE_VALUE) VALUES (?, 0)";
            createCounterPstmt = con.prepareStatement(createCounterInsert);
            createCounterPstmt.setString(1, counterName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("RDBMCounterStore::createCounter(" + counterName + "): " + createCounterInsert));
            }
            if ((updateCount = createCounterPstmt.executeUpdate()) <= 0) {
                PortalException pe = new PortalException("RDBMCounterStore::createCounter(): An error occured while creating the counter named: " + counterName + ".\nNo rows were created.");
                log.error((Object)("RDBMCounterStore::createCounter(): An error occured while creating the counter named: " + counterName + ".\nNo rows were created."), (Throwable)pe);
                throw pe;
            }
            RDBMServices.commit(con);
        }
        catch (SQLException sqle) {
            RDBMServices.rollback(con);
            PortalException pe = new PortalException("RDBMCounterStore::createCounter(): An error occured while creating the counter named: " + counterName, (Throwable)sqle);
            log.error((Object)("RDBMCounterStore::createCounter(): An error occured while creating the counter named: " + counterName), (Throwable)pe);
            throw pe;
        }
        finally {
            try {
                createCounterPstmt.close();
            }
            catch (Exception e) {}
            RDBMServices.releaseConnection(con);
        }
    }

    @Override
    public synchronized void setCounter(String counterName, int value) throws Exception {
        Connection con = RDBMServices.getConnection();
        Statement setCounterPstmt = null;
        try {
            int updateCount;
            RDBMServices.setAutoCommit(con, false);
            String setCounterUpdate = "UPDATE UP_SEQUENCE SET SEQUENCE_VALUE=? WHERE SEQUENCE_NAME=?";
            setCounterPstmt = con.prepareStatement(setCounterUpdate);
            setCounterPstmt.setInt(1, value);
            setCounterPstmt.setString(2, counterName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("RDBMCounterStore::setCounter(" + counterName + ", " + value + "): " + setCounterUpdate));
            }
            if ((updateCount = setCounterPstmt.executeUpdate()) <= 0) {
                PortalException pe = new PortalException("RDBMCounterStore::setCounter(): An error occured while setting the counter named: " + counterName + ".\nNo rows were updated.");
                log.error((Object)pe, (Throwable)pe);
                throw pe;
            }
            RDBMServices.commit(con);
        }
        catch (SQLException sqle) {
            RDBMServices.rollback(con);
            PortalException pe = new PortalException("RDBMCounterStore::createCounter(): An error occured while creating the counter named: " + counterName, (Throwable)sqle);
            log.error((Object)pe, (Throwable)pe);
            throw pe;
        }
        finally {
            try {
                setCounterPstmt.close();
            }
            catch (Exception e) {}
            RDBMServices.releaseConnection(con);
        }
    }

    @Override
    public synchronized int getIncrementIntegerId(String counterName) throws Exception {
        Connection con = RDBMServices.getConnection();
        Statement getCounterPstmt = null;
        Statement updateCounterPstmt = null;
        ResultSet rs = null;
        try {
            String getCounterQuery = "SELECT SEQUENCE_VALUE FROM UP_SEQUENCE WHERE SEQUENCE_NAME=?";
            String updateCounterQuery = "UPDATE UP_SEQUENCE SET SEQUENCE_VALUE=? WHERE SEQUENCE_NAME=? AND SEQUENCE_VALUE=?";
            getCounterPstmt = con.prepareStatement(getCounterQuery);
            getCounterPstmt.setString(1, counterName);
            updateCounterPstmt = con.prepareStatement(updateCounterQuery);
            updateCounterPstmt.setString(2, counterName);
            for (int i = 0; i < 25; ++i) {
                int rowsUpdated;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RDBMCounterStore::getIncrementInteger(" + counterName + "): " + getCounterQuery));
                }
                if (!(rs = getCounterPstmt.executeQuery()).next()) {
                    try {
                        this.createCounter(counterName);
                    }
                    catch (Exception e) {
                        throw new PortalException("RDBMCounterStore::getIncrementInteger(): Could not create new counter for name: " + counterName, (Throwable)e);
                    }
                    rs = getCounterPstmt.executeQuery();
                    if (!rs.next()) {
                        throw new PortalException("RDBMCounterStore::getIncrementInteger(): Counter should have been created but was not found, name: " + counterName);
                    }
                }
                int origId = rs.getInt(1);
                int nextId = origId + 1;
                updateCounterPstmt.setInt(1, nextId);
                updateCounterPstmt.setInt(3, origId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RDBMCounterStore::getIncrementInteger(" + counterName + ", " + nextId + ", " + origId + "): " + updateCounterQuery));
                }
                if ((rowsUpdated = updateCounterPstmt.executeUpdate()) > 0) {
                    int n = nextId;
                    return n;
                }
                Thread.sleep(Math.round(Math.random() * 3.0 * 1000.0));
            }
        }
        catch (SQLException sqle) {
            PortalException pe = new PortalException("RDBMCounterStore::getIncrementInteger(): An error occured while updating the counter, name: " + counterName, (Throwable)sqle);
            log.error((Object)pe, (Throwable)pe);
            throw pe;
        }
        finally {
            try {
                getCounterPstmt.close();
            }
            catch (Exception e) {}
            try {
                updateCounterPstmt.close();
            }
            catch (Exception e) {}
            try {
                rs.close();
            }
            catch (Exception e) {}
            RDBMServices.releaseConnection(con);
        }
        PortalException pe = new PortalException("RDBMCounterStore::getIncrementInteger(): Unable to increment counter for " + counterName);
        log.error((Object)pe, (Throwable)pe);
        throw pe;
    }
}

