/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ResourceMissingException;
import org.jasig.portal.car.CarResources;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.utils.DTDResolver;
import org.jasig.portal.utils.SAXErrorHandler;
import org.jasig.portal.utils.Tuple;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ResourceLoader {
    private static final Log log = LogFactory.getLog(ResourceLoader.class);
    private static DocumentBuilderFactory validatingDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
    private static DocumentBuilderFactory nonValidatingDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
    private static Map<Tuple<Class<?>, String>, URL> resourceUrlCache;
    private static Map<Tuple<Class<?>, String>, ResourceMissingException> resourceUrlNotFoundCache;

    public Map<Tuple<Class<?>, String>, URL> getResourceUrlCache() {
        return resourceUrlCache;
    }

    public void setResourceUrlCache(Map<Tuple<Class<?>, String>, URL> resourceUrlCache) {
        ResourceLoader.resourceUrlCache = resourceUrlCache;
    }

    public Map<Tuple<Class<?>, String>, ResourceMissingException> getResourceUrlNotFoundCache() {
        return resourceUrlNotFoundCache;
    }

    public void setResourceUrlNotFoundCache(Map<Tuple<Class<?>, String>, ResourceMissingException> resourceUrlNotFoundCache) {
        ResourceLoader.resourceUrlNotFoundCache = resourceUrlNotFoundCache;
    }

    public static URL getResourceAsURL(Class<?> requestingClass, String resource) throws ResourceMissingException {
        URL resourceURL;
        Map<Tuple<Class<?>, String>, URL> resourceUrlCache;
        Tuple cacheKey;
        block7: {
            ResourceMissingException exception;
            cacheKey = new Tuple(requestingClass, resource);
            resourceUrlCache = ResourceLoader.resourceUrlCache;
            URL uRL = resourceURL = resourceUrlCache != null ? resourceUrlCache.get(cacheKey) : null;
            if (resourceURL != null) {
                return resourceURL;
            }
            Map<Tuple<Class<?>, String>, ResourceMissingException> resourceUrlNotFoundCache = ResourceLoader.resourceUrlNotFoundCache;
            ResourceMissingException resourceMissingException = exception = resourceUrlNotFoundCache != null ? resourceUrlNotFoundCache.get(cacheKey) : null;
            if (exception != null) {
                throw new ResourceMissingException(exception);
            }
            try {
                resourceURL = new URL(resource);
            }
            catch (MalformedURLException murle) {
                resourceURL = requestingClass.getResource(resource);
                if (resourceURL == null) {
                    resourceURL = CarResources.getInstance().getClassLoader().getResource(resource);
                }
                if (resourceURL != null) break block7;
                String resourceRelativeToClasspath = null;
                resourceRelativeToClasspath = resource.startsWith("/") ? resource : '/' + requestingClass.getPackage().getName().replace('.', '/') + '/' + resource;
                exception = new ResourceMissingException(resource, resourceRelativeToClasspath, "Resource not found in classpath: " + resourceRelativeToClasspath);
                if (resourceUrlNotFoundCache != null) {
                    resourceUrlNotFoundCache.put(cacheKey, exception);
                }
                throw new ResourceMissingException(exception);
            }
        }
        if (resourceUrlCache != null) {
            resourceUrlCache.put(cacheKey, resourceURL);
        }
        return resourceURL;
    }

    public static String getResourceAsURLString(Class<?> requestingClass, String resource) throws ResourceMissingException {
        return ResourceLoader.getResourceAsURL(requestingClass, resource).toString();
    }

    public static long getResourceLastModified(Class<?> requestingClass, String resource) {
        URL contentUrl = ResourceLoader.getResourceAsURL(requestingClass, resource);
        String contentFileName = contentUrl.getFile();
        int delimIndex = contentFileName.indexOf(33);
        File contentFile = delimIndex > 0 ? new File(contentFileName.substring(0, delimIndex)) : new File(contentFileName);
        return contentFile.lastModified();
    }

    public static InputStream getResourceAsStream(Class<?> requestingClass, String resource) throws ResourceMissingException, IOException {
        return ResourceLoader.getResourceAsURL(requestingClass, resource).openStream();
    }

    public static InputSource getResourceAsSAXInputSource(Class<?> requestingClass, String resource) throws ResourceMissingException, IOException {
        URL url = ResourceLoader.getResourceAsURL(requestingClass, resource);
        InputSource source = new InputSource(url.openStream());
        source.setPublicId(url.toExternalForm());
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getResourceAsDocument(Class<?> requestingClass, String resource, boolean validate) throws ResourceMissingException, IOException, ParserConfigurationException, SAXException {
        Document document = null;
        InputStream inputStream = null;
        try {
            DocumentBuilderFactory factoryToUse = null;
            factoryToUse = validate ? validatingDocumentBuilderFactory : nonValidatingDocumentBuilderFactory;
            inputStream = ResourceLoader.getResourceAsStream(requestingClass, resource);
            DocumentBuilder db = factoryToUse.newDocumentBuilder();
            db.setEntityResolver(new DTDResolver());
            db.setErrorHandler(new SAXErrorHandler("ResourceLoader.getResourceAsDocument(" + resource + ")"));
            document = db.parse(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return document;
    }

    public static Document getResourceAsDocument(Class<?> requestingClass, String resource) throws ResourceMissingException, IOException, ParserConfigurationException, SAXException {
        return ResourceLoader.getResourceAsDocument(requestingClass, resource, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getResourceAsProperties(Class<?> requestingClass, String resource) throws ResourceMissingException, IOException {
        InputStream inputStream = null;
        Properties props = null;
        try {
            inputStream = ResourceLoader.getResourceAsStream(requestingClass, resource);
            props = new Properties();
            props.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResourceAsString(Class<?> requestingClass, String resource) throws ResourceMissingException, IOException {
        String line = null;
        BufferedReader in = null;
        StringBuffer sbText = null;
        try {
            in = new BufferedReader(new InputStreamReader(ResourceLoader.getResourceAsStream(requestingClass, resource)));
            sbText = new StringBuffer(1024);
            while ((line = in.readLine()) != null) {
                sbText.append(line).append("\n");
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return sbText.toString();
    }

    static {
        validatingDocumentBuilderFactory.setValidating(true);
        nonValidatingDocumentBuilderFactory.setValidating(false);
        validatingDocumentBuilderFactory.setNamespaceAware(true);
        nonValidatingDocumentBuilderFactory.setNamespaceAware(true);
        try {
            String handler = PropertiesManager.getProperty("org.jasig.portal.utils.ResourceLoader.HttpsHandler");
            if (System.getProperty("java.protocol.handler.pkgs") != null && !System.getProperty("java.protocol.handler.pkgs").equals("")) {
                handler = handler + "|" + System.getProperty("java.protocol.handler.pkgs");
            }
            System.setProperty("java.protocol.handler.pkgs", handler);
        }
        catch (Exception e) {
            log.error((Object)"Unable to set HTTPS Protocol handler", (Throwable)e);
        }
    }
}

