/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.util.Enumeration;
import java.util.Vector;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.utils.SAX2FilterImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SAX2BufferImpl
extends SAX2FilterImpl {
    protected Vector eventTypes;
    protected Vector eventArguments;
    protected boolean buffering = true;
    protected boolean outputAtDocumentEnd = false;
    private static final int ISTARTDOCUMENT = 0;
    private static final int IENDDOCUMENT = 1;
    private static final int ISTARTELEMENT = 2;
    private static final int IENDELEMENT = 3;
    private static final int ICHARACTERS = 4;
    private static final int IIGNORABLEWHITESPACE = 5;
    private static final int IPROCESSINGINSTRUCTION = 6;
    private static final int INOTATIONDECL = 7;
    private static final int IUNPARSEDENTITYDECL = 8;
    private static final int ISTARTPREFIXMAPPING = 9;
    private static final int IENDPREFIXMAPPING = 10;
    private static final int ISKIPPEDENTITY = 11;
    private static final int IWARNING = 12;
    private static final int IERROR = 13;
    private static final int IFATALERROR = 14;
    private static final int ICOMMENT = 15;
    private static final int ISTARTCDATA = 16;
    private static final int IENDCDATA = 17;
    private static final int ISTARTDTD = 18;
    private static final int IENDDTD = 19;
    private static final int ISTARTENTITY = 20;
    private static final int IENDENTITY = 21;
    public static final Integer STARTDOCUMENT = new Integer(0);
    public static final Integer ENDDOCUMENT = new Integer(1);
    public static final Integer STARTELEMENT = new Integer(2);
    public static final Integer ENDELEMENT = new Integer(3);
    public static final Integer CHARACTERS = new Integer(4);
    public static final Integer IGNORABLEWHITESPACE = new Integer(5);
    public static final Integer PROCESSINGINSTRUCTION = new Integer(6);
    public static final Integer NOTATIONDECL = new Integer(7);
    public static final Integer UNPARSEDENTITYDECL = new Integer(8);
    public static final Integer STARTPREFIXMAPPING = new Integer(9);
    public static final Integer ENDPREFIXMAPPING = new Integer(10);
    public static final Integer SKIPPEDENTITY = new Integer(11);
    public static final Integer WARNING = new Integer(12);
    public static final Integer ERROR = new Integer(13);
    public static final Integer FATALERROR = new Integer(14);
    public static final Integer COMMENT = new Integer(15);
    public static final Integer STARTCDATA = new Integer(16);
    public static final Integer ENDCDATA = new Integer(17);
    public static final Integer STARTDTD = new Integer(18);
    public static final Integer ENDDTD = new Integer(19);
    public static final Integer STARTENTITY = new Integer(20);
    public static final Integer ENDENTITY = new Integer(21);
    protected boolean copyCharBlock = PropertiesManager.getPropertyAsBoolean(SAX2BufferImpl.class.getName() + ".copyCharBlock", true);

    public SAX2BufferImpl() {
        this.eventTypes = new Vector();
        this.eventArguments = new Vector();
    }

    public SAX2BufferImpl(XMLReader parent) {
        this();
        this.setParent(parent);
    }

    public SAX2BufferImpl(ContentHandler ch, EntityResolver er, ErrorHandler eh, LexicalHandler lh, DTDHandler dh) {
        super(ch, er, eh, lh, dh);
        this.eventTypes = new Vector();
        this.eventArguments = new Vector();
    }

    public SAX2BufferImpl(ContentHandler ch) {
        super(ch);
        this.eventTypes = new Vector();
        this.eventArguments = new Vector();
    }

    public void setOutputAtDocumentEnd(boolean setting) {
        this.outputAtDocumentEnd = setting;
    }

    public synchronized void clearBuffer() {
        this.eventTypes.clear();
        this.eventArguments.clear();
    }

    public synchronized void stopBuffering() throws SAXException {
        this.buffering = false;
    }

    public synchronized void startBuffering() {
        this.buffering = true;
    }

    public synchronized boolean isEmpty() {
        return this.eventTypes.isEmpty();
    }

    public void outputBuffer() throws SAXException {
        if (this.contentHandler != null) {
            this.outputBuffer(this.contentHandler, this.dtdHandler, this.errorHandler, this.lexicalHandler);
        }
    }

    public void outputBuffer(ContentHandler ch) throws SAXException {
        if (ch != null) {
            DTDHandler dtdh = null;
            if (ch instanceof DTDHandler) {
                dtdh = (DTDHandler)((Object)ch);
            }
            ErrorHandler erh = null;
            if (ch instanceof ErrorHandler) {
                erh = (ErrorHandler)((Object)ch);
            }
            LexicalHandler lh = null;
            if (ch instanceof LexicalHandler) {
                lh = (LexicalHandler)((Object)ch);
            }
            this.outputBuffer(ch, dtdh, erh, lh);
        }
    }

    private void outputBuffer(ContentHandler ch, DTDHandler dtdh, ErrorHandler erh, LexicalHandler lh) throws SAXException {
        Enumeration args = this.eventArguments.elements();
        Enumeration types = this.eventTypes.elements();
        block5: while (types.hasMoreElements()) {
            CharBlock cd;
            TwoString ts;
            ThreeString ths;
            int type = (Integer)types.nextElement();
            if (2 == type) {
                StartElementData sed = (StartElementData)args.nextElement();
                ch.startElement(sed.getURI(), sed.getLocalName(), sed.getQName(), sed.getAtts());
                continue;
            }
            if (3 == type) {
                ths = (ThreeString)args.nextElement();
                ch.endElement(ths.first, ths.second, ths.third);
                continue;
            }
            if (9 == type) {
                ts = (TwoString)args.nextElement();
                ch.startPrefixMapping(ts.first, ts.second);
                continue;
            }
            if (4 == type) {
                cd = (CharBlock)args.nextElement();
                ch.characters(cd.getCh(), cd.getStart(), cd.getLength());
                continue;
            }
            if (0 == type) {
                ch.startDocument();
                continue;
            }
            if (1 == type) {
                ch.endDocument();
                continue;
            }
            if (10 == type) {
                ch.endPrefixMapping((String)args.nextElement());
                continue;
            }
            if (5 == type) {
                cd = (CharBlock)args.nextElement();
                ch.ignorableWhitespace(cd.getCh(), cd.getStart(), cd.getLength());
                continue;
            }
            if (6 == type) {
                ts = (TwoString)args.nextElement();
                ch.processingInstruction(ts.first, ts.second);
                continue;
            }
            switch (type) {
                case 7: 
                case 8: {
                    if (dtdh == null) continue block5;
                    if (7 == type) {
                        ths = (ThreeString)args.nextElement();
                        dtdh.notationDecl(ths.first, ths.second, ths.third);
                        break;
                    }
                    if (8 != type) continue block5;
                    FourString fs = (FourString)args.nextElement();
                    dtdh.unparsedEntityDecl(fs.first, fs.second, fs.third, fs.fourth);
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    if (erh == null) continue block5;
                    SAXParseException e = (SAXParseException)args.nextElement();
                    if (12 == type) {
                        erh.warning(e);
                        break;
                    }
                    if (13 == type) {
                        erh.error(e);
                        break;
                    }
                    if (14 != type) continue block5;
                    erh.fatalError(e);
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    String n;
                    if (lh == null) continue block5;
                    if (18 == type) {
                        ths = (ThreeString)args.nextElement();
                        lh.startDTD(ths.first, ths.second, ths.third);
                        break;
                    }
                    if (19 == type) {
                        lh.endDTD();
                        break;
                    }
                    if (20 == type) {
                        n = (String)args.nextElement();
                        lh.startEntity(n);
                        break;
                    }
                    if (21 == type) {
                        n = (String)args.nextElement();
                        lh.endEntity(n);
                        break;
                    }
                    if (16 == type) {
                        lh.startCDATA();
                        break;
                    }
                    if (17 == type) {
                        lh.endCDATA();
                        break;
                    }
                    if (15 != type) continue block5;
                    CharBlock ccd = (CharBlock)args.nextElement();
                    lh.comment(ccd.getCh(), ccd.getStart(), ccd.getLength());
                    break;
                }
                default: {
                    throw new RuntimeException("org.jasig.portal.utils.SAX2BufferImpl::outputBuffer: unexpected element type " + type + " encountered in SAX stream");
                }
            }
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(STARTDTD);
            this.eventArguments.add(new ThreeString(name, publicId, systemId));
        } else if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(ENDDTD);
        } else if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(STARTENTITY);
            this.eventArguments.add(name);
        } else if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(ENDENTITY);
            this.eventArguments.add(name);
        } else if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(name);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(STARTCDATA);
        } else if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(ENDCDATA);
        } else if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(COMMENT);
            this.eventArguments.add(new CharBlock(ch, start, length));
        } else if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(ch, start, length);
        }
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(NOTATIONDECL);
            this.eventArguments.add(new ThreeString(name, publicId, systemId));
        } else if (this.dtdHandler != null) {
            this.dtdHandler.notationDecl(name, publicId, systemId);
        }
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(UNPARSEDENTITYDECL);
            this.eventArguments.add(new FourString(name, publicId, systemId, notationName));
        } else if (this.dtdHandler != null) {
            this.dtdHandler.unparsedEntityDecl(name, publicId, systemId, notationName);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        if (!this.buffering && this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(locator);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(STARTDOCUMENT);
        } else if (this.contentHandler != null) {
            this.contentHandler.startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(ENDDOCUMENT);
            if (this.outputAtDocumentEnd) {
                this.stopBuffering();
                this.outputBuffer();
            }
        } else if (this.contentHandler != null) {
            this.contentHandler.endDocument();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(STARTPREFIXMAPPING);
            this.eventArguments.add(new TwoString(prefix, uri));
        } else if (this.contentHandler != null) {
            this.contentHandler.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(ENDPREFIXMAPPING);
            this.eventArguments.add(prefix);
        } else if (this.contentHandler != null) {
            this.contentHandler.endPrefixMapping(prefix);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(STARTELEMENT);
            this.eventArguments.add(new StartElementData(uri, localName, qName, atts));
        } else if (this.contentHandler != null) {
            this.contentHandler.startElement(uri, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(ENDELEMENT);
            this.eventArguments.add(new ThreeString(uri, localName, qName));
        } else if (this.contentHandler != null) {
            this.contentHandler.endElement(uri, localName, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(CHARACTERS);
            this.eventArguments.add(new CharBlock(ch, start, length));
        } else if (this.contentHandler != null) {
            this.contentHandler.characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(IGNORABLEWHITESPACE);
            this.eventArguments.add(new CharBlock(ch, start, length));
        } else if (this.contentHandler != null) {
            this.contentHandler.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(PROCESSINGINSTRUCTION);
            this.eventArguments.add(new TwoString(target, data));
        } else if (this.contentHandler != null) {
            this.contentHandler.processingInstruction(target, data);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(SKIPPEDENTITY);
            this.eventArguments.add(name);
        } else if (this.contentHandler != null) {
            this.contentHandler.skippedEntity(name);
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(WARNING);
            this.eventArguments.add(e);
        } else if (this.errorHandler != null) {
            this.errorHandler.warning(e);
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(ERROR);
            this.eventArguments.add(e);
        } else if (this.errorHandler != null) {
            this.errorHandler.error(e);
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        if (this.buffering) {
            this.eventTypes.add(FATALERROR);
            this.eventArguments.add(e);
        } else if (this.errorHandler != null) {
            this.errorHandler.fatalError(e);
        }
    }

    private class StartElementData
    extends ThreeString {
        public AttributesImpl ai;

        StartElementData(String uri, String localName, String qName, Attributes atts) {
            super(uri, localName, qName);
            this.ai = new AttributesImpl(atts);
        }

        public String getURI() {
            return super.getFirst();
        }

        public String getLocalName() {
            return super.getSecond();
        }

        public String getQName() {
            return super.getThird();
        }

        public Attributes getAtts() {
            return this.ai;
        }
    }

    private class CharBlock {
        public char[] ca_ch;
        public int i_start;
        public int i_length;

        CharBlock(char[] ch, int start, int length) {
            if (SAX2BufferImpl.this.copyCharBlock) {
                this.ca_ch = new char[length + start];
                System.arraycopy(ch, 0, this.ca_ch, 0, length + start);
            } else {
                this.ca_ch = ch;
            }
            this.i_start = start;
            this.i_length = length;
        }

        public char[] getCh() {
            return this.ca_ch;
        }

        public int getStart() {
            return this.i_start;
        }

        public int getLength() {
            return this.i_length;
        }
    }

    private class FourString {
        public String first;
        public String second;
        public String third;
        public String fourth;

        FourString(String first, String second, String third, String fourth) {
            this.first = first;
            this.second = second;
            this.third = third;
            this.fourth = fourth;
        }

        public String getFirst() {
            return this.first;
        }

        public String getSecond() {
            return this.second;
        }

        public String getThird() {
            return this.third;
        }

        public String getFourth() {
            return this.fourth;
        }
    }

    private class ThreeString {
        public String first;
        public String second;
        public String third;

        ThreeString(String first, String second, String third) {
            this.first = first;
            this.second = second;
            this.third = third;
        }

        public String getFirst() {
            return this.first;
        }

        public String getSecond() {
            return this.second;
        }

        public String getThird() {
            return this.third;
        }
    }

    private class TwoString {
        public String first;
        public String second;

        TwoString(String first, String second) {
            this.first = first;
            this.second = second;
        }

        public String getFirst() {
            return this.first;
        }

        public String getSecond() {
            return this.second;
        }
    }
}

