/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.compare;

import java.util.Comparator;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

abstract class BooleanComparator
implements Comparator<String> {
    private final Comparator<String>[] comparators;

    public BooleanComparator(Comparator<String>[] comparators) {
        this.comparators = comparators;
    }

    @Override
    public final int compare(String o1, String o2) {
        ComparatorType comparatorType = this.getComparatorType();
        for (Comparator<String> comparator : this.comparators) {
            int result = comparator.compare(o1, o2);
            if (result == 0 && comparatorType == ComparatorType.OR) {
                return 0;
            }
            if (result == 0 || comparatorType != ComparatorType.AND) continue;
            return result;
        }
        return Integer.MIN_VALUE;
    }

    protected abstract ComparatorType getComparatorType();

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object[])this.comparators).toString();
    }

    public static enum ComparatorType {
        OR,
        AND;

    }
}

