/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.threading;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jasig.portal.utils.threading.DoubleCheckedCreator;

public abstract class MapCachingDoubleCheckedCreator<K, T>
extends DoubleCheckedCreator<T> {
    private final Map<K, T> objectCache;

    public MapCachingDoubleCheckedCreator() {
        this.objectCache = new HashMap<K, T>();
    }

    public MapCachingDoubleCheckedCreator(Map<K, T> cache) {
        Validate.notNull(cache, (String)"cache can not be null");
        this.objectCache = cache;
    }

    public MapCachingDoubleCheckedCreator(Map<K, T> cache, ReadWriteLock readWriteLock) {
        super(readWriteLock);
        Validate.notNull(cache, (String)"cache can not be null");
        this.objectCache = cache;
    }

    public final Map<K, T> getCacheMap() {
        return Collections.unmodifiableMap(this.objectCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        this.writeLock.lock();
        try {
            this.objectCache.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected abstract K getKey(Object ... var1);

    protected abstract T createInternal(K var1, Object ... var2);

    @Override
    protected final T create(Object ... args) {
        K key = this.getKey(args);
        T value = this.createInternal(key, args);
        this.objectCache.put(key, value);
        return value;
    }

    @Override
    protected final T retrieve(Object ... args) {
        K key = this.getKey(args);
        return this.objectCache.get(key);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("objectCache", this.objectCache).toString();
    }
}

