/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.uri;

import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.utils.uri.BlockedUriException;
import org.jasig.portal.utils.uri.IUriScrutinizer;
import org.springframework.util.StringUtils;

public final class PrefixUriScrutinizer
implements IUriScrutinizer,
Serializable {
    private final Log log = LogFactory.getLog(this.getClass());
    private final String[] allowPrefixes;
    private final String[] denyPrefixes;

    public static PrefixUriScrutinizer instanceFromParameters(String allowPrefixesArg, String denyPrefixesArg) {
        String[] allowPrefixes = !StringUtils.hasText((String)allowPrefixesArg) ? new String[]{"http://", "https://"} : allowPrefixesArg.split("\\s");
        String[] denyPrefixes = !StringUtils.hasText((String)denyPrefixesArg) ? new String[]{} : denyPrefixesArg.split("\\s");
        return new PrefixUriScrutinizer(allowPrefixes, denyPrefixes);
    }

    public PrefixUriScrutinizer(String[] allowPrefixesArg, String[] denyPrefixesArg) {
        if (allowPrefixesArg == null) {
            throw new IllegalArgumentException("Cannot construct PrefixUriScrutinizer with null array of allow prefixes.");
        }
        String[] lowercaseAllowPrefixes = new String[allowPrefixesArg.length];
        for (int i = 0; i < allowPrefixesArg.length; ++i) {
            String allowPrefix = allowPrefixesArg[i];
            if (allowPrefix == null) {
                throw new IllegalArgumentException("Illegal null in allowPrefixesArg: " + allowPrefixesArg);
            }
            lowercaseAllowPrefixes[i] = allowPrefix.toLowerCase();
        }
        this.allowPrefixes = lowercaseAllowPrefixes;
        if (denyPrefixesArg == null) {
            throw new IllegalArgumentException("Cannot construct PrefixUriScrutinizer with null array of deny prefixes.");
        }
        String[] lowercaseDenyPrefixes = new String[denyPrefixesArg.length];
        for (int i = 0; i < denyPrefixesArg.length; ++i) {
            String denyPrefix = denyPrefixesArg[i];
            if (denyPrefix == null) {
                throw new IllegalArgumentException("Illegal null in denyPrefixesArg array.");
            }
            lowercaseDenyPrefixes[i] = denyPrefix.toLowerCase();
        }
        this.denyPrefixes = lowercaseDenyPrefixes;
    }

    @Override
    public void scrutinize(URI uriArg) throws BlockedUriException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Examinging [" + uriArg + "] with scrutinizer " + this));
        }
        if (uriArg == null) {
            throw new IllegalArgumentException("Cannot scrutinize a null URI.");
        }
        URI normalizedUri = uriArg.normalize();
        String uriString = normalizedUri.toString();
        String lowercaseUriString = uriString.toLowerCase();
        boolean acceptParamValue = false;
        for (int allowablePrefixNum = 0; allowablePrefixNum < this.allowPrefixes.length; ++allowablePrefixNum) {
            String allowablePrefix = this.allowPrefixes[allowablePrefixNum];
            if (!lowercaseUriString.startsWith(allowablePrefix)) continue;
            acceptParamValue = true;
            break;
        }
        if (!acceptParamValue) {
            throw new BlockedUriException(uriArg, "URI not prefixed by any of the allowed prefixes (" + Arrays.asList(this.allowPrefixes) + ")");
        }
        for (int blockedPrefixNum = 0; blockedPrefixNum < this.denyPrefixes.length; ++blockedPrefixNum) {
            String blockedPrefix = this.denyPrefixes[blockedPrefixNum];
            if (!lowercaseUriString.startsWith(blockedPrefix)) continue;
            throw new BlockedUriException(uriArg, "URI matched blocked prefix: " + blockedPrefix);
        }
    }

    public List getAllowPrefixes() {
        return Collections.unmodifiableList(Arrays.asList(this.allowPrefixes));
    }

    public List getDenyPrefixes() {
        return Collections.unmodifiableList(Arrays.asList(this.denyPrefixes));
    }

    public String toString() {
        return "PrefixUriScrutinizer allow:" + this.allowPrefixes + " deny:" + this.denyPrefixes;
    }
}

