/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.rdbm.IDatabaseMetadata;
import org.jasig.portal.spring.PortalApplicationContextLocator;
import org.jasig.portal.spring.locator.PortalDbLocator;
import org.jasig.portal.spring.locator.PortalDbMetadataLocator;
import org.jasig.portal.utils.MovingAverage;
import org.jasig.portal.utils.MovingAverageSample;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataAccessResourceFailureException;

/*
 * Exception performing whole class analysis ignored.
 */
public class RDBMServices {
    public static final String PORTAL_DB = "PortalDb";
    public static final String PORTAL_DB_METADATA = "PortalDB.metadata";
    private static final Log LOG = LogFactory.getLog(RDBMServices.class);
    private static final String FLAG_TRUE = "Y";
    private static final String FLAG_TRUE_OTHER = "T";
    private static final String FLAG_FALSE = "N";
    private static final MovingAverage databaseTimes = new MovingAverage();
    private static MovingAverageSample lastDatabase = new MovingAverageSample();
    private static AtomicInteger activeConnections = new AtomicInteger();
    private static int maxConnections = 0;

    @Deprecated
    public static DataSource getDataSource() {
        return RDBMServices.getDataSource((String)"PortalDb");
    }

    @Deprecated
    public static DataSource getDataSource(String name) {
        if ("PortalDb".equals(name)) {
            return PortalDbLocator.getPortalDb();
        }
        ApplicationContext applicationContext = PortalApplicationContextLocator.getApplicationContext();
        DataSource dataSource = (DataSource)applicationContext.getBean(name, DataSource.class);
        return dataSource;
    }

    public static int getActiveConnectionCount() {
        return activeConnections.intValue();
    }

    public static int getMaxConnectionCount() {
        return maxConnections;
    }

    public static MovingAverageSample getLastDatabase() {
        return lastDatabase;
    }

    @Deprecated
    public static Connection getConnection() {
        return RDBMServices.getConnection((String)"PortalDb");
    }

    @Deprecated
    public static Connection getConnection(String dbName) {
        DataSource dataSource = RDBMServices.getDataSource((String)dbName);
        try {
            long start = System.currentTimeMillis();
            Connection c = dataSource.getConnection();
            lastDatabase = databaseTimes.add(System.currentTimeMillis() - start);
            int current = activeConnections.incrementAndGet();
            if (current > maxConnections) {
                maxConnections = current;
            }
            return c;
        }
        catch (SQLException e) {
            throw new DataAccessResourceFailureException("RDBMServices sql error trying to get connection to " + dbName, (Throwable)e);
        }
    }

    @Deprecated
    public static void releaseConnection(Connection con) {
        block2: {
            try {
                activeConnections.decrementAndGet();
                con.close();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn((Object)("Error closing Connection: " + con), (Throwable)e);
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        block3: {
            if (rs == null) {
                return;
            }
            try {
                rs.close();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn((Object)("Error closing ResultSet: " + rs), (Throwable)e);
            }
        }
    }

    public static void closeStatement(Statement st) {
        block3: {
            if (st == null) {
                return;
            }
            try {
                st.close();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn((Object)("Error closing Statement: " + st), (Throwable)e);
            }
        }
    }

    public static final void commit(Connection connection) {
        block3: {
            if (connection == null) {
                return;
            }
            try {
                connection.commit();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn((Object)("Error committing Connection: " + connection), (Throwable)e);
            }
        }
    }

    public static final void setAutoCommit(Connection connection, boolean autocommit) {
        block2: {
            try {
                connection.setAutoCommit(autocommit);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn((Object)("Error committing Connection: " + connection + " to: " + autocommit), (Throwable)e);
            }
        }
    }

    public static final void rollback(Connection connection) {
        block2: {
            try {
                connection.rollback();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn((Object)("Error rolling back Connection: " + connection), (Throwable)e);
            }
        }
    }

    public static String getJdbcDriver() {
        IDatabaseMetadata dbMetaData = RDBMServices.getDbMetaData();
        return dbMetaData.getJdbcDriver();
    }

    public static String getJdbcUrl() {
        IDatabaseMetadata dbMetaData = RDBMServices.getDbMetaData();
        return dbMetaData.getJdbcUrl();
    }

    public static String getJdbcUser() {
        IDatabaseMetadata dbMetaData = RDBMServices.getDbMetaData();
        return dbMetaData.getJdbcUser();
    }

    public static final String dbFlag(boolean flag) {
        if (flag) {
            return "Y";
        }
        return "N";
    }

    public static final boolean dbFlag(String flag) {
        return flag != null && ("Y".equalsIgnoreCase(flag) || "T".equalsIgnoreCase(flag));
    }

    public static final String sqlEscape(String sql) {
        if (sql == null) {
            return "";
        }
        int primePos = sql.indexOf("'");
        if (primePos == -1) {
            return sql;
        }
        StringBuffer sb = new StringBuffer(sql.length() + 4);
        int startPos = 0;
        do {
            sb.append(sql.substring(startPos, primePos + 1));
            sb.append("'");
        } while ((primePos = sql.indexOf("'", startPos = primePos + 1)) != -1);
        sb.append(sql.substring(startPos));
        return sb.toString();
    }

    @Deprecated
    public static IDatabaseMetadata getDbMetaData() {
        return PortalDbMetadataLocator.getPortalDbMetadata();
    }
}

