/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.api.portlet;

import java.util.Collections;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.jasig.portal.api.portlet.DelegateState;
import org.jasig.portal.api.portlet.DelegationResponse;
import org.jasig.portal.url.ParameterMap;

public class DelegationActionResponse
extends DelegationResponse {
    private final String redirectLocation;
    private final String renderUrlParamName;
    private final PortletMode portletMode;
    private final WindowState windowState;
    private final Map<String, String[]> renderParameters;

    public DelegationActionResponse(DelegateState delegateState, PortletMode portletMode, WindowState windowState, Map<String, String[]> renderParameters) {
        super(delegateState);
        this.portletMode = portletMode;
        this.windowState = windowState;
        this.renderParameters = renderParameters != null ? new ParameterMap(renderParameters) : Collections.emptyMap();
        this.redirectLocation = null;
        this.renderUrlParamName = null;
    }

    public DelegationActionResponse(DelegateState delegateState, String redirectLocation, String renderUrlParamName) {
        super(delegateState);
        this.redirectLocation = redirectLocation;
        this.renderUrlParamName = renderUrlParamName;
        this.portletMode = null;
        this.windowState = null;
        this.renderParameters = Collections.emptyMap();
    }

    public String getRenderUrlParamName() {
        return this.renderUrlParamName;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public PortletMode getPortletMode() {
        return this.portletMode;
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    public Map<String, String[]> getRenderParameters() {
        return new ParameterMap(this.renderParameters);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.portletMode == null ? 0 : this.portletMode.hashCode());
        result = 31 * result + (this.redirectLocation == null ? 0 : this.redirectLocation.hashCode());
        result = 31 * result + (this.renderParameters == null ? 0 : this.renderParameters.hashCode());
        result = 31 * result + (this.renderUrlParamName == null ? 0 : this.renderUrlParamName.hashCode());
        result = 31 * result + (this.windowState == null ? 0 : this.windowState.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DelegationActionResponse other = (DelegationActionResponse)obj;
        if (this.portletMode == null ? other.portletMode != null : !this.portletMode.equals((Object)other.portletMode)) {
            return false;
        }
        if (this.redirectLocation == null ? other.redirectLocation != null : !this.redirectLocation.equals(other.redirectLocation)) {
            return false;
        }
        if (this.renderParameters == null ? other.renderParameters != null : !this.renderParameters.equals(other.renderParameters)) {
            return false;
        }
        if (this.renderUrlParamName == null ? other.renderUrlParamName != null : !this.renderUrlParamName.equals(other.renderUrlParamName)) {
            return false;
        }
        return !(this.windowState == null ? other.windowState != null : !this.windowState.equals((Object)other.windowState));
    }

    public String toString() {
        return "DelegationActionResponse [redirectLocation=" + this.redirectLocation + ", renderUrlParamName=" + this.renderUrlParamName + ", portletMode=" + this.portletMode + ", windowState=" + this.windowState + ", renderParameters=" + this.renderParameters + ", getDelegateState()=" + this.getDelegateState() + "]";
    }
}

