/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.concurrency.locking;

import javax.persistence.EntityManager;
import javax.persistence.RollbackException;
import org.jasig.portal.IPortalInfoProvider;
import org.jasig.portal.concurrency.locking.ClusterMutex;
import org.jasig.portal.concurrency.locking.IClusterLockDao;
import org.jasig.portal.jpa.BaseJpaDao;
import org.jasig.portal.jpa.BasePortalJpaDao;
import org.jasig.portal.jpa.cache.EntityManagerCache;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.transaction.support.TransactionTemplate;

@Repository
public class JpaClusterLockDao
extends BasePortalJpaDao
implements IClusterLockDao {
    private static final String CLUSTER_MUTEX_SOURCE = JpaClusterLockDao.class.getName() + "_CLUSTER_MUTEX";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ReadableDuration abandonedLockAge = Duration.standardSeconds((long)5L);
    private IPortalInfoProvider portalInfoProvider;
    private TransactionTemplate newTransactionTemplate;
    private EntityManagerCache entityManagerCache;

    @Value(value="${org.jasig.portal.concurrency.locking.ClusterLockDao.abandonedLockAge:PT60S}")
    public void setAbandonedLockAge(ReadableDuration abandonedLockAge) {
        this.abandonedLockAge = abandonedLockAge;
    }

    @Autowired
    public void setPortalInfoProvider(IPortalInfoProvider portalInfoProvider) {
        this.portalInfoProvider = portalInfoProvider;
    }

    @Autowired
    public void setPlatformTransactionManager(@Qualifier(value="PortalDb") PlatformTransactionManager platformTransactionManager) {
        this.newTransactionTemplate = new TransactionTemplate(platformTransactionManager);
        this.newTransactionTemplate.setPropagationBehavior(3);
        this.newTransactionTemplate.afterPropertiesSet();
    }

    @Autowired
    public void setEntityManagerCache(EntityManagerCache entityManagerCache) {
        this.entityManagerCache = entityManagerCache;
    }

    public ClusterMutex getClusterMutex(String mutexName) {
        ClusterMutex clusterMutex = this.getClusterMutexInternal(mutexName);
        if (clusterMutex != null) {
            this.logger.trace("Retrieved {}", (Object)clusterMutex);
            return clusterMutex;
        }
        this.createClusterMutex(mutexName);
        clusterMutex = this.getClusterMutexInternal(mutexName);
        if (clusterMutex != null) {
            this.logger.trace("Retrieved {}", (Object)clusterMutex);
            return clusterMutex;
        }
        throw new IllegalStateException("Failed to find or create ClusterMutex " + mutexName);
    }

    public ClusterMutex getLock(String mutexName) {
        return (ClusterMutex)this.executeIgnoreRollback((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */, null);
    }

    public void updateLock(String mutexName) {
        this.executeIgnoreRollback((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void releaseLock(String mutexName) {
        this.executeIgnoreRollback((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected ClusterMutex getClusterMutexInternal(String mutexName) {
        TransactionOperations transactionOperations = this.getTransactionOperations();
        return (ClusterMutex)transactionOperations.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void createClusterMutex(String mutexName) {
        this.executeIgnoreRollback((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void validateLockedMutex(ClusterMutex clusterMutex) {
        if (!clusterMutex.isLocked()) {
            throw new IllegalMonitorStateException("Mutex is not currently locked, it cannot be updated: " + clusterMutex);
        }
        String serverName = this.portalInfoProvider.getUniqueServerName();
        if (!serverName.equals(clusterMutex.getServerId())) {
            throw new IllegalMonitorStateException("Mutex is currently locked by another server: " + clusterMutex + " local serverName: " + serverName);
        }
    }

    protected void unlockAbandonedLock(String mutexName) {
        this.executeIgnoreRollback((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected boolean isLockAbandoned(ClusterMutex clusterMutex) {
        return clusterMutex.getLastUpdate() < System.currentTimeMillis() - this.abandonedLockAge.getMillis();
    }

    protected <T> T executeIgnoreRollback(TransactionCallback<T> action) {
        return (T)this.executeIgnoreRollback(action, null);
    }

    protected <T> T executeIgnoreRollback(TransactionCallback<T> action, T rollbackValue) {
        try {
            return (T)this.newTransactionTemplate.execute(action);
        }
        catch (TransactionSystemException e) {
            if (e.getCause() instanceof RollbackException) {
                return rollbackValue;
            }
            throw e;
        }
    }

    static /* synthetic */ EntityManager access$000(JpaClusterLockDao x0) {
        return x0.getEntityManager();
    }

    static /* synthetic */ IPortalInfoProvider access$100(JpaClusterLockDao x0) {
        return x0.portalInfoProvider;
    }

    static /* synthetic */ EntityManager access$200(JpaClusterLockDao x0) {
        return x0.getEntityManager();
    }

    static /* synthetic */ EntityManager access$300(JpaClusterLockDao x0) {
        return x0.getEntityManager();
    }

    static /* synthetic */ String access$400() {
        return CLUSTER_MUTEX_SOURCE;
    }

    static /* synthetic */ EntityManagerCache access$500(JpaClusterLockDao x0) {
        return x0.entityManagerCache;
    }

    static /* synthetic */ BaseJpaDao.NaturalIdQuery access$600(JpaClusterLockDao x0, Class x1) {
        return x0.createNaturalIdQuery(x1);
    }

    static /* synthetic */ EntityManager access$700(JpaClusterLockDao x0) {
        return x0.getEntityManager();
    }

    static /* synthetic */ EntityManager access$800(JpaClusterLockDao x0) {
        return x0.getEntityManager();
    }
}

