/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.jasig.portal.events.PortalEvent;

public final class LoginEvent
extends PortalEvent {
    private static final long serialVersionUID = 1L;
    private final Set<String> groups;
    private final Map<String, List<String>> attributes;

    private LoginEvent() {
        this.groups = Collections.emptySet();
        this.attributes = Collections.emptyMap();
    }

    LoginEvent(PortalEvent.PortalEventBuilder eventBuilder, Set<String> groups, Map<String, List<String>> attributes) {
        super(eventBuilder);
        Validate.notNull(groups, (String)"groups");
        Validate.notNull(attributes, (String)"attributes");
        this.groups = ImmutableSet.copyOf(groups);
        ImmutableMap.Builder attributesBuilder = ImmutableMap.builder();
        for (Map.Entry<String, List<String>> attributeEntry : attributes.entrySet()) {
            attributesBuilder.put((Object)attributeEntry.getKey(), (Object)ImmutableList.copyOf((Collection)attributeEntry.getValue()));
        }
        this.attributes = attributesBuilder.build();
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return super.toString() + ", groups=" + this.groups.size() + ", attributes=" + this.attributes.size() + "]";
    }
}

