/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IPortalInfoProvider;
import org.jasig.portal.events.FolderAddedToLayoutPortalEvent;
import org.jasig.portal.events.FolderDeletedFromLayoutPortalEvent;
import org.jasig.portal.events.FolderMovedInLayoutPortalEvent;
import org.jasig.portal.events.IPortalEventFactory;
import org.jasig.portal.events.LoginEvent;
import org.jasig.portal.events.LogoutEvent;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.events.PortalRenderEvent;
import org.jasig.portal.events.PortletActionExecutionEvent;
import org.jasig.portal.events.PortletAddedToLayoutPortalEvent;
import org.jasig.portal.events.PortletDeletedFromLayoutPortalEvent;
import org.jasig.portal.events.PortletEventExecutionEvent;
import org.jasig.portal.events.PortletExecutionEvent;
import org.jasig.portal.events.PortletHungCompleteEvent;
import org.jasig.portal.events.PortletHungEvent;
import org.jasig.portal.events.PortletMovedInLayoutPortalEvent;
import org.jasig.portal.events.PortletRenderExecutionEvent;
import org.jasig.portal.events.PortletRenderHeaderExecutionEvent;
import org.jasig.portal.events.PortletResourceExecutionEvent;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.logging.ConditionalExceptionLogger;
import org.jasig.portal.logging.ConditionalExceptionLoggerImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlet.rendering.worker.IPortletExecutionWorker;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.security.SystemPerson;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.url.IPortalRequestInfo;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.url.IPortletRequestInfo;
import org.jasig.portal.url.IUrlSyntaxProvider;
import org.jasig.portal.url.ParameterMap;
import org.jasig.portal.utils.IncludeExcludeUtils;
import org.jasig.portal.utils.RandomTokenGenerator;
import org.jasig.portal.utils.SerializableObject;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.stereotype.Service;
import org.springframework.web.util.WebUtils;

@Service(value="portalEventFactory")
public class PortalEventFactoryImpl
implements IPortalEventFactory,
ApplicationEventPublisherAware {
    private static final String EVENT_SESSION_MUTEX = PortalEventFactoryImpl.class.getName() + ".EVENT_SESSION_MUTEX";
    private static final String EVENT_SESSION_ID_ATTR = PortalEventFactoryImpl.class.getName() + ".EVENT_SESSION_ID_ATTR";
    protected final ConditionalExceptionLogger logger = new ConditionalExceptionLoggerImpl(LoggerFactory.getLogger(this.getClass()));
    private final AtomicReference<String> systemSessionId = new AtomicReference();
    private int maxParameters = 50;
    private int maxParameterLength = 500;
    private Set<String> groupIncludes = Collections.emptySet();
    private Set<String> groupExcludes = Collections.emptySet();
    private Set<String> attributeIncludes = Collections.emptySet();
    private Set<String> attributeExcludes = Collections.emptySet();
    private IPersonAttributeDao personAttributeDao;
    private IPortalInfoProvider portalInfoProvider;
    private IPortalRequestUtils portalRequestUtils;
    private IPersonManager personManager;
    private ApplicationEventPublisher applicationEventPublisher;
    private IPortletWindowRegistry portletWindowRegistry;
    private IUrlSyntaxProvider urlSyntaxProvider;

    public void setMaxParameters(int maxParameters) {
        this.maxParameters = maxParameters;
    }

    public void setMaxParameterLength(int maxParameterLength) {
        this.maxParameterLength = maxParameterLength;
    }

    public void setGroupIncludes(Set<String> groupIncludes) {
        this.groupIncludes = groupIncludes;
    }

    public void setGroupExcludes(Set<String> groupExcludes) {
        this.groupExcludes = groupExcludes;
    }

    public void setAttributeIncludes(Set<String> attributeIncludes) {
        this.attributeIncludes = attributeIncludes;
    }

    public void setAttributeExcludes(Set<String> attributeExcludes) {
        this.attributeExcludes = attributeExcludes;
    }

    @Autowired
    public void setPortalInfoProvider(IPortalInfoProvider portalInfoProvider) {
        this.portalInfoProvider = portalInfoProvider;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Autowired
    public void setPersonAttributeDao(@Qualifier(value="personAttributeDao") IPersonAttributeDao personAttributeDao) {
        this.personAttributeDao = personAttributeDao;
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    @Autowired
    public void setUrlSyntaxProvider(IUrlSyntaxProvider urlSyntaxProvider) {
        this.urlSyntaxProvider = urlSyntaxProvider;
    }

    public void publishLoginEvent(HttpServletRequest request, Object source, IPerson person) {
        PortalEvent.PortalEventBuilder portalEventBuilder = this.createPortalEventBuilder(source, person, request);
        Set groups = this.getGroupsForUser(person);
        Map attributes = this.getAttributesForUser(person);
        LoginEvent loginEvent = new LoginEvent(portalEventBuilder, groups, attributes);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)loginEvent);
    }

    public void publishLogoutEvent(HttpServletRequest request, Object source, IPerson person) {
        PortalEvent.PortalEventBuilder portalEventBuilder = this.createPortalEventBuilder(source, person, request);
        LogoutEvent logoutEvent = new LogoutEvent(portalEventBuilder);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)logoutEvent);
    }

    public void publishPortletAddedToLayoutPortalEvent(HttpServletRequest request, Object source, IPerson layoutOwner, long layoutId, String parentFolderId, String fname) {
        PortalEvent.PortalEventBuilder portalEventBuilder = this.createPortalEventBuilder(source, request);
        PortletAddedToLayoutPortalEvent portletAddedToLayoutPortalEvent = new PortletAddedToLayoutPortalEvent(portalEventBuilder, layoutOwner, layoutId, parentFolderId, fname);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)portletAddedToLayoutPortalEvent);
    }

    public void publishPortletAddedToLayoutPortalEvent(Object source, IPerson person, long layoutId, String parentFolderId, String fname) {
        this.publishPortletAddedToLayoutPortalEvent(null, source, person, layoutId, parentFolderId, fname);
    }

    public void publishPortletMovedInLayoutPortalEvent(HttpServletRequest request, Object source, IPerson layoutOwner, long layoutId, String oldParentFolderId, String newParentFolderId, String fname) {
        PortalEvent.PortalEventBuilder portalEventBuilder = this.createPortalEventBuilder(source, request);
        PortletMovedInLayoutPortalEvent portletMovedInLayoutPortalEvent = new PortletMovedInLayoutPortalEvent(portalEventBuilder, layoutOwner, layoutId, oldParentFolderId, newParentFolderId, fname);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)portletMovedInLayoutPortalEvent);
    }

    public void publishPortletMovedInLayoutPortalEvent(Object source, IPerson layoutOwner, long layoutId, String oldParentFolderId, String newParentFolderId, String fname) {
        this.publishPortletMovedInLayoutPortalEvent(null, source, layoutOwner, layoutId, oldParentFolderId, newParentFolderId, fname);
    }

    public void publishPortletDeletedFromLayoutPortalEvent(HttpServletRequest request, Object source, IPerson layoutOwner, long layoutId, String oldParentFolderId, String fname) {
        PortalEvent.PortalEventBuilder portalEventBuilder = this.createPortalEventBuilder(source, request);
        PortletDeletedFromLayoutPortalEvent portletDeletedFromLayoutPortalEvent = new PortletDeletedFromLayoutPortalEvent(portalEventBuilder, layoutOwner, layoutId, oldParentFolderId, fname);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)portletDeletedFromLayoutPortalEvent);
    }

    public void publishPortletDeletedFromLayoutPortalEvent(Object source, IPerson layoutOwner, long layoutId, String oldParentFolderId, String fname) {
        this.publishPortletDeletedFromLayoutPortalEvent(null, source, layoutOwner, layoutId, oldParentFolderId, fname);
    }

    public void publishFolderAddedToLayoutPortalEvent(HttpServletRequest request, Object source, IPerson layoutOwner, long layoutId, String newFolderId) {
        PortalEvent.PortalEventBuilder portalEventBuilder = this.createPortalEventBuilder(source, request);
        FolderAddedToLayoutPortalEvent folderAddedToLayoutPortalEvent = new FolderAddedToLayoutPortalEvent(portalEventBuilder, layoutOwner, layoutId, newFolderId);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)folderAddedToLayoutPortalEvent);
    }

    public void publishFolderAddedToLayoutPortalEvent(Object source, IPerson layoutOwner, long layoutId, String newFolderId) {
        this.publishFolderAddedToLayoutPortalEvent(null, source, layoutOwner, layoutId, newFolderId);
    }

    public void publishFolderMovedInLayoutPortalEvent(HttpServletRequest request, Object source, IPerson layoutOwner, long layoutId, String oldParentFolderId, String movedFolderId) {
        PortalEvent.PortalEventBuilder portalEventBuilder = this.createPortalEventBuilder(source, request);
        FolderMovedInLayoutPortalEvent folderMovedInLayoutPortalEvent = new FolderMovedInLayoutPortalEvent(portalEventBuilder, layoutOwner, layoutId, oldParentFolderId, movedFolderId);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)folderMovedInLayoutPortalEvent);
    }

    public void publishFolderMovedInLayoutPortalEvent(Object source, IPerson person, long layoutId, String oldParentFolderId, String movedFolderId) {
        this.publishFolderMovedInLayoutPortalEvent(null, source, person, layoutId, oldParentFolderId, movedFolderId);
    }

    public void publishFolderDeletedFromLayoutPortalEvent(HttpServletRequest request, Object source, IPerson layoutOwner, long layoutId, String oldParentFolderId, String deletedFolderId, String deletedFolderName) {
        PortalEvent.PortalEventBuilder portalEventBuilder = this.createPortalEventBuilder(source, request);
        FolderDeletedFromLayoutPortalEvent folderDeletedFromLayoutPortalEvent = new FolderDeletedFromLayoutPortalEvent(portalEventBuilder, layoutOwner, layoutId, oldParentFolderId, deletedFolderId, deletedFolderName);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)folderDeletedFromLayoutPortalEvent);
    }

    public void publishFolderDeletedFromLayoutPortalEvent(Object source, IPerson person, long layoutId, String oldParentFolderId, String deletedFolderId, String deletedFolderName) {
        this.publishFolderDeletedFromLayoutPortalEvent(null, source, person, layoutId, oldParentFolderId, deletedFolderId, deletedFolderName);
    }

    public void publishPortletHungEvent(HttpServletRequest request, Object source, IPortletExecutionWorker<?> worker) {
        PortalEvent.PortalEventBuilder eventBuilder = this.createPortalEventBuilder(source, request);
        PortletHungEvent portletHungEvent = new PortletHungEvent(eventBuilder, worker);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)portletHungEvent);
    }

    public void publishPortletHungCompleteEvent(Object source, IPortletExecutionWorker<?> worker) {
        PortalEvent.PortalEventBuilder eventBuilder = this.createPortalEventBuilder(source, null);
        PortletHungCompleteEvent portletHungCompleteEvent = new PortletHungCompleteEvent(eventBuilder, worker);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)portletHungCompleteEvent);
    }

    public void publishPortletActionExecutionEvent(HttpServletRequest request, Object source, IPortletWindowId portletWindowId, long executionTime) {
        PortalEvent.PortalEventBuilder eventBuilder = this.createPortalEventBuilder(source, request);
        PortletExecutionEvent.PortletExecutionEventBuilder portletEventBuilder = this.createPortletExecutionEventBuilder(eventBuilder, portletWindowId, executionTime, false);
        PortletActionExecutionEvent portletActionExecutionEvent = new PortletActionExecutionEvent(portletEventBuilder);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)portletActionExecutionEvent);
    }

    public void publishPortletEventExecutionEvent(HttpServletRequest request, Object source, IPortletWindowId portletWindowId, long executionTime, QName eventName) {
        PortalEvent.PortalEventBuilder eventBuilder = this.createPortalEventBuilder(source, request);
        PortletExecutionEvent.PortletExecutionEventBuilder portletEventBuilder = this.createPortletExecutionEventBuilder(eventBuilder, portletWindowId, executionTime, false);
        PortletEventExecutionEvent portletEventExecutionEvent = new PortletEventExecutionEvent(portletEventBuilder, eventName);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)portletEventExecutionEvent);
    }

    public void publishPortletRenderHeaderExecutionEvent(HttpServletRequest request, Object source, IPortletWindowId portletWindowId, long executionTime, boolean targeted, boolean cached) {
        PortalEvent.PortalEventBuilder eventBuilder = this.createPortalEventBuilder(source, request);
        PortletExecutionEvent.PortletExecutionEventBuilder portletEventBuilder = this.createPortletExecutionEventBuilder(eventBuilder, portletWindowId, executionTime, false);
        PortletRenderHeaderExecutionEvent portletRenderHeaderExecutionEvent = new PortletRenderHeaderExecutionEvent(portletEventBuilder, targeted, cached);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)portletRenderHeaderExecutionEvent);
    }

    public void publishPortletRenderExecutionEvent(HttpServletRequest request, Object source, IPortletWindowId portletWindowId, long executionTime, boolean targeted, boolean cached) {
        PortalEvent.PortalEventBuilder eventBuilder = this.createPortalEventBuilder(source, request);
        PortletExecutionEvent.PortletExecutionEventBuilder portletEventBuilder = this.createPortletExecutionEventBuilder(eventBuilder, portletWindowId, executionTime, false);
        PortletRenderExecutionEvent portletRenderExecutionEvent = new PortletRenderExecutionEvent(portletEventBuilder, targeted, cached);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)portletRenderExecutionEvent);
    }

    public void publishPortletResourceExecutionEvent(HttpServletRequest request, Object source, IPortletWindowId portletWindowId, long executionTime, boolean usedBrowserCache, boolean usedPortalCache) {
        PortalEvent.PortalEventBuilder eventBuilder = this.createPortalEventBuilder(source, request);
        PortletExecutionEvent.PortletExecutionEventBuilder portletEventBuilder = this.createPortletExecutionEventBuilder(eventBuilder, portletWindowId, executionTime, false);
        IPortalRequestInfo portalRequestInfo = this.urlSyntaxProvider.getPortalRequestInfo(request);
        String resourceId = this.getResourceId(portletWindowId, portalRequestInfo);
        PortletResourceExecutionEvent portletResourceExecutionEvent = new PortletResourceExecutionEvent(portletEventBuilder, resourceId, usedBrowserCache, usedPortalCache);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)portletResourceExecutionEvent);
    }

    public void publishPortalRenderEvent(HttpServletRequest request, Object source, String requestPathInfo, long executionTimeNano, IPortalRequestInfo portalRequestInfo) {
        PortalEvent.PortalEventBuilder eventBuilder = this.createPortalEventBuilder(source, request);
        Map portalParameters = this.pruneParameters(portalRequestInfo.getPortalParameters());
        PortalRenderEvent portalRenderEvent = new PortalRenderEvent(eventBuilder, requestPathInfo, executionTimeNano, portalRequestInfo.getUrlState(), portalRequestInfo.getUrlType(), portalParameters, portalRequestInfo.getTargetedLayoutNodeId());
        this.applicationEventPublisher.publishEvent((ApplicationEvent)portalRenderEvent);
    }

    protected PortalEvent.PortalEventBuilder createPortalEventBuilder(Object source, HttpServletRequest request) {
        request = this.getCurrentPortalRequest(request);
        IPerson person = this.getPerson(request);
        return this.createPortalEventBuilder(source, person, request);
    }

    protected PortalEvent.PortalEventBuilder createPortalEventBuilder(Object source, IPerson person, HttpServletRequest request) {
        String serverName = this.portalInfoProvider.getServerName();
        String eventSessionId = this.getPortalEventSessionId(request, person);
        request = this.getCurrentPortalRequest(request);
        return new PortalEvent.PortalEventBuilder(source, serverName, eventSessionId, person, request);
    }

    protected PortletExecutionEvent.PortletExecutionEventBuilder createPortletExecutionEventBuilder(PortalEvent.PortalEventBuilder portalEventBuilder, IPortletWindowId portletWindowId, long executionTimeNano, boolean renderRequest) {
        HttpServletRequest portalRequest = portalEventBuilder.getPortalRequest();
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(portalRequest, portletWindowId);
        IPortletEntity portletEntity = portletWindow.getPortletEntity();
        IPortletDefinition portletDefinition = portletEntity.getPortletDefinition();
        String fname = portletDefinition.getFName();
        Map parameters = this.getParameters(portalRequest, portletWindowId, renderRequest);
        WindowState windowState = portletWindow.getWindowState();
        PortletMode portletMode = portletWindow.getPortletMode();
        return new PortletExecutionEvent.PortletExecutionEventBuilder(portalEventBuilder, portletWindowId, fname, executionTimeNano, parameters, windowState, portletMode);
    }

    protected String getResourceId(IPortletWindowId portletWindowId, IPortalRequestInfo portalRequestInfo) {
        IPortletRequestInfo portletRequestInfo = portalRequestInfo.getPortletRequestInfo(portletWindowId);
        if (portletRequestInfo == null) {
            return null;
        }
        return portletRequestInfo.getResourceId();
    }

    protected Map<String, List<String>> getParameters(HttpServletRequest httpServletRequest, IPortletWindowId portletWindowId, boolean renderRequest) {
        IPortalRequestInfo portalRequestInfo = this.urlSyntaxProvider.getPortalRequestInfo(httpServletRequest);
        IPortletRequestInfo portletRequestInfo = portalRequestInfo.getPortletRequestInfo(portletWindowId);
        if (portletRequestInfo != null) {
            Map parameters = portletRequestInfo.getPortletParameters();
            return this.pruneParameters(parameters);
        }
        if (renderRequest) {
            IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(httpServletRequest, portletWindowId);
            Map parameters = portletWindow.getRenderParameters();
            return this.pruneParameters(ParameterMap.immutableCopyOfArrayMap((Map)parameters));
        }
        return Collections.emptyMap();
    }

    protected HttpServletRequest getCurrentPortalRequest(HttpServletRequest request) {
        if (request == null) {
            try {
                return this.portalRequestUtils.getCurrentPortalRequest();
            }
            catch (IllegalStateException e) {
                return null;
            }
        }
        return this.portalRequestUtils.getOriginalPortalRequest(request);
    }

    protected IPerson getPerson(HttpServletRequest request) {
        if (request == null) {
            return SystemPerson.INSTANCE;
        }
        return this.personManager.getPerson(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPortalEventSessionId(HttpServletRequest request, IPerson person) {
        Object eventSessionMutex;
        if (request == null) {
            try {
                request = this.portalRequestUtils.getCurrentPortalRequest();
            }
            catch (IllegalStateException e) {
                if (person == SystemPerson.INSTANCE) {
                    String sessionId = (String)this.systemSessionId.get();
                    if (sessionId == null && !this.systemSessionId.compareAndSet(null, sessionId = this.createSessionId(person))) {
                        sessionId = (String)this.systemSessionId.get();
                    }
                    return sessionId;
                }
                IPerson sessionId = person;
                synchronized (sessionId) {
                    String sessionId2 = (String)person.getAttribute(EVENT_SESSION_ID_ATTR);
                    if (sessionId2 == null) {
                        sessionId2 = this.createSessionId(person);
                        person.setAttribute(EVENT_SESSION_ID_ATTR, (Object)sessionId2);
                    }
                    return sessionId2;
                }
            }
        }
        HttpSession session = request.getSession();
        Object object = eventSessionMutex = this.getEventSessionMutex(session);
        synchronized (object) {
            String eventSessionId = (String)session.getAttribute(EVENT_SESSION_ID_ATTR);
            if (eventSessionId != null) {
                return eventSessionId;
            }
            eventSessionId = this.createSessionId(person);
            session.setAttribute(EVENT_SESSION_ID_ATTR, (Object)eventSessionId);
            this.logger.debug("Generated PortalEvent SessionId: {}", (Object)eventSessionId);
            return eventSessionId;
        }
    }

    protected String createSessionId(IPerson person) {
        return RandomTokenGenerator.INSTANCE.generateRandomToken(8);
    }

    protected Set<String> getGroupsForUser(IPerson person) {
        IGroupMember member = GroupService.getGroupMember((EntityIdentifier)person.getEntityIdentifier());
        LinkedHashSet<String> groupKeys = new LinkedHashSet<String>();
        Iterator groupItr = member.getAllContainingGroups();
        while (groupItr.hasNext()) {
            IGroupMember group = (IGroupMember)groupItr.next();
            String groupKey = group.getKey();
            if (!IncludeExcludeUtils.included((Object)groupKey, (Collection)this.groupIncludes, (Collection)this.groupExcludes)) continue;
            groupKeys.add(groupKey);
        }
        return groupKeys;
    }

    protected Map<String, List<String>> getAttributesForUser(IPerson person) {
        IPersonAttributes personAttributes = this.personAttributeDao.getPerson(person.getUserName());
        LinkedHashMap<String, List<String>> attributes = new LinkedHashMap<String, List<String>>();
        for (Map.Entry attributeEntry : personAttributes.getAttributes().entrySet()) {
            String attributeName = (String)attributeEntry.getKey();
            List values = (List)attributeEntry.getValue();
            if (!IncludeExcludeUtils.included((Object)attributeName, (Collection)this.attributeIncludes, (Collection)this.attributeExcludes)) continue;
            ArrayList<String> stringValues = new ArrayList<String>(values == null ? 0 : values.size());
            if (values != null) {
                for (Object value : values) {
                    if (!(value instanceof CharSequence) && !(value instanceof Number) && !(value instanceof Date) && !(value instanceof Calendar)) continue;
                    stringValues.add(value.toString());
                }
            }
            attributes.put(attributeName, stringValues);
        }
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object getEventSessionMutex(HttpSession session) {
        Object object = WebUtils.getSessionMutex((HttpSession)session);
        synchronized (object) {
            SerializableObject mutex = (SerializableObject)session.getAttribute(EVENT_SESSION_MUTEX);
            if (mutex == null) {
                mutex = new SerializableObject();
                session.setAttribute(EVENT_SESSION_MUTEX, (Object)mutex);
            }
            return mutex;
        }
    }

    protected final Map<String, List<String>> pruneParameters(Map<String, List<String>> parameters) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int paramCount = 0;
        for (Map.Entry<String, List<String>> parameterEntry : parameters.entrySet()) {
            if (paramCount == this.maxParameters) break;
            ++paramCount;
            String name = StringUtils.left((String)parameterEntry.getKey(), (int)this.maxParameterLength);
            List<String> values = parameterEntry.getValue();
            if (values == null) {
                values = Collections.emptyList();
            }
            ImmutableList.Builder valuesBuilder = ImmutableList.builder();
            int valueCount = 0;
            for (String value : values) {
                if (valueCount == this.maxParameters) break;
                ++valueCount;
                valuesBuilder.add((Object)StringUtils.left((String)value, (int)this.maxParameterLength));
            }
            builder.put((Object)name, (Object)valuesBuilder.build());
        }
        return builder.build();
    }
}

