/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.Validate;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.url.UrlState;
import org.jasig.portal.url.UrlType;

public final class PortalRenderEvent
extends PortalEvent {
    private static final long serialVersionUID = 1L;
    private final String requestPathInfo;
    private final UrlState urlState;
    private final UrlType urlType;
    private final Map<String, List<String>> parameters;
    private final String targetedLayoutNodeId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Deprecated
    private Long executionTime;
    private long executionTimeNano;

    PortalRenderEvent() {
        this.requestPathInfo = null;
        this.urlState = null;
        this.urlType = null;
        this.parameters = Collections.emptyMap();
        this.targetedLayoutNodeId = null;
        this.executionTimeNano = -1L;
    }

    PortalRenderEvent(PortalEvent.PortalEventBuilder eventBuilder, String requestPathInfo, long executionTimeNano, UrlState urlState, UrlType urlType, Map<String, List<String>> parameters, String targetedLayoutNodeId) {
        super(eventBuilder);
        Validate.notNull((Object)urlState, (String)"urlType");
        Validate.notNull((Object)urlType, (String)"urlType");
        Validate.notNull(parameters, (String)"parameters");
        this.requestPathInfo = requestPathInfo;
        this.urlState = urlState;
        this.urlType = urlType;
        this.parameters = parameters;
        this.targetedLayoutNodeId = targetedLayoutNodeId;
        this.executionTimeNano = executionTimeNano;
    }

    public long getExecutionTime() {
        if (this.executionTime == null) {
            this.executionTime = TimeUnit.NANOSECONDS.toMillis(this.executionTimeNano);
        }
        return this.executionTime;
    }

    public long getExecutionTimeNano() {
        if (this.executionTimeNano == -1L && this.executionTime != null) {
            this.executionTimeNano = TimeUnit.MILLISECONDS.toNanos(this.executionTime);
        }
        return this.executionTimeNano;
    }

    public String getRequestPathInfo() {
        return this.requestPathInfo;
    }

    public UrlState getUrlState() {
        return this.urlState;
    }

    public UrlType getUrlType() {
        return this.urlType;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public String getTargetedLayoutNodeId() {
        return this.targetedLayoutNodeId;
    }

    public String toString() {
        return super.toString() + ", requestPathInfo=" + this.requestPathInfo + ", urlState=" + this.urlState + ", urlType=" + this.urlType + ", parameters=" + this.parameters.size() + ", targetedLayoutNodeId=" + this.targetedLayoutNodeId + ", executionTimeNano=" + this.getExecutionTimeNano() + "]";
    }
}

