/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.events.aggr.AcademicTermDetail;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.AggregationIntervalHelper;
import org.jasig.portal.events.aggr.AggregationIntervalHelperImpl;
import org.jasig.portal.events.aggr.AggregationIntervalInfo;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.EventDateTimeUtils;
import org.jasig.portal.events.aggr.QuarterDetail;
import org.jasig.portal.events.aggr.TimeDimension;
import org.jasig.portal.events.aggr.dao.DateDimensionDao;
import org.jasig.portal.events.aggr.dao.IEventAggregationManagementDao;
import org.jasig.portal.events.aggr.dao.TimeDimensionDao;
import org.jasig.portal.events.aggr.dao.jpa.AcademicTermDetailImpl;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AggregationIntervalHelperImpl
implements AggregationIntervalHelper {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private TimeDimensionDao timeDimensionDao;
    private DateDimensionDao dateDimensionDao;
    private IEventAggregationManagementDao eventAggregationManagementDao;

    @Autowired
    public void setEventAggregationManagementDao(IEventAggregationManagementDao eventAggregationManagementDao) {
        this.eventAggregationManagementDao = eventAggregationManagementDao;
    }

    @Autowired
    public void setTimeDimensionDao(TimeDimensionDao timeDimensionDao) {
        this.timeDimensionDao = timeDimensionDao;
    }

    @Autowired
    public void setDateDimensionDao(DateDimensionDao dateDimensionDao) {
        this.dateDimensionDao = dateDimensionDao;
    }

    public List<DateTime> getIntervalStartDateTimesBetween(AggregationInterval interval, DateTime start, DateTime end) {
        return this.getIntervalStartDateTimesBetween(interval, start, end, -1);
    }

    public int intervalsBetween(AggregationInterval interval, DateTime start, DateTime end) {
        if (interval.isSupportsDetermination()) {
            return interval.determineIntervalsBetween((ReadableInstant)start, (ReadableInstant)end);
        }
        if (interval == AggregationInterval.ACADEMIC_TERM) {
            List terms = this.getAcademicTermsAfter(start);
            int count = 0;
            for (AcademicTermDetail academicTerm : terms) {
                DateMidnight termStart = (DateMidnight)academicTerm.getStart();
                if (end.isAfter((ReadableInstant)termStart) && !start.isAfter((ReadableInstant)termStart)) {
                    ++count;
                    continue;
                }
                if (count <= 0) continue;
                break;
            }
            return count;
        }
        AggregationIntervalInfo nextInterval = this.getIntervalInfo(interval, start);
        int count = 0;
        while (nextInterval.getStart().isBefore((ReadableInstant)end)) {
            if (!start.isAfter((ReadableInstant)nextInterval.getStart())) {
                ++count;
            }
            nextInterval = this.getIntervalInfo(interval, nextInterval.getEnd());
        }
        return count;
    }

    public List<DateTime> getIntervalStartDateTimesBetween(AggregationInterval interval, DateTime start, DateTime end, int maxTimes) {
        if (interval.isSupportsDetermination()) {
            int intervals = interval.determineIntervalsBetween((ReadableInstant)start, (ReadableInstant)end);
            this.verifyIntervalCount(start, end, maxTimes, intervals);
            ArrayList<DateTime> result = new ArrayList<DateTime>(intervals);
            DateTime intervalStart = interval.determineStart(start);
            if (!intervalStart.isBefore((ReadableInstant)start)) {
                result.add(intervalStart);
            }
            DateTime intervalEnd = interval.determineEnd(intervalStart);
            intervalStart = interval.determineStart(intervalEnd);
            while (intervalStart.isBefore((ReadableInstant)end)) {
                result.add(intervalStart);
                intervalEnd = interval.determineEnd(intervalStart);
                intervalStart = interval.determineStart(intervalEnd);
            }
            return result;
        }
        if (interval == AggregationInterval.ACADEMIC_TERM) {
            List terms = this.getAcademicTermsAfter(start);
            ArrayList<DateTime> result = new ArrayList<DateTime>(terms.size());
            for (AcademicTermDetail academicTerm : terms) {
                DateMidnight termStart = (DateMidnight)academicTerm.getStart();
                if (end.isAfter((ReadableInstant)termStart) && !start.isAfter((ReadableInstant)termStart)) {
                    result.add(start);
                    continue;
                }
                if (result.isEmpty()) continue;
                break;
            }
            return result;
        }
        AggregationIntervalInfo nextInterval = this.getIntervalInfo(interval, start);
        ArrayList<DateTime> result = new ArrayList<DateTime>();
        while (nextInterval.getStart().isBefore((ReadableInstant)end)) {
            if (!start.isAfter((ReadableInstant)nextInterval.getStart())) {
                result.add(nextInterval.getStart());
                if (maxTimes > 0 && result.size() > maxTimes) {
                    throw new IllegalArgumentException("There more than " + result.size() + " intervals between " + start + " and " + end + " which is more than the specified maximum of " + maxTimes);
                }
            }
            nextInterval = this.getIntervalInfo(interval, nextInterval.getEnd());
        }
        return result;
    }

    public AggregationIntervalInfo getIntervalInfo(AggregationInterval interval, DateTime date) {
        DateTime end;
        DateTime start;
        DateTime instant = date.minuteOfHour().roundFloorCopy();
        switch (1.$SwitchMap$org$jasig$portal$events$aggr$AggregationInterval[interval.ordinal()]) {
            case 1: {
                List quartersDetails = this.eventAggregationManagementDao.getQuartersDetails();
                QuarterDetail quarterDetail = (QuarterDetail)EventDateTimeUtils.findDateRangeSorted((ReadableInstant)instant, (List)quartersDetails);
                start = quarterDetail.getStartDateMidnight((ReadableInstant)date).toDateTime();
                end = quarterDetail.getEndDateMidnight((ReadableInstant)date).toDateTime();
                break;
            }
            case 2: {
                List academicTermDetails = this.eventAggregationManagementDao.getAcademicTermDetails();
                AcademicTermDetail academicTermDetail = (AcademicTermDetail)EventDateTimeUtils.findDateRangeSorted((ReadableInstant)date, (List)academicTermDetails);
                if (academicTermDetail == null) {
                    return null;
                }
                start = ((DateMidnight)academicTermDetail.getStart()).toDateTime();
                end = ((DateMidnight)academicTermDetail.getEnd()).toDateTime();
                break;
            }
            default: {
                start = interval.determineStart(instant);
                end = interval.determineEnd(start);
            }
        }
        LocalTime startTime = start.toLocalTime();
        TimeDimension startTimeDimension = this.timeDimensionDao.getTimeDimensionByTime(startTime);
        DateMidnight startDateMidnight = start.toDateMidnight();
        DateDimension startDateDimension = this.dateDimensionDao.getDateDimensionByDate(startDateMidnight);
        return new AggregationIntervalInfo(interval, start, end, startDateDimension, startTimeDimension);
    }

    protected List<AcademicTermDetail> getAcademicTermsAfter(DateTime start) {
        List terms = this.eventAggregationManagementDao.getAcademicTermDetails();
        int index = Collections.binarySearch(terms, new AcademicTermDetailImpl(start.toDateMidnight(), start.plusDays(1).toDateMidnight(), ""));
        if (index > 0) {
            return terms.subList(index, terms.size());
        }
        if (index < 0) {
            return terms.subList(-(index + 1), terms.size());
        }
        return terms;
    }

    protected void verifyIntervalCount(DateTime start, DateTime end, int maxTimes, int intervals) {
        if (maxTimes > 0 && intervals > maxTimes) {
            throw new IllegalArgumentException("There are " + intervals + " intervals between " + start + " and " + end + " which is more than the specified maximum of " + maxTimes);
        }
    }
}

