/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr;

import java.io.Serializable;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.TimeDimension;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;
import org.springframework.util.Assert;

public class AggregationIntervalInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final AggregationInterval aggregationInterval;
    private final DateTime start;
    private final DateTime end;
    private final DateDimension dateDimension;
    private final TimeDimension timeDimension;
    private int duration = -1;
    private int hashCode = 0;

    AggregationIntervalInfo(AggregationInterval aggregationInterval, DateTime start, DateTime end, DateDimension dateDimension, TimeDimension timeDimension) {
        Assert.notNull((Object)aggregationInterval, (String)"aggregationInterval can not be null");
        Assert.notNull((Object)start, (String)"start can not be null");
        Assert.notNull((Object)end, (String)"end can not be null");
        if (!start.isBefore((ReadableInstant)end)) {
            throw new IllegalArgumentException("Start date must be before end date. start=" + start + ", end=" + end);
        }
        this.aggregationInterval = aggregationInterval;
        this.start = start;
        this.end = end;
        this.dateDimension = dateDimension;
        this.timeDimension = timeDimension;
    }

    public AggregationInterval getAggregationInterval() {
        return this.aggregationInterval;
    }

    public DateTime getStart() {
        return this.start;
    }

    public DateTime getEnd() {
        return this.end;
    }

    public DateDimension getDateDimension() {
        return this.dateDimension;
    }

    public TimeDimension getTimeDimension() {
        return this.timeDimension;
    }

    public int getTotalDuration() {
        int d = this.duration;
        if (d < 0) {
            d = Minutes.minutesBetween((ReadableInstant)this.start, (ReadableInstant)this.end).getMinutes();
            this.duration = d = Math.abs(d);
        }
        return d;
    }

    public int getDurationTo(ReadableInstant end) {
        if (end.isAfter((ReadableInstant)this.end)) {
            return this.getTotalDuration();
        }
        return Math.abs(Minutes.minutesBetween((ReadableInstant)this.start, (ReadableInstant)end).getMinutes());
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            int prime = 31;
            h = 1;
            h = 31 * h + (this.aggregationInterval == null ? 0 : this.aggregationInterval.hashCode());
            h = 31 * h + (this.end == null ? 0 : this.end.hashCode());
            this.hashCode = h = 31 * h + (this.start == null ? 0 : this.start.hashCode());
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass() || this.hashCode() != obj.hashCode()) {
            return false;
        }
        AggregationIntervalInfo other = (AggregationIntervalInfo)obj;
        if (this.aggregationInterval != other.aggregationInterval) {
            return false;
        }
        if (this.end == null ? other.end != null : !this.end.equals((Object)other.end)) {
            return false;
        }
        return !(this.start == null ? other.start != null : !this.start.equals((Object)other.start));
    }

    public String toString() {
        return "AggregationIntervalInfo [aggregationInterval=" + this.aggregationInterval + ", start=" + this.start + ", end=" + this.end + ", duration=" + this.duration + ", dateDimension=" + this.dateDimension + ", timeDimension=" + this.timeDimension + "]";
    }
}

