/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr;

import java.io.Serializable;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.BaseAggregationImpl;
import org.jasig.portal.events.aggr.BaseAggregationKey;
import org.jasig.portal.events.aggr.BaseGroupedAggregationDiscriminator;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.TimeDimension;
import org.jasig.portal.events.aggr.TimedAggregationStatistics;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.stat.JpaStatisticalSummary;

@Access(value=AccessType.FIELD)
@MappedSuperclass
public abstract class BaseTimedAggregationStatsImpl<K extends BaseAggregationKey, D extends BaseGroupedAggregationDiscriminator>
extends BaseAggregationImpl<K, D>
implements TimedAggregationStatistics,
Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="TIME_COUNT", nullable=false)
    private int count;
    @Column(name="SUM_TIME", nullable=false)
    private double sum;
    @Column(name="SUMSQ_TIME", nullable=false)
    private double sumsq;
    @Column(name="MEAN_TIME", nullable=false)
    private double mean;
    @Column(name="STD_DEVIATION_TIME", nullable=false)
    private double standardDeviation;
    @Column(name="VARIANCE_TIME", nullable=false)
    private double variance;
    @Column(name="POPULATION_VARIANCE_TIME", nullable=false)
    private double populationVariance;
    @Column(name="MAX_TIME", nullable=false)
    private double max;
    @Column(name="MIN_TIME", nullable=false)
    private double min;
    @Column(name="GEOMETRIC_MEAN_TIME", nullable=false)
    private double geometricMean;
    @Column(name="SUM_OF_LOGS_TIME", nullable=false)
    private double sumOfLogs;
    @Column(name="SECOND_MOMENT_TIME", nullable=false)
    private double secondMoment;
    @Embedded
    private JpaStatisticalSummary statisticalSummary;
    @Column(name="STATS_COMPLETE", nullable=false)
    private boolean complete = false;
    @Transient
    private boolean modified = false;

    protected BaseTimedAggregationStatsImpl() {
    }

    protected BaseTimedAggregationStatsImpl(TimeDimension timeDimension, DateDimension dateDimension, AggregationInterval interval, AggregatedGroupMapping aggregatedGroup) {
        super(timeDimension, dateDimension, interval, aggregatedGroup);
    }

    public final long getN() {
        this.updateStats();
        return this.count;
    }

    public final double getSum() {
        this.updateStats();
        return this.sum;
    }

    public final double getSumsq() {
        this.updateStats();
        return this.sumsq;
    }

    public final double getMean() {
        this.updateStats();
        return this.mean;
    }

    public final double getStandardDeviation() {
        this.updateStats();
        return this.standardDeviation;
    }

    public final double getVariance() {
        this.updateStats();
        return this.variance;
    }

    public final double getPopulationVariance() {
        this.updateStats();
        return this.populationVariance;
    }

    public final double getMax() {
        this.updateStats();
        return this.max;
    }

    public final double getMin() {
        this.updateStats();
        return this.min;
    }

    public final double getGeometricMean() {
        this.updateStats();
        return this.geometricMean;
    }

    public final double getSumOfLogs() {
        this.updateStats();
        return this.sumOfLogs;
    }

    public final double getSecondMoment() {
        this.updateStats();
        return this.secondMoment;
    }

    protected boolean isComplete() {
        return this.count > 0 && (this.complete || this.statisticalSummary == null);
    }

    protected void completeInterval() {
        this.updateStats();
        this.statisticalSummary = null;
        this.complete = true;
    }

    public final void addValue(double v) {
        if (this.isComplete()) {
            this.getLogger().warn("{} is already closed, the new value of {} will be ignored on: {}", new Object[]{this.getClass().getSimpleName(), v, this});
            return;
        }
        if (this.statisticalSummary == null) {
            this.statisticalSummary = new JpaStatisticalSummary();
        }
        this.statisticalSummary.addValue(v);
        this.modified = true;
    }

    @PrePersist
    @PreUpdate
    final void updateStats() {
        if (!this.modified || this.statisticalSummary == null) {
            return;
        }
        this.count = (int)this.statisticalSummary.getN();
        this.sum = this.statisticalSummary.getSum();
        this.sumsq = this.statisticalSummary.getSumsq();
        this.mean = this.statisticalSummary.getMean();
        this.standardDeviation = this.statisticalSummary.getStandardDeviation();
        this.variance = this.statisticalSummary.getVariance();
        this.populationVariance = this.statisticalSummary.getPopulationVariance();
        this.max = this.statisticalSummary.getMax();
        this.min = this.statisticalSummary.getMin();
        this.geometricMean = this.statisticalSummary.getGeometricMean();
        this.sumOfLogs = this.statisticalSummary.getSumOfLogs();
        this.secondMoment = this.statisticalSummary.getSecondMoment();
        this.modified = false;
    }
}

