/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import org.jasig.portal.events.aggr.AcademicTermDetail;
import org.jasig.portal.events.aggr.DateRange;
import org.jasig.portal.events.aggr.QuarterDetail;
import org.jasig.portal.events.aggr.dao.jpa.QuarterDetailImpl;
import org.joda.time.DateMidnight;
import org.joda.time.MonthDay;
import org.joda.time.ReadableInstant;

/*
 * Exception performing whole class analysis ignored.
 */
public final class EventDateTimeUtils {
    private EventDateTimeUtils() {
    }

    public static int compareTo(ReadableInstant start, ReadableInstant end, ReadableInstant instant) {
        if (instant.isBefore(start)) {
            return 1;
        }
        if (end.isAfter(instant)) {
            return 0;
        }
        return -1;
    }

    public static List<QuarterDetail> validateQuarters(Collection<QuarterDetail> quarters) {
        if (quarters.size() != 4) {
            throw new IllegalArgumentException("Exactly 4 QuarterDetail must be set: " + quarters);
        }
        ArrayList<QuarterDetail> sortedQuarters = new ArrayList<QuarterDetail>(quarters);
        Collections.sort(sortedQuarters);
        MonthDay previousEnd = (MonthDay)((QuarterDetail)sortedQuarters.get(3)).getEnd();
        Iterator itr = sortedQuarters.iterator();
        for (int i = 0; i < 4; ++i) {
            QuarterDetail q = (QuarterDetail)itr.next();
            if (i != q.getQuarterId()) {
                throw new IllegalArgumentException("Quarter " + i + " has an illegal id of " + q.getQuarterId());
            }
            if (!((MonthDay)q.getStart()).equals((Object)previousEnd)) {
                throw new IllegalArgumentException("Quarter " + i + " start date of " + q.getStart() + " is not adjacent to previous quarter's end date of " + previousEnd);
            }
            previousEnd = (MonthDay)q.getEnd();
        }
        return sortedQuarters;
    }

    public static List<AcademicTermDetail> validateAcademicTerms(Collection<AcademicTermDetail> academicTerms) {
        ArrayList<AcademicTermDetail> sortedTerms = new ArrayList<AcademicTermDetail>(academicTerms);
        Collections.sort(sortedTerms);
        AcademicTermDetail prevTermDetail = null;
        for (AcademicTermDetail termDetail : sortedTerms) {
            if (prevTermDetail != null && ((DateMidnight)termDetail.getStart()).isBefore((ReadableInstant)prevTermDetail.getEnd())) {
                throw new IllegalArgumentException(termDetail + " overlaps with " + prevTermDetail);
            }
            prevTermDetail = termDetail;
        }
        return sortedTerms;
    }

    public static <DR extends DateRange<DT>, DT> DR findDateRange(ReadableInstant instant, Collection<DR> dateRanges) {
        if (dateRanges.isEmpty()) {
            return null;
        }
        for (DateRange dateRange : dateRanges) {
            if (dateRange.compareTo(instant) != 0) continue;
            return (DR)dateRange;
        }
        return null;
    }

    public static <DR extends DateRange<DT>, DT> DR findDateRangeSorted(ReadableInstant instant, List<DR> dateRanges) {
        if (dateRanges.isEmpty()) {
            return null;
        }
        if (!(dateRanges instanceof RandomAccess)) {
            return (DR)EventDateTimeUtils.findDateRange((ReadableInstant)instant, dateRanges);
        }
        int low = 0;
        int high = dateRanges.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            DateRange dateRange = (DateRange)dateRanges.get(mid);
            int cmp = dateRange.compareTo(instant);
            if (cmp == -1) {
                low = mid + 1;
                continue;
            }
            if (cmp == 1) {
                high = mid - 1;
                continue;
            }
            return (DR)dateRange;
        }
        return null;
    }

    public static List<QuarterDetail> createStandardQuarters() {
        return ImmutableList.of((Object)new QuarterDetailImpl(new MonthDay(1, 1), new MonthDay(4, 1), 0), (Object)new QuarterDetailImpl(new MonthDay(4, 1), new MonthDay(7, 1), 1), (Object)new QuarterDetailImpl(new MonthDay(7, 1), new MonthDay(10, 1), 2), (Object)new QuarterDetailImpl(new MonthDay(10, 1), new MonthDay(1, 1), 3));
    }
}

