/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Parameter;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.Attribute;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.BaseAggregationImpl;
import org.jasig.portal.events.aggr.BaseAggregationImpl_;
import org.jasig.portal.events.aggr.BaseAggregationKey;
import org.jasig.portal.events.aggr.BaseAggregationPrivateDao;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.HibernateCacheEvictor;
import org.jasig.portal.events.aggr.TimeDimension;
import org.jasig.portal.events.aggr.dao.jpa.DateDimensionImpl;
import org.jasig.portal.events.aggr.dao.jpa.TimeDimensionImpl;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMappingImpl;
import org.jasig.portal.jpa.BaseAggrEventsJpaDao;
import org.jasig.portal.jpa.BaseJpaDao;
import org.jasig.portal.jpa.OpenEntityManager;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class JpaBaseAggregationDao<T extends BaseAggregationImpl<K, ?>, K extends BaseAggregationKey>
extends BaseAggrEventsJpaDao
implements BaseAggregationPrivateDao<T, K> {
    private final Class<T> aggregationEntityType;
    private HibernateCacheEvictor hibernateCacheEvictor;
    protected CriteriaQuery<T> findAggregationByDateTimeIntervalQuery;
    protected CriteriaQuery<T> findAggregationByDateTimeIntervalGroupQuery;
    protected CriteriaQuery<T> findAggregationsByDateRangeQuery;
    protected CriteriaQuery<T> findUnclosedAggregationsByDateRangeQuery;
    protected CriteriaQuery<AggregationInterval> findAggregationIntervalsQuery;
    protected CriteriaQuery<AggregatedGroupMappingImpl> findAggregatedGroupsQuery;
    protected ParameterExpression<TimeDimension> timeDimensionParameter;
    protected ParameterExpression<DateDimension> dateDimensionParameter;
    protected ParameterExpression<AggregationInterval> intervalParameter;
    protected ParameterExpression<AggregatedGroupMapping> aggregatedGroupParameter;
    protected ParameterExpression<Set> aggregatedGroupsParameter;
    protected ParameterExpression<LocalDate> startDate;
    protected ParameterExpression<LocalDate> endPlusOneDate;
    protected ParameterExpression<LocalDate> endDate;
    protected ParameterExpression<LocalTime> startTime;
    protected ParameterExpression<LocalTime> endTime;

    public JpaBaseAggregationDao(Class<T> aggregationEntityType) {
        this.aggregationEntityType = aggregationEntityType;
    }

    @Autowired
    public void setHibernateCacheEvictor(HibernateCacheEvictor hibernateCacheEvictor) {
        this.hibernateCacheEvictor = hibernateCacheEvictor;
    }

    protected abstract void addFetches(Root<T> var1);

    protected abstract void addUnclosedPredicate(CriteriaBuilder var1, Root<T> var2, List<Predicate> var3);

    protected void addAggregationSpecificKeyPredicate(CriteriaBuilder cb, Root<T> root, List<Predicate> keyPredicates) {
    }

    protected void bindAggregationSpecificKeyParameters(TypedQuery<T> query, Set<K> keys) {
    }

    protected void bindAggregationSpecificKeyParameters(BaseJpaDao.NaturalIdQuery<T> query, K key) {
    }

    protected void createParameterExpressions() {
    }

    protected void createCriteriaQueries() {
    }

    protected abstract T createAggregationInstance(K var1);

    protected abstract K getAggregationKey(T var1);

    public final void afterPropertiesSet() throws Exception {
        this.timeDimensionParameter = this.createParameterExpression(TimeDimension.class, "timeDimension");
        this.dateDimensionParameter = this.createParameterExpression(DateDimension.class, "dateDimension");
        this.intervalParameter = this.createParameterExpression(AggregationInterval.class, "interval");
        this.aggregatedGroupParameter = this.createParameterExpression(AggregatedGroupMapping.class, "aggregatedGroup");
        this.aggregatedGroupsParameter = this.createParameterExpression(Set.class, "aggregatedGroups");
        this.startDate = this.createParameterExpression(LocalDate.class, "startDate");
        this.endPlusOneDate = this.createParameterExpression(LocalDate.class, "endPlusOneDate");
        this.endDate = this.createParameterExpression(LocalDate.class, "endDate");
        this.startTime = this.createParameterExpression(LocalTime.class, "startTime");
        this.endTime = this.createParameterExpression(LocalTime.class, "endTime");
        this.createParameterExpressions();
        this.findAggregationByDateTimeIntervalQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findAggregationByDateTimeIntervalGroupQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findAggregationsByDateRangeQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findUnclosedAggregationsByDateRangeQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findAggregationIntervalsQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findAggregatedGroupsQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.createCriteriaQueries();
    }

    public final List<T> getAggregations(DateTime start, DateTime end, K key, AggregatedGroupMapping ... aggregatedGroupMappings) {
        HashSet<K> keys = new HashSet<K>();
        keys.add(key);
        return this.getAggregations(start, end, keys, aggregatedGroupMappings);
    }

    public final List<T> getAggregations(DateTime start, DateTime end, Set<K> keys, AggregatedGroupMapping ... aggregatedGroupMappings) {
        if (!start.isBefore((ReadableInstant)end)) {
            throw new IllegalArgumentException("Start must be before End: " + start + " - " + end);
        }
        LocalDate startDate = start.toLocalDate();
        LocalDate endDate = end.toLocalDate();
        TypedQuery query = this.createQuery(this.findAggregationsByDateRangeQuery);
        query.setParameter((Parameter)this.startDate, (Object)startDate);
        query.setParameter((Parameter)this.startTime, (Object)start.toLocalTime());
        query.setParameter((Parameter)this.endDate, (Object)endDate);
        query.setParameter((Parameter)this.endTime, (Object)end.toLocalTime());
        query.setParameter((Parameter)this.endPlusOneDate, (Object)endDate.plusDays(1));
        BaseAggregationKey key = (BaseAggregationKey)keys.iterator().next();
        query.setParameter((Parameter)this.intervalParameter, (Object)key.getInterval());
        this.bindAggregationSpecificKeyParameters(query, keys);
        Set groups = this.collectAllGroupsFromParams(keys, aggregatedGroupMappings);
        query.setParameter((Parameter)this.aggregatedGroupsParameter, (Object)groups);
        return query.getResultList();
    }

    protected final Set<AggregatedGroupMapping> collectAllGroupsFromParams(Set<K> keys, AggregatedGroupMapping[] aggregatedGroupMappings) {
        ImmutableSet.Builder groupsBuilder = ImmutableSet.builder();
        for (BaseAggregationKey aggregationKey : keys) {
            groupsBuilder.add((Object)aggregationKey.getAggregatedGroup());
        }
        groupsBuilder.add((Object[])aggregatedGroupMappings);
        return groupsBuilder.build();
    }

    public final Map<K, T> getAggregationsForInterval(DateDimension dateDimension, TimeDimension timeDimension, AggregationInterval interval) {
        TypedQuery query = this.createQuery(this.findAggregationByDateTimeIntervalQuery);
        query.setParameter((Parameter)this.dateDimensionParameter, (Object)dateDimension);
        query.setParameter((Parameter)this.timeDimensionParameter, (Object)timeDimension);
        query.setParameter((Parameter)this.intervalParameter, (Object)interval);
        List results = query.getResultList();
        HashMap<BaseAggregationKey, BaseAggregationImpl> resultMap = new HashMap<BaseAggregationKey, BaseAggregationImpl>();
        for (BaseAggregationImpl result : results) {
            BaseAggregationKey key = this.getAggregationKey(result);
            resultMap.put(key, result);
        }
        return resultMap;
    }

    public final Set<AggregationInterval> getAggregationIntervals() {
        TypedQuery query = this.createQuery(this.findAggregationIntervalsQuery);
        return Sets.immutableEnumSet((Iterable)query.getResultList());
    }

    public final Set<AggregatedGroupMapping> getAggregatedGroupMappings() {
        TypedQuery query = this.createQuery(this.findAggregatedGroupsQuery);
        return ImmutableSet.copyOf((Collection)query.getResultList());
    }

    @OpenEntityManager(unitName="AggrEventsDb")
    public final T getAggregation(K key) {
        BaseJpaDao.NaturalIdQuery query = this.createNaturalIdQuery(this.aggregationEntityType);
        query.using((Attribute)BaseAggregationImpl_.dateDimension, (Object)((DateDimensionImpl)key.getDateDimension()));
        query.using((Attribute)BaseAggregationImpl_.timeDimension, (Object)((TimeDimensionImpl)key.getTimeDimension()));
        query.using((Attribute)BaseAggregationImpl_.interval, (Object)key.getInterval());
        query.using((Attribute)BaseAggregationImpl_.aggregatedGroup, (Object)((AggregatedGroupMappingImpl)key.getAggregatedGroup()));
        this.bindAggregationSpecificKeyParameters(query, key);
        return (T)((BaseAggregationImpl)query.load());
    }

    public Collection<T> getUnclosedAggregations(DateTime start, DateTime end, AggregationInterval interval) {
        if (!start.isBefore((ReadableInstant)end)) {
            throw new IllegalArgumentException("Start must be before End: " + start + " - " + end);
        }
        LocalDate startDate = start.toLocalDate();
        LocalDate endDate = end.toLocalDate();
        TypedQuery query = this.createQuery(this.findUnclosedAggregationsByDateRangeQuery);
        query.setParameter((Parameter)this.startDate, (Object)startDate);
        query.setParameter((Parameter)this.startTime, (Object)start.toLocalTime());
        query.setParameter((Parameter)this.endDate, (Object)endDate);
        query.setParameter((Parameter)this.endTime, (Object)end.toLocalTime());
        query.setParameter((Parameter)this.endPlusOneDate, (Object)endDate.plusDays(1));
        query.setParameter((Parameter)this.intervalParameter, (Object)interval);
        return new LinkedHashSet(query.getResultList());
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public final T createAggregation(K key) {
        BaseAggregationImpl aggregation = this.createAggregationInstance(key);
        this.getEntityManager().persist((Object)aggregation);
        return (T)aggregation;
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public final void updateAggregation(T aggregation) {
        this.getEntityManager().persist(aggregation);
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public final void updateAggregations(Iterable<T> aggregations, boolean removeFromCache) {
        EntityManager entityManager = this.getEntityManager();
        for (BaseAggregationImpl aggregation : aggregations) {
            entityManager.persist((Object)aggregation);
            if (!removeFromCache) continue;
            this.hibernateCacheEvictor.evictEntity(aggregation.getClass(), (Serializable)Long.valueOf(aggregation.getId()));
        }
    }

    static /* synthetic */ Class access$000(JpaBaseAggregationDao x0) {
        return x0.aggregationEntityType;
    }
}

