/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.jasig.portal.events.aggr.UniqueStringsSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="UP_UNIQUE_STR")
@Inheritance(strategy=InheritanceType.JOINED)
@SequenceGenerator(name="UP_UNIQUE_STR_GEN", sequenceName="UP_UNIQUE_STR_SEQ", allocationSize=1000)
@TableGenerator(name="UP_UNIQUE_STR_GEN", pkColumnValue="UP_UNIQUE_STR_PROP", allocationSize=1000)
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public final class UniqueStrings {
    private static final int MAXIMUM_SEGMENT_COUNT = 1440;
    private static final int SEGMENT_MERGE_RATIO = 2;
    private static final int SMALL_SEGMENT_THRESHOLD = 10;
    private static final Logger LOGGER = LoggerFactory.getLogger(UniqueStrings.class);
    @Id
    @GeneratedValue(generator="UP_UNIQUE_STR_GEN")
    @Column(name="UNIQUE_STR_ID")
    private final long id;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true)
    @JoinColumn(name="UNIQUE_STR_ID", nullable=false)
    @Fetch(value=FetchMode.JOIN)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private Set<UniqueStringsSegment> uniqueStringSegments = new HashSet(0);
    @Transient
    private UniqueStringsSegment currentUniqueUsernamesSegment;

    public UniqueStrings() {
        this.id = -1L;
    }

    public boolean add(String e) {
        int stringCount = 0;
        int smallSegments = 0;
        for (UniqueStringsSegment uniqueUsernamesSegment : this.uniqueStringSegments) {
            if (uniqueUsernamesSegment.contains(e)) {
                return false;
            }
            int size = uniqueUsernamesSegment.size();
            stringCount += size;
            if (size > 10) continue;
            ++smallSegments;
        }
        if (this.currentUniqueUsernamesSegment == null) {
            int segmentCount = this.uniqueStringSegments.size();
            if (segmentCount >= 1440 || segmentCount > 1 && stringCount / segmentCount <= 2) {
                LOGGER.debug("Merging {} segments with {} strings into a single segment", (Object)segmentCount, (Object)stringCount);
                this.currentUniqueUsernamesSegment = new UniqueStringsSegment();
                for (UniqueStringsSegment uniqueUsernamesSegment : this.uniqueStringSegments) {
                    this.currentUniqueUsernamesSegment.addAll(uniqueUsernamesSegment);
                }
                this.uniqueStringSegments.clear();
                this.uniqueStringSegments.add(this.currentUniqueUsernamesSegment);
            } else if (smallSegments > 0) {
                LOGGER.debug("Merging {} small segments into a single segment", (Object)smallSegments);
                this.currentUniqueUsernamesSegment = new UniqueStringsSegment();
                Iterator uniqueStringsSegmentItr = this.uniqueStringSegments.iterator();
                while (uniqueStringsSegmentItr.hasNext()) {
                    UniqueStringsSegment uniqueStringsSegment = (UniqueStringsSegment)uniqueStringsSegmentItr.next();
                    if (uniqueStringsSegment.size() > 10) continue;
                    uniqueStringsSegmentItr.remove();
                    this.currentUniqueUsernamesSegment.addAll(uniqueStringsSegment);
                }
                this.uniqueStringSegments.add(this.currentUniqueUsernamesSegment);
            } else {
                this.currentUniqueUsernamesSegment = new UniqueStringsSegment();
                this.uniqueStringSegments.add(this.currentUniqueUsernamesSegment);
            }
        }
        return this.currentUniqueUsernamesSegment.add(e);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.id == -1L) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UniqueStrings other = (UniqueStrings)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "UniqueStrings [id=" + this.id + ", size=" + this.uniqueStringSegments.size() + "]";
    }
}

