/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.action;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Parameter;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.Attribute;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.JpaBaseAggregationDao;
import org.jasig.portal.events.aggr.TimeDimension;
import org.jasig.portal.events.aggr.action.SearchRequestAggregationImpl;
import org.jasig.portal.events.aggr.action.SearchRequestAggregationImpl_;
import org.jasig.portal.events.aggr.action.SearchRequestAggregationKey;
import org.jasig.portal.events.aggr.action.SearchRequestAggregationPrivateDao;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.jpa.BaseJpaDao;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.springframework.stereotype.Repository;

@Repository
public class JpaSearchRequestAggregationDao
extends JpaBaseAggregationDao<SearchRequestAggregationImpl, SearchRequestAggregationKey>
implements SearchRequestAggregationPrivateDao {
    private ParameterExpression<Set> searchTermParameter;
    protected CriteriaQuery<SearchRequestAggregationImpl> findAllSearchRequestAggregationsByDateRangeQuery;

    public JpaSearchRequestAggregationDao() {
        super(SearchRequestAggregationImpl.class);
    }

    protected void createCriteriaQueries() {
        this.findAllSearchRequestAggregationsByDateRangeQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void createParameterExpressions() {
        this.searchTermParameter = this.createParameterExpression(Set.class, "searchTerm");
    }

    protected void addFetches(Root<SearchRequestAggregationImpl> root) {
    }

    protected void addUnclosedPredicate(CriteriaBuilder cb, Root<SearchRequestAggregationImpl> root, List<Predicate> keyPredicates) {
        keyPredicates.add(cb.isFalse((Expression)root.get(SearchRequestAggregationImpl_.complete)));
    }

    protected SearchRequestAggregationImpl createAggregationInstance(SearchRequestAggregationKey key) {
        TimeDimension timeDimension = key.getTimeDimension();
        DateDimension dateDimension = key.getDateDimension();
        AggregationInterval interval = key.getInterval();
        AggregatedGroupMapping aggregatedGroup = key.getAggregatedGroup();
        String searchTerm = key.getSearchTerm();
        return new SearchRequestAggregationImpl(timeDimension, dateDimension, interval, aggregatedGroup, searchTerm);
    }

    protected SearchRequestAggregationKey getAggregationKey(SearchRequestAggregationImpl instance) {
        return instance.getAggregationKey();
    }

    protected void bindAggregationSpecificKeyParameters(TypedQuery<SearchRequestAggregationImpl> query, Set<SearchRequestAggregationKey> keys) {
        query.setParameter((Parameter)this.searchTermParameter, (Object)this.extractSearchTerms(keys));
    }

    protected void bindAggregationSpecificKeyParameters(BaseJpaDao.NaturalIdQuery<SearchRequestAggregationImpl> query, SearchRequestAggregationKey key) {
        query.using((Attribute)SearchRequestAggregationImpl_.searchTerm, (Object)key.getSearchTerm());
    }

    public final List<SearchRequestAggregationImpl> getAggregations(DateTime start, DateTime end, AggregationInterval interval, AggregatedGroupMapping aggregatedGroupMapping, AggregatedGroupMapping ... aggregatedGroupMappings) {
        if (!start.isBefore((ReadableInstant)end)) {
            throw new IllegalArgumentException("Start must be before End: " + start + " - " + end);
        }
        LocalDate startDate = start.toLocalDate();
        LocalDate endDate = end.toLocalDate();
        TypedQuery query = this.createQuery(this.findAllSearchRequestAggregationsByDateRangeQuery);
        query.setParameter((Parameter)this.startDate, (Object)startDate);
        query.setParameter((Parameter)this.startTime, (Object)start.toLocalTime());
        query.setParameter((Parameter)this.endDate, (Object)endDate);
        query.setParameter((Parameter)this.endTime, (Object)end.toLocalTime());
        query.setParameter((Parameter)this.endPlusOneDate, (Object)endDate.plusDays(1));
        query.setParameter((Parameter)this.intervalParameter, (Object)interval);
        ImmutableSet groups = ImmutableSet.builder().add((Object)aggregatedGroupMapping).add((Object[])aggregatedGroupMappings).build();
        query.setParameter((Parameter)this.aggregatedGroupsParameter, (Object)groups);
        return query.getResultList();
    }

    private Set<String> extractSearchTerms(Set<SearchRequestAggregationKey> keys) {
        HashSet<String> searchTerms = new HashSet<String>();
        for (SearchRequestAggregationKey key : keys) {
            searchTerms.add(key.getSearchTerm());
        }
        return searchTerms;
    }

    static /* synthetic */ ParameterExpression access$000(JpaSearchRequestAggregationDao x0) {
        return x0.startDate;
    }

    static /* synthetic */ ParameterExpression access$100(JpaSearchRequestAggregationDao x0) {
        return x0.endPlusOneDate;
    }

    static /* synthetic */ ParameterExpression access$200(JpaSearchRequestAggregationDao x0) {
        return x0.startDate;
    }

    static /* synthetic */ ParameterExpression access$300(JpaSearchRequestAggregationDao x0) {
        return x0.startTime;
    }

    static /* synthetic */ ParameterExpression access$400(JpaSearchRequestAggregationDao x0) {
        return x0.endDate;
    }

    static /* synthetic */ ParameterExpression access$500(JpaSearchRequestAggregationDao x0) {
        return x0.endTime;
    }

    static /* synthetic */ ParameterExpression access$600(JpaSearchRequestAggregationDao x0) {
        return x0.intervalParameter;
    }

    static /* synthetic */ ParameterExpression access$700(JpaSearchRequestAggregationDao x0) {
        return x0.aggregatedGroupsParameter;
    }
}

