/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.action;

import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.SequenceGenerator;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.Table;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.BaseAggregationImpl;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.TimeDimension;
import org.jasig.portal.events.aggr.action.SearchRequestAggregation;
import org.jasig.portal.events.aggr.action.SearchRequestAggregationDiscriminator;
import org.jasig.portal.events.aggr.action.SearchRequestAggregationDiscriminatorImpl;
import org.jasig.portal.events.aggr.action.SearchRequestAggregationKey;
import org.jasig.portal.events.aggr.action.SearchRequestAggregationKeyImpl;
import org.jasig.portal.events.aggr.action.SearchRequestAggregationUtil;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;

@Entity
@javax.persistence.Table(name="UP_SEARCH_REQ_AGGR")
@Inheritance(strategy=InheritanceType.JOINED)
@SequenceGenerator(name="UP_SEARCH_REQ_LAYOUT_GEN", sequenceName="UP_SEARCH_REQ_AGGR_SEQ", allocationSize=1000)
@TableGenerator(name="UP_SEARCH_REQ_AGGR_GEN", pkColumnValue="UP_SEARCH_REQ_AGGR_PROP", allocationSize=1000)
@Table(appliesTo="UP_SEARCH_REQ_AGGR", indexes={@Index(name="IDX_UP_SEARCH_REQ_AGGR_DTI", columnNames={"DATE_DIMENSION_ID", "TIME_DIMENSION_ID", "AGGR_INTERVAL"}), @Index(name="IDX_UP_SEARCH_REQ_INTRVL", columnNames={"AGGR_INTERVAL"}), @Index(name="IDX_UP_SEARCH_REQ_GRP", columnNames={"AGGR_GROUP_ID"}), @Index(name="IDX_UP_SEARCH_REQ_TRM", columnNames={"SEARCH_TERM"})})
@NaturalIdCache
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class SearchRequestAggregationImpl
extends BaseAggregationImpl<SearchRequestAggregationKey, SearchRequestAggregationDiscriminator>
implements SearchRequestAggregation,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UP_SEARCH_REQ_AGGR_GEN")
    @Column(name="ID")
    private final long id;
    @NaturalId
    @Column(name="SEARCH_TERM", nullable=false)
    private String searchTerm;
    @Column(name="SEARCH_COUNT", nullable=false)
    private int count;
    @Column(name="STATS_COMPLETE", nullable=false)
    private boolean complete = false;
    @Transient
    private SearchRequestAggregationKey aggregationKey;
    @Transient
    private SearchRequestAggregationDiscriminator aggregationDiscriminator;

    private SearchRequestAggregationImpl() {
        this.id = -1L;
        this.searchTerm = null;
    }

    SearchRequestAggregationImpl(TimeDimension timeDimension, DateDimension dateDimension, AggregationInterval interval, AggregatedGroupMapping aggregatedGroup, String searchTerm) {
        super(timeDimension, dateDimension, interval, aggregatedGroup);
        Validate.notNull((Object)searchTerm);
        this.id = -1L;
        this.searchTerm = SearchRequestAggregationUtil.normalizeSearchTerm((String)searchTerm);
    }

    public long getId() {
        return this.id;
    }

    public int getCount() {
        return this.count;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public SearchRequestAggregationKey getAggregationKey() {
        SearchRequestAggregationKey key = this.aggregationKey;
        if (key == null) {
            this.aggregationKey = key = new SearchRequestAggregationKeyImpl((SearchRequestAggregation)this);
        }
        return key;
    }

    public SearchRequestAggregationDiscriminator getAggregationDiscriminator() {
        SearchRequestAggregationDiscriminator discriminator = this.aggregationDiscriminator;
        if (discriminator == null) {
            this.aggregationDiscriminator = discriminator = new SearchRequestAggregationDiscriminatorImpl((SearchRequestAggregation)this);
        }
        return discriminator;
    }

    protected boolean isComplete() {
        return this.complete && this.count > 0;
    }

    protected void completeInterval() {
        this.complete = true;
    }

    void increment() {
        ++this.count;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.searchTerm == null ? 0 : this.searchTerm.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SearchRequestAggregation)) {
            return false;
        }
        SearchRequestAggregation other = (SearchRequestAggregation)obj;
        return !(this.searchTerm == null ? other.getSearchTerm() != null : !this.searchTerm.equals(other.getSearchTerm()));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[searchTerm=" + this.searchTerm + ", timeDimension=" + this.getTimeDimension() + ", dateDimension=" + this.getDateDimension() + ", interval=" + this.getInterval() + ", aggregatedGroup=" + this.getAggregatedGroup() + "]";
    }
}

