/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.dao.jpa;

import com.google.common.collect.ComparisonChain;
import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;
import org.jasig.portal.events.aggr.AcademicTermDetail;
import org.jasig.portal.events.aggr.EventDateTimeUtils;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@Entity
@Table(name="UP_ACADEMIC_TERM_DETAIL")
@SequenceGenerator(name="UP_ACADEMIC_TERM_DETAIL_GEN", sequenceName="UP_ACADEMIC_TERM_DETAIL_SEQ", allocationSize=1)
@TableGenerator(name="UP_ACADEMIC_TERM_DETAIL_GEN", pkColumnValue="UP_ACADEMIC_TERM_DETAIL_PROP", allocationSize=1)
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class AcademicTermDetailImpl
implements AcademicTermDetail,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UP_ACADEMIC_TERM_DETAIL_GEN")
    @Column(name="TERM_ID")
    private final long id;
    @NaturalId
    @Column(name="TERM_START", nullable=false)
    @Type(type="dateTime")
    private DateTime start;
    @NaturalId
    @Column(name="TERM_END", nullable=false)
    @Type(type="dateTime")
    private DateTime end;
    @Column(name="TERM_NAME", nullable=false)
    private String termName;
    @Transient
    private DateMidnight startDateMidnight;
    @Transient
    private DateMidnight endDateMidnight;

    private AcademicTermDetailImpl() {
        this.id = -1L;
        this.start = null;
        this.end = null;
        this.termName = null;
    }

    public AcademicTermDetailImpl(DateMidnight start, DateMidnight end, String termName) {
        Validate.notNull((Object)start);
        Validate.notNull((Object)end);
        Validate.notNull((Object)termName);
        if (start.isEqual((ReadableInstant)end) || end.isBefore((ReadableInstant)start)) {
            throw new IllegalArgumentException("end cannot be before or equal to start");
        }
        this.id = -1L;
        this.start = start.toDateTime();
        this.end = end.toDateTime();
        this.termName = termName;
        this.init();
    }

    @PostLoad
    @PostUpdate
    @PostPersist
    void init() {
        this.startDateMidnight = this.start.toDateMidnight();
        this.endDateMidnight = this.end.toDateMidnight();
    }

    public String getTermName() {
        return this.termName;
    }

    public void setTermName(String termName) {
        Validate.notNull((Object)termName);
        this.termName = termName;
    }

    public DateMidnight getStart() {
        return this.startDateMidnight;
    }

    public void setStart(DateMidnight start) {
        this.startDateMidnight = start;
        this.start = start.toDateTime();
    }

    public DateMidnight getEnd() {
        return this.endDateMidnight;
    }

    public void setEnd(DateMidnight end) {
        this.endDateMidnight = end;
        this.end = end.toDateTime();
    }

    public int compareTo(ReadableInstant instant) {
        return EventDateTimeUtils.compareTo((ReadableInstant)this.start, (ReadableInstant)this.end, (ReadableInstant)instant);
    }

    public int compareTo(AcademicTermDetail o) {
        return ComparisonChain.start().compare((Comparable)this.getStart(), (Comparable)o.getStart()).compare((Comparable)this.getEnd(), (Comparable)o.getEnd()).result();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcademicTermDetail)) {
            return false;
        }
        AcademicTermDetail other = (AcademicTermDetail)obj;
        if (this.getEnd() == null ? other.getEnd() != null : !this.getEnd().equals(other.getEnd())) {
            return false;
        }
        return !(this.getStart() == null ? other.getStart() != null : !this.getStart().equals(other.getStart()));
    }

    public String toString() {
        return "AcademicTermDetailImpl [termName=" + this.termName + ", startDateMidnight=" + this.startDateMidnight + ", endDateMidnight=" + this.endDateMidnight + "]";
    }
}

