/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.dao.jpa;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.MappedSuperclass;
import javax.persistence.PostPersist;
import javax.persistence.PostUpdate;
import javax.persistence.Transient;
import org.jasig.portal.events.aggr.BaseAggregatedDimensionConfig;
import org.jasig.portal.utils.IncludeExcludeUtils;

@MappedSuperclass
public abstract class BaseAggregatedDimensionConfigImpl<D>
implements BaseAggregatedDimensionConfig<D> {
    private static final long serialVersionUID = 1L;
    @Transient
    private final Map<D, Boolean> includedCache = new HashMap();

    @PostUpdate
    @PostPersist
    protected void clearIncludedCache() {
        this.includedCache.clear();
    }

    public final boolean isIncluded(D dimension) {
        Boolean cachedInclude = (Boolean)this.includedCache.get(dimension);
        if (cachedInclude != null) {
            return cachedInclude;
        }
        Set included = this.getIncluded();
        Set excluded = this.getExcluded();
        boolean include = (!included.isEmpty() || !excluded.isEmpty()) && IncludeExcludeUtils.included(dimension, (Collection)included, (Collection)excluded);
        this.includedCache.put(dimension, include);
        return include;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getAggregatorType() == null ? 0 : this.getAggregatorType().hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseAggregatedDimensionConfigImpl other = (BaseAggregatedDimensionConfigImpl)obj;
        return !(this.getAggregatorType() == null ? other.getAggregatorType() != null : !this.getAggregatorType().equals(other.getAggregatorType()));
    }
}

