/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.dao.jpa;

import java.io.Serializable;
import java.util.Collection;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.Type;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.login.LoginAggregationImpl;
import org.joda.time.DateMidnight;
import org.joda.time.LocalDate;

@Entity
@Table(name="UP_DATE_DIMENSION")
@SequenceGenerator(name="UP_DATE_DIMENSION_GEN", sequenceName="UP_DATE_DIMENSION_SEQ", allocationSize=1)
@TableGenerator(name="UP_DATE_DIMENSION_GEN", pkColumnValue="UP_DATE_DIMENSION_PROP", allocationSize=1)
@NaturalIdCache
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class DateDimensionImpl
implements DateDimension,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UP_DATE_DIMENSION_GEN")
    @Column(name="DATE_ID")
    private final long id;
    @NaturalId
    @Column(name="DD_DATE", nullable=false, updatable=false)
    @Type(type="localDate")
    private final LocalDate date;
    @Index(name="IDX_UP_DD_YEAR")
    @Column(name="DD_YEAR", nullable=false, updatable=false)
    private final int year;
    @Index(name="IDX_UP_DD_MONTH")
    @Column(name="DD_MONTH", nullable=false, updatable=false)
    private final int month;
    @Index(name="IDX_UP_DD_DAY")
    @Column(name="DD_DAY", nullable=false, updatable=false)
    private final int day;
    @Index(name="IDX_UP_DD_WEEK")
    @Column(name="DD_WEEK", nullable=false, updatable=false)
    private final int week;
    @Index(name="IDX_UP_DD_QUARTER")
    @Column(name="DD_QUARTER", nullable=false)
    private int quarter;
    @Index(name="IDX_UP_DD_TERM")
    @Column(name="DD_TERM", length=200)
    private String term;
    @OneToMany(mappedBy="dateDimension", fetch=FetchType.LAZY)
    private Collection<LoginAggregationImpl> loginAggregations;
    @Transient
    private int hashCode = 0;
    @Transient
    private DateMidnight dateMidnight;

    private DateDimensionImpl() {
        this.id = -1L;
        this.date = null;
        this.dateMidnight = null;
        this.year = -1;
        this.month = -1;
        this.day = -1;
        this.week = -1;
        this.quarter = -1;
        this.term = null;
    }

    DateDimensionImpl(DateMidnight date, int quarter, String term) {
        if (quarter < 0 || quarter > 3) {
            throw new IllegalArgumentException("Quarter must be between 0 and 3, it is: " + quarter);
        }
        this.dateMidnight = date;
        this.id = -1L;
        this.date = this.dateMidnight.toLocalDate();
        this.year = this.dateMidnight.getYear();
        this.month = this.dateMidnight.getMonthOfYear();
        this.day = this.dateMidnight.getDayOfMonth();
        this.week = this.dateMidnight.getWeekyear() * 100 + this.dateMidnight.getWeekOfWeekyear();
        this.quarter = quarter;
        this.term = term;
    }

    public long getId() {
        return this.id;
    }

    public DateMidnight getDate() {
        DateMidnight dm = this.dateMidnight;
        if (dm == null) {
            this.dateMidnight = dm = this.date.toDateMidnight();
        }
        return dm;
    }

    public int getYear() {
        return this.year;
    }

    public int getQuarter() {
        return this.quarter;
    }

    public int getMonth() {
        return this.month;
    }

    public int getWeek() {
        return this.week;
    }

    public int getDay() {
        return this.day;
    }

    public String getTerm() {
        return this.term;
    }

    public void setTerm(String term) {
        if (this.term != null) {
            throw new IllegalStateException("term is already set");
        }
        this.term = term;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            int prime = 31;
            h = 1;
            this.hashCode = h = 31 * h + (this.getDate() == null ? 0 : this.getDate().hashCode());
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateDimension)) {
            return false;
        }
        DateDimension other = (DateDimension)obj;
        return !(this.getDate() == null ? other.getDate() != null : !this.getDate().equals((Object)other.getDate()));
    }

    public String toString() {
        return this.getDate().toString("yyyy-MM-dd ZZ");
    }
}

