/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.dao.jpa;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Version;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.Type;
import org.jasig.portal.events.aggr.IEventAggregatorStatus;
import org.joda.time.DateTime;

@Entity
@Table(name="UP_EVENT_AGGR_STATUS")
@SequenceGenerator(name="UP_EVENT_AGGR_STATUS_GEN", sequenceName="UP_EVENT_AGGR_STATUS_SEQ", allocationSize=10)
@TableGenerator(name="UP_EVENT_AGGR_STATUS_GEN", pkColumnValue="UP_EVENT_AGGR_STATUS", allocationSize=10)
@NaturalIdCache
class EventAggregatorStatusImpl
implements IEventAggregatorStatus {
    @Id
    @GeneratedValue(generator="UP_EVENT_AGGR_STATUS_GEN")
    @Column(name="ID")
    private final long id;
    @Version
    @Column(name="ENTITY_VERSION")
    private final long entityVersion;
    @NaturalId
    @Column(name="PROCESSING_TYPE", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private final IEventAggregatorStatus.ProcessingType processingType;
    @Column(name="SERVER_NAME", length=200)
    private String serverName;
    @Column(name="LAST_START")
    @Type(type="dateTime")
    private DateTime lastStart;
    @Column(name="LAST_END")
    @Type(type="dateTime")
    private DateTime lastEnd;
    @Column(name="LAST_EVENT_DATE")
    @Type(type="dateTime")
    private DateTime lastEventDateTime;

    private EventAggregatorStatusImpl() {
        this.id = -1L;
        this.entityVersion = -1L;
        this.processingType = null;
    }

    EventAggregatorStatusImpl(IEventAggregatorStatus.ProcessingType processingType) {
        this.id = -1L;
        this.entityVersion = -1L;
        this.processingType = processingType;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public DateTime getLastStart() {
        return this.lastStart;
    }

    public void setLastStart(DateTime lastStart) {
        this.lastStart = lastStart;
    }

    public DateTime getLastEnd() {
        return this.lastEnd;
    }

    public void setLastEnd(DateTime lastEnd) {
        this.lastEnd = lastEnd;
    }

    public DateTime getLastEventDate() {
        return this.lastEventDateTime;
    }

    public void setLastEventDate(DateTime lastEventDateTime) {
        this.lastEventDateTime = lastEventDateTime;
    }

    public IEventAggregatorStatus.ProcessingType getProcessingType() {
        return this.processingType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.processingType == null ? 0 : this.processingType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventAggregatorStatusImpl other = (EventAggregatorStatusImpl)obj;
        return this.processingType == other.processingType;
    }

    public String toString() {
        return "EventAggregatorStatusImpl [id=" + this.id + ", entityVersion=" + this.entityVersion + ", processingType=" + this.processingType + ", serverName=" + this.serverName + ", lastStart=" + this.lastStart + ", lastEnd=" + this.lastEnd + ", lastEventDateTime=" + this.lastEventDateTime + "]";
    }
}

