/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.groups;

import com.google.common.base.Function;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Attribute;
import org.jasig.portal.events.aggr.groups.AggregatedGroupLookupDao;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMappingImpl;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMappingImpl_;
import org.jasig.portal.groups.CompositeEntityIdentifier;
import org.jasig.portal.groups.ICompositeGroupService;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.jpa.BaseAggrEventsJpaDao;
import org.jasig.portal.jpa.BaseJpaDao;
import org.jasig.portal.jpa.OpenEntityManager;
import org.jasig.portal.jpa.cache.EntityManagerCache;
import org.jasig.portal.utils.cache.CacheKey;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.support.TransactionCallback;

@Repository
public class JpaAggregatedGroupLookupDao
extends BaseAggrEventsJpaDao
implements AggregatedGroupLookupDao {
    private CriteriaQuery<AggregatedGroupMappingImpl> findAllGroupMappingsQuery;
    private EntityManagerCache entityManagerCache;
    private ICompositeGroupService compositeGroupService;
    private final Set<String> warnedGroupKeys = Collections.newSetFromMap(new ConcurrentHashMap());

    @Autowired
    public void setEntityManagerCache(EntityManagerCache entityManagerCache) {
        this.entityManagerCache = entityManagerCache;
    }

    @Autowired
    public void setCompositeGroupService(ICompositeGroupService compositeGroupService) {
        this.compositeGroupService = compositeGroupService;
    }

    public void afterPropertiesSet() throws Exception {
        this.findAllGroupMappingsQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    @OpenEntityManager(unitName="AggrEventsDb")
    public AggregatedGroupMapping getGroupMapping(String groupService, String groupName) {
        CacheKey key = CacheKey.build((String)this.getClass().getName(), (Serializable[])new Serializable[]{groupService, groupName});
        AggregatedGroupMapping groupMapping = (AggregatedGroupMapping)this.entityManagerCache.get("AggrEventsDb", (Serializable)key);
        if (groupMapping != null) {
            return groupMapping;
        }
        BaseJpaDao.NaturalIdQuery query = this.createNaturalIdQuery(AggregatedGroupMappingImpl.class);
        query.using((Attribute)AggregatedGroupMappingImpl_.groupService, (Object)groupService);
        query.using((Attribute)AggregatedGroupMappingImpl_.groupName, (Object)groupName);
        groupMapping = (AggregatedGroupMapping)query.load();
        if (groupMapping != null) {
            this.entityManagerCache.put("AggrEventsDb", (Serializable)key, (Object)groupMapping);
            return groupMapping;
        }
        return (AggregatedGroupMapping)this.getTransactionOperations().execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @OpenEntityManager(unitName="AggrEventsDb")
    public AggregatedGroupMapping getGroupMapping(String portalGroupKey) {
        IEntityGroup group = this.compositeGroupService.findGroup(portalGroupKey);
        if (group == null) {
            if (this.warnedGroupKeys.add(portalGroupKey)) {
                this.logger.warn("No group found for key {}, no aggregate group mapping will be done and the group key will be ignored.", (Object)portalGroupKey);
            }
            CompositeEntityIdentifier compositeEntityIdentifier = new CompositeEntityIdentifier(portalGroupKey, IEntityGroup.class);
            String serviceName = compositeEntityIdentifier.getServiceName().toString();
            String groupKey = compositeEntityIdentifier.getLocalKey();
            return this.getGroupMapping(serviceName, groupKey);
        }
        String groupService = group.getServiceName().toString();
        String groupName = group.getName();
        return this.getGroupMapping(groupService, groupName);
    }

    public Set<AggregatedGroupMapping> getGroupMappings() {
        TypedQuery cachedQuery = this.createCachedQuery(this.findAllGroupMappingsQuery);
        cachedQuery.setFlushMode(FlushModeType.COMMIT);
        return new LinkedHashSet<AggregatedGroupMapping>(cachedQuery.getResultList());
    }

    public AggregatedGroupMapping getGroupMapping(long groupMappingId) {
        return (AggregatedGroupMapping)this.getEntityManager().find(AggregatedGroupMappingImpl.class, (Object)groupMappingId);
    }

    static /* synthetic */ EntityManager access$000(JpaAggregatedGroupLookupDao x0) {
        return x0.getEntityManager();
    }

    static /* synthetic */ Logger access$100(JpaAggregatedGroupLookupDao x0) {
        return x0.logger;
    }

    static /* synthetic */ EntityManagerCache access$200(JpaAggregatedGroupLookupDao x0) {
        return x0.entityManagerCache;
    }
}

