/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.portletlayout;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Parameter;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.Attribute;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.JpaBaseAggregationDao;
import org.jasig.portal.events.aggr.TimeDimension;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.portletlayout.PortletLayoutAggregationImpl;
import org.jasig.portal.events.aggr.portletlayout.PortletLayoutAggregationImpl_;
import org.jasig.portal.events.aggr.portletlayout.PortletLayoutAggregationKey;
import org.jasig.portal.events.aggr.portletlayout.PortletLayoutAggregationPrivateDao;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletMapping;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletMappingImpl;
import org.jasig.portal.jpa.BaseJpaDao;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.springframework.stereotype.Repository;

@Repository
public class JpaPortletLayoutAggregationDao
extends JpaBaseAggregationDao<PortletLayoutAggregationImpl, PortletLayoutAggregationKey>
implements PortletLayoutAggregationPrivateDao {
    private ParameterExpression<Set> portletMappingParameter;
    protected CriteriaQuery<PortletLayoutAggregationImpl> findAllPortletAggregationsByDateRangeQuery;

    public JpaPortletLayoutAggregationDao() {
        super(PortletLayoutAggregationImpl.class);
    }

    protected void createCriteriaQueries() {
        this.findAllPortletAggregationsByDateRangeQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void createParameterExpressions() {
        this.portletMappingParameter = this.createParameterExpression(Set.class, "portletMapping");
    }

    protected void addFetches(Root<PortletLayoutAggregationImpl> root) {
    }

    protected void addUnclosedPredicate(CriteriaBuilder cb, Root<PortletLayoutAggregationImpl> root, List<Predicate> keyPredicates) {
        keyPredicates.add(cb.isFalse((Expression)root.get(PortletLayoutAggregationImpl_.complete)));
    }

    protected void addAggregationSpecificKeyPredicate(CriteriaBuilder cb, Root<PortletLayoutAggregationImpl> root, List<Predicate> keyPredicates) {
        keyPredicates.add(root.get(PortletLayoutAggregationImpl_.aggregatedPortlet).in(new Expression[]{this.portletMappingParameter}));
    }

    public final List<PortletLayoutAggregationImpl> getAggregationsForAllPortlets(DateTime start, DateTime end, AggregationInterval interval, AggregatedGroupMapping aggregatedGroupMapping, AggregatedGroupMapping ... aggregatedGroupMappings) {
        if (!start.isBefore((ReadableInstant)end)) {
            throw new IllegalArgumentException("Start must be before End: " + start + " - " + end);
        }
        LocalDate startDate = start.toLocalDate();
        LocalDate endDate = end.toLocalDate();
        TypedQuery query = this.createQuery(this.findAllPortletAggregationsByDateRangeQuery);
        query.setParameter((Parameter)this.startDate, (Object)startDate);
        query.setParameter((Parameter)this.startTime, (Object)start.toLocalTime());
        query.setParameter((Parameter)this.endDate, (Object)endDate);
        query.setParameter((Parameter)this.endTime, (Object)end.toLocalTime());
        query.setParameter((Parameter)this.endPlusOneDate, (Object)endDate.plusDays(1));
        query.setParameter((Parameter)this.intervalParameter, (Object)interval);
        ImmutableSet groups = ImmutableSet.builder().add((Object)aggregatedGroupMapping).add((Object[])aggregatedGroupMappings).build();
        query.setParameter((Parameter)this.aggregatedGroupsParameter, (Object)groups);
        return query.getResultList();
    }

    protected void bindAggregationSpecificKeyParameters(TypedQuery<PortletLayoutAggregationImpl> query, Set<PortletLayoutAggregationKey> keys) {
        query.setParameter((Parameter)this.portletMappingParameter, (Object)this.extractAggregatePortletMappings(keys));
    }

    private Set<AggregatedPortletMapping> extractAggregatePortletMappings(Set<PortletLayoutAggregationKey> keys) {
        HashSet<AggregatedPortletMapping> portletMappings = new HashSet<AggregatedPortletMapping>();
        for (PortletLayoutAggregationKey key : keys) {
            portletMappings.add(key.getPortletMapping());
        }
        return portletMappings;
    }

    protected void bindAggregationSpecificKeyParameters(BaseJpaDao.NaturalIdQuery<PortletLayoutAggregationImpl> query, PortletLayoutAggregationKey key) {
        query.using((Attribute)PortletLayoutAggregationImpl_.aggregatedPortlet, (Object)((AggregatedPortletMappingImpl)key.getPortletMapping()));
    }

    protected PortletLayoutAggregationImpl createAggregationInstance(PortletLayoutAggregationKey key) {
        TimeDimension timeDimension = key.getTimeDimension();
        DateDimension dateDimension = key.getDateDimension();
        AggregationInterval interval = key.getInterval();
        AggregatedGroupMapping aggregatedGroup = key.getAggregatedGroup();
        AggregatedPortletMapping portletMapping = key.getPortletMapping();
        return new PortletLayoutAggregationImpl(timeDimension, dateDimension, interval, aggregatedGroup, portletMapping);
    }

    protected PortletLayoutAggregationKey getAggregationKey(PortletLayoutAggregationImpl instance) {
        return instance.getAggregationKey();
    }

    static /* synthetic */ ParameterExpression access$000(JpaPortletLayoutAggregationDao x0) {
        return x0.startDate;
    }

    static /* synthetic */ ParameterExpression access$100(JpaPortletLayoutAggregationDao x0) {
        return x0.endPlusOneDate;
    }

    static /* synthetic */ ParameterExpression access$200(JpaPortletLayoutAggregationDao x0) {
        return x0.startDate;
    }

    static /* synthetic */ ParameterExpression access$300(JpaPortletLayoutAggregationDao x0) {
        return x0.startTime;
    }

    static /* synthetic */ ParameterExpression access$400(JpaPortletLayoutAggregationDao x0) {
        return x0.endDate;
    }

    static /* synthetic */ ParameterExpression access$500(JpaPortletLayoutAggregationDao x0) {
        return x0.endTime;
    }

    static /* synthetic */ ParameterExpression access$600(JpaPortletLayoutAggregationDao x0) {
        return x0.intervalParameter;
    }

    static /* synthetic */ ParameterExpression access$700(JpaPortletLayoutAggregationDao x0) {
        return x0.aggregatedGroupsParameter;
    }
}

