/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.portletlayout;

import java.util.HashMap;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.events.PortletAddedToLayoutPortalEvent;
import org.jasig.portal.events.PortletDeletedFromLayoutPortalEvent;
import org.jasig.portal.events.PortletLayoutPortalEvent;
import org.jasig.portal.events.PortletMovedInLayoutPortalEvent;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.AggregationIntervalInfo;
import org.jasig.portal.events.aggr.BaseAggregationPrivateDao;
import org.jasig.portal.events.aggr.BasePortalEventAggregator;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.EventAggregationContext;
import org.jasig.portal.events.aggr.TimeDimension;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.portletlayout.PortletLayoutAggregationImpl;
import org.jasig.portal.events.aggr.portletlayout.PortletLayoutAggregationKey;
import org.jasig.portal.events.aggr.portletlayout.PortletLayoutAggregationKeyImpl;
import org.jasig.portal.events.aggr.portletlayout.PortletLayoutAggregationPrivateDao;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletLookupDao;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletMapping;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;

public class PortletLayoutAggregator
extends BasePortalEventAggregator<PortletLayoutPortalEvent, PortletLayoutAggregationImpl, PortletLayoutAggregationKey> {
    private static final String MAPPED_PORTLETS_CACHE_KEY = PortletLayoutAggregator.class.getName() + "_MAPPED_PORTLETS";
    private PortletLayoutAggregationPrivateDao portletLayoutAggregationDao;
    private AggregatedPortletLookupDao aggregatedPortletLookupDao;

    @Autowired
    public void setAggregatedPortletLookupDao(AggregatedPortletLookupDao aggregatedPortletLookupDao) {
        this.aggregatedPortletLookupDao = aggregatedPortletLookupDao;
    }

    @Autowired
    public void setPortletAddAggregationDao(PortletLayoutAggregationPrivateDao portletAddAggregationDao) {
        this.portletLayoutAggregationDao = portletAddAggregationDao;
    }

    public boolean supports(Class<? extends PortalEvent> type) {
        return PortletLayoutPortalEvent.class.isAssignableFrom(type);
    }

    protected BaseAggregationPrivateDao<PortletLayoutAggregationImpl, PortletLayoutAggregationKey> getAggregationDao() {
        return this.portletLayoutAggregationDao;
    }

    protected void updateAggregation(PortletLayoutPortalEvent e, EventAggregationContext eventAggregationContext, AggregationIntervalInfo intervalInfo, PortletLayoutAggregationImpl aggregation) {
        int duration = intervalInfo.getDurationTo((ReadableInstant)e.getTimestampAsDate());
        aggregation.setDuration(duration);
        if (e instanceof PortletAddedToLayoutPortalEvent) {
            aggregation.countPortletAdd();
            return;
        }
        if (e instanceof PortletDeletedFromLayoutPortalEvent) {
            aggregation.countPortletDelete();
            return;
        }
        if (e instanceof PortletMovedInLayoutPortalEvent) {
            aggregation.countPortletMove();
            return;
        }
    }

    protected PortletLayoutAggregationKey createAggregationKey(PortletLayoutPortalEvent e, EventAggregationContext eventAggregationContext, AggregationIntervalInfo intervalInfo, AggregatedGroupMapping aggregatedGroup) {
        String fname;
        AggregatedPortletMapping mappedPortlet;
        TimeDimension timeDimension = intervalInfo.getTimeDimension();
        DateDimension dateDimension = intervalInfo.getDateDimension();
        AggregationInterval aggregationInterval = intervalInfo.getAggregationInterval();
        HashMap<String, AggregatedPortletMapping> mappedPortlets = (HashMap<String, AggregatedPortletMapping>)eventAggregationContext.getAttribute((Object)MAPPED_PORTLETS_CACHE_KEY);
        if (mappedPortlets == null) {
            mappedPortlets = new HashMap<String, AggregatedPortletMapping>();
            eventAggregationContext.setAttribute((Object)MAPPED_PORTLETS_CACHE_KEY, mappedPortlets);
        }
        if ((mappedPortlet = (AggregatedPortletMapping)mappedPortlets.get(fname = e.getFname())) == null) {
            mappedPortlet = this.aggregatedPortletLookupDao.getMappedPortletForFname(fname);
            mappedPortlets.put(fname, mappedPortlet);
        }
        return new PortletLayoutAggregationKeyImpl(dateDimension, timeDimension, aggregationInterval, aggregatedGroup, mappedPortlet);
    }
}

