/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.session;

import com.google.common.base.Function;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.metamodel.Attribute;
import org.jasig.portal.events.LoginEvent;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.events.aggr.groups.AggregatedGroupLookupDao;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.session.EventSession;
import org.jasig.portal.events.aggr.session.EventSessionDao;
import org.jasig.portal.events.aggr.session.EventSessionImpl;
import org.jasig.portal.events.aggr.session.EventSessionImpl_;
import org.jasig.portal.groups.ICompositeGroupService;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.jpa.BaseAggrEventsJpaDao;
import org.jasig.portal.jpa.BaseJpaDao;
import org.jasig.portal.jpa.cache.EntityManagerCache;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.utils.cache.CacheKey;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="eventSessionDao")
public class JpaEventSessionDao
extends BaseAggrEventsJpaDao
implements EventSessionDao {
    private static final String EVENT_SESSION_CACHE_SOURCE = JpaEventSessionDao.class.getName() + "_EVENT_SESSION";
    private String deleteByEventSessionIdQuery;
    private CriteriaQuery<EventSessionImpl> findExpiredEventSessionsQuery;
    private ParameterExpression<String> eventSessionIdParameter;
    private ParameterExpression<DateTime> dateTimeParameter;
    private AggregatedGroupLookupDao aggregatedGroupLookupDao;
    private ICompositeGroupService compositeGroupService;
    private EntityManagerCache entityManagerCache;

    @Autowired
    public void setEntityManagerCache(EntityManagerCache entityManagerCache) {
        this.entityManagerCache = entityManagerCache;
    }

    @Autowired
    public void setCompositeGroupService(ICompositeGroupService compositeGroupService) {
        this.compositeGroupService = compositeGroupService;
    }

    @Autowired
    public void setAggregatedGroupLookupDao(AggregatedGroupLookupDao aggregatedGroupLookupDao) {
        this.aggregatedGroupLookupDao = aggregatedGroupLookupDao;
    }

    public void afterPropertiesSet() throws Exception {
        this.eventSessionIdParameter = this.createParameterExpression(String.class, "eventSessionId");
        this.dateTimeParameter = this.createParameterExpression(DateTime.class, "dateTime");
        this.findExpiredEventSessionsQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteByEventSessionIdQuery = "DELETE FROM " + EventSessionImpl.class.getName() + " e " + "WHERE e." + EventSessionImpl_.eventSessionId.getName() + " = :" + this.eventSessionIdParameter.getName();
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public void storeEventSession(EventSession eventSession) {
        this.getEntityManager().persist((Object)eventSession);
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public EventSession getEventSession(PortalEvent event) {
        String eventSessionId = event.getEventSessionId();
        CacheKey key = CacheKey.build((String)EVENT_SESSION_CACHE_SOURCE, (Serializable[])new Serializable[]{eventSessionId});
        EventSessionImpl eventSession = (EventSessionImpl)this.entityManagerCache.get("AggrEventsDb", (Serializable)key);
        if (eventSession != null) {
            return eventSession;
        }
        BaseJpaDao.NaturalIdQuery naturalIdQuery = this.createNaturalIdQuery(EventSessionImpl.class);
        naturalIdQuery.using((Attribute)EventSessionImpl_.eventSessionId, (Object)eventSessionId);
        eventSession = (EventSessionImpl)naturalIdQuery.load();
        if (eventSession == null) {
            Set groupMappings = this.getGroupsForEvent(event);
            DateTime eventDate = event.getTimestampAsDate();
            eventSession = new EventSessionImpl(eventSessionId, eventDate, groupMappings);
            this.getEntityManager().persist((Object)eventSession);
            this.entityManagerCache.put("AggrEventsDb", (Serializable)key, (Object)eventSession);
        }
        return eventSession;
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public void deleteEventSession(String eventSessionId) {
        Query query = this.getEntityManager().createQuery(this.deleteByEventSessionIdQuery);
        query.setParameter(this.eventSessionIdParameter.getName(), (Object)eventSessionId);
        query.executeUpdate();
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public int purgeEventSessionsBefore(DateTime lastAggregatedEventDate) {
        TypedQuery query = this.createQuery(this.findExpiredEventSessionsQuery);
        query.setParameter((Parameter)this.dateTimeParameter, (Object)lastAggregatedEventDate);
        List resultList = query.getResultList();
        for (EventSessionImpl eventSession : resultList) {
            this.getEntityManager().remove((Object)eventSession);
        }
        return resultList.size();
    }

    protected Set<AggregatedGroupMapping> getGroupsForEvent(PortalEvent event) {
        LinkedHashSet<AggregatedGroupMapping> groupMappings = new LinkedHashSet<AggregatedGroupMapping>();
        if (event instanceof LoginEvent) {
            for (String groupKey : ((LoginEvent)event).getGroups()) {
                AggregatedGroupMapping groupMapping = this.aggregatedGroupLookupDao.getGroupMapping(groupKey);
                if (groupMapping == null) continue;
                groupMappings.add(groupMapping);
            }
        } else {
            String userName = event.getUserName();
            IGroupMember groupMember = this.compositeGroupService.getGroupMember(userName, IPerson.class);
            Iterator containingGroups = this.compositeGroupService.findContainingGroups(groupMember);
            while (containingGroups.hasNext()) {
                IEntityGroup group = (IEntityGroup)containingGroups.next();
                AggregatedGroupMapping groupMapping = this.aggregatedGroupLookupDao.getGroupMapping(group.getServiceName().toString(), group.getName());
                groupMappings.add(groupMapping);
            }
        }
        return groupMappings;
    }

    static /* synthetic */ ParameterExpression access$000(JpaEventSessionDao x0) {
        return x0.dateTimeParameter;
    }
}

