/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.stat;

import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.Transient;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.stat.descriptive.moment.FirstMoment;
import org.apache.commons.math3.stat.descriptive.moment.GeometricMean;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.SecondMoment;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Min;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.apache.commons.math3.stat.descriptive.summary.SumOfLogs;
import org.apache.commons.math3.stat.descriptive.summary.SumOfSquares;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.Precision;
import org.jasig.portal.events.aggr.TimedAggregationStatistics;

@Embeddable
public class JpaStatisticalSummary
implements TimedAggregationStatistics {
    @Embedded
    private SecondMoment secondMoment;
    @Embedded
    private Sum sum;
    @Embedded
    private SumOfSquares sumsq;
    @Embedded
    private Min min;
    @Embedded
    private Max max;
    @Embedded
    private SumOfLogs sumLog;
    @Transient
    private GeometricMean geoMean;
    @Transient
    private Mean mean;
    @Transient
    private Variance variance;

    private SecondMoment _getSecondMoment() {
        if (this.secondMoment == null) {
            this.secondMoment = new SecondMoment();
        }
        return this.secondMoment;
    }

    private Sum _getSum() {
        if (this.sum == null) {
            this.sum = new Sum();
        }
        return this.sum;
    }

    private SumOfSquares _getSumsq() {
        if (this.sumsq == null) {
            this.sumsq = new SumOfSquares();
        }
        return this.sumsq;
    }

    private Min _getMin() {
        if (this.min == null) {
            this.min = new Min();
        }
        return this.min;
    }

    private Max _getMax() {
        if (this.max == null) {
            this.max = new Max();
        }
        return this.max;
    }

    private SumOfLogs _getSumLog() {
        if (this.sumLog == null) {
            this.sumLog = new SumOfLogs();
        }
        return this.sumLog;
    }

    private GeometricMean _getGeoMean() {
        if (this.geoMean == null) {
            this.geoMean = new GeometricMean(this._getSumLog());
        }
        return this.geoMean;
    }

    private Mean _getMean() {
        if (this.mean == null) {
            this.mean = new Mean((FirstMoment)this._getSecondMoment());
        }
        return this.mean;
    }

    private Variance _getVariance() {
        if (this.variance == null) {
            this.variance = new Variance(this._getSecondMoment());
        }
        return this.variance;
    }

    public void addValue(double value) {
        this._getSum().increment(value);
        this._getSumsq().increment(value);
        this._getMin().increment(value);
        this._getMax().increment(value);
        this._getSumLog().increment(value);
        this._getSecondMoment().increment(value);
    }

    public long getN() {
        return this._getSum().getN();
    }

    public double getSum() {
        return this._getSum().getResult();
    }

    public double getSumsq() {
        return this._getSumsq().getResult();
    }

    public double getMean() {
        return this._getMean().getResult();
    }

    public double getStandardDeviation() {
        double stdDev = Double.NaN;
        if (this.getN() > 0L) {
            stdDev = this.getN() > 1L ? FastMath.sqrt((double)this.getVariance()) : 0.0;
        }
        return stdDev;
    }

    public double getVariance() {
        return this._getVariance().getResult();
    }

    public double getPopulationVariance() {
        Variance populationVariance = new Variance(this._getSecondMoment());
        populationVariance.setBiasCorrected(false);
        return populationVariance.getResult();
    }

    public double getMax() {
        return this._getMax().getResult();
    }

    public double getMin() {
        return this._getMin().getResult();
    }

    public double getGeometricMean() {
        return this._getGeoMean().getResult();
    }

    public double getSumOfLogs() {
        return this._getSumLog().getResult();
    }

    public double getSecondMoment() {
        return this._getSecondMoment().getResult();
    }

    public String toString() {
        StringBuilder outBuffer = new StringBuilder();
        outBuffer.append("SummaryStatistics:").append("\n");
        outBuffer.append("n: ").append(this.getN()).append("\n");
        outBuffer.append("min: ").append(this.getMin()).append("\n");
        outBuffer.append("max: ").append(this.getMax()).append("\n");
        outBuffer.append("mean: ").append(this.getMean()).append("\n");
        outBuffer.append("geometric mean: ").append(this.getGeometricMean()).append("\n");
        outBuffer.append("variance: ").append(this.getVariance()).append("\n");
        outBuffer.append("sum of squares: ").append(this.getSumsq()).append("\n");
        outBuffer.append("standard deviation: ").append(this.getStandardDeviation()).append("\n");
        outBuffer.append("sum of logs: ").append(this.getSumOfLogs()).append("\n");
        return outBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SummaryStatistics)) {
            return false;
        }
        SummaryStatistics stat = (SummaryStatistics)object;
        return Precision.equalsIncludingNaN((double)stat.getGeometricMean(), (double)this.getGeometricMean()) && Precision.equalsIncludingNaN((double)stat.getMax(), (double)this.getMax()) && Precision.equalsIncludingNaN((double)stat.getMean(), (double)this.getMean()) && Precision.equalsIncludingNaN((double)stat.getMin(), (double)this.getMin()) && Precision.equalsIncludingNaN((float)stat.getN(), (float)this.getN()) && Precision.equalsIncludingNaN((double)stat.getSum(), (double)this.getSum()) && Precision.equalsIncludingNaN((double)stat.getSumsq(), (double)this.getSumsq()) && Precision.equalsIncludingNaN((double)stat.getVariance(), (double)this.getVariance());
    }

    public int hashCode() {
        int result = 31 + MathUtils.hash((double)this.getGeometricMean());
        result = result * 31 + MathUtils.hash((double)this.getGeometricMean());
        result = result * 31 + MathUtils.hash((double)this.getMax());
        result = result * 31 + MathUtils.hash((double)this.getMean());
        result = result * 31 + MathUtils.hash((double)this.getMin());
        result = result * 31 + MathUtils.hash((double)this.getN());
        result = result * 31 + MathUtils.hash((double)this.getSum());
        result = result * 31 + MathUtils.hash((double)this.getSumsq());
        result = result * 31 + MathUtils.hash((double)this.getVariance());
        return result;
    }
}

