/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.tabrender;

import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.Table;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.BaseTimedAggregationStatsImpl;
import org.jasig.portal.events.aggr.DateDimension;
import org.jasig.portal.events.aggr.TimeDimension;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.tabrender.TabRenderAggregation;
import org.jasig.portal.events.aggr.tabrender.TabRenderAggregationDiscriminator;
import org.jasig.portal.events.aggr.tabrender.TabRenderAggregationDiscriminatorImpl;
import org.jasig.portal.events.aggr.tabrender.TabRenderAggregationKey;
import org.jasig.portal.events.aggr.tabrender.TabRenderAggregationKeyImpl;
import org.jasig.portal.events.aggr.tabs.AggregatedTabMapping;
import org.jasig.portal.events.aggr.tabs.AggregatedTabMappingImpl;

@Entity
@javax.persistence.Table(name="UP_TAB_RENDER_AGGR")
@Inheritance(strategy=InheritanceType.JOINED)
@SequenceGenerator(name="UP_TAB_RENDER_AGGR_GEN", sequenceName="UP_TAB_RENDER_AGGR_SEQ", allocationSize=5000)
@TableGenerator(name="UP_TAB_RENDER_AGGR_GEN", pkColumnValue="UP_TAB_RENDER_AGGR_PROP", allocationSize=5000)
@Table(appliesTo="UP_TAB_RENDER_AGGR", indexes={@Index(name="IDX_UP_TAB_REND_AGGR_DTI", columnNames={"DATE_DIMENSION_ID", "TIME_DIMENSION_ID", "AGGR_INTERVAL"}), @Index(name="IDX_UP_TAB_REND_AGGR_DTIC", columnNames={"DATE_DIMENSION_ID", "TIME_DIMENSION_ID", "AGGR_INTERVAL", "STATS_COMPLETE"}), @Index(name="IDX_UP_TAB_REND_INTRVL", columnNames={"AGGR_INTERVAL"}), @Index(name="IDX_UP_TAB_REND_GRP", columnNames={"AGGR_GROUP_ID"})})
@NaturalIdCache
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public final class TabRenderAggregationImpl
extends BaseTimedAggregationStatsImpl<TabRenderAggregationKey, TabRenderAggregationDiscriminator>
implements TabRenderAggregation,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UP_TAB_RENDER_AGGR_GEN")
    @Column(name="ID")
    private final long id;
    @NaturalId
    @ManyToOne(targetEntity=AggregatedTabMappingImpl.class)
    @JoinColumn(name="AGGR_TAB_ID", nullable=false)
    private final AggregatedTabMapping aggregatedTab;
    @Transient
    private TabRenderAggregationKey aggregationKey;
    @Transient
    private TabRenderAggregationDiscriminator aggregationDiscriminator;

    private TabRenderAggregationImpl() {
        this.id = -1L;
        this.aggregatedTab = null;
    }

    TabRenderAggregationImpl(TimeDimension timeDimension, DateDimension dateDimension, AggregationInterval interval, AggregatedGroupMapping aggregatedGroup, AggregatedTabMapping aggregatedTab) {
        super(timeDimension, dateDimension, interval, aggregatedGroup);
        Validate.notNull((Object)aggregatedTab);
        this.id = -1L;
        this.aggregatedTab = aggregatedTab;
    }

    public long getId() {
        return this.id;
    }

    public AggregatedTabMapping getTabMapping() {
        return this.aggregatedTab;
    }

    public int getRenderCount() {
        return (int)this.getN();
    }

    public TabRenderAggregationKey getAggregationKey() {
        TabRenderAggregationKey key = this.aggregationKey;
        if (key == null) {
            this.aggregationKey = key = new TabRenderAggregationKeyImpl((TabRenderAggregation)this);
        }
        return key;
    }

    public TabRenderAggregationDiscriminator getAggregationDiscriminator() {
        TabRenderAggregationDiscriminator discriminator = this.aggregationDiscriminator;
        if (discriminator == null) {
            this.aggregationDiscriminator = discriminator = new TabRenderAggregationDiscriminatorImpl((TabRenderAggregation)this);
        }
        return discriminator;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.aggregatedTab == null ? 0 : this.aggregatedTab.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof TabRenderAggregation)) {
            return false;
        }
        TabRenderAggregation other = (TabRenderAggregation)obj;
        return !(this.aggregatedTab == null ? other.getTabMapping() != null : !this.aggregatedTab.equals(other.getTabMapping()));
    }

    public String toString() {
        return "TabRenderAggregationImpl [aggregatedTab=" + this.aggregatedTab + ", timeDimension=" + this.getTimeDimension() + ", dateDimension=" + this.getDateDimension() + ", interval=" + this.getInterval() + ", aggregatedGroup=" + this.getAggregatedGroup() + "]";
    }
}

