/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.aggr.tabs;

import com.google.common.base.Function;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Attribute;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.jasig.portal.events.aggr.tabs.AggregatedTabLookupDao;
import org.jasig.portal.events.aggr.tabs.AggregatedTabMapping;
import org.jasig.portal.events.aggr.tabs.AggregatedTabMappingImpl;
import org.jasig.portal.events.aggr.tabs.AggregatedTabMappingImpl_;
import org.jasig.portal.jpa.BaseAggrEventsJpaDao;
import org.jasig.portal.jpa.BaseJpaDao;
import org.jasig.portal.jpa.OpenEntityManager;
import org.jasig.portal.jpa.cache.EntityManagerCache;
import org.jasig.portal.utils.Tuple;
import org.jasig.portal.utils.cache.CacheKey;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.support.TransactionCallback;

@Repository
public class JpaAggregatedTabLookupDao
extends BaseAggrEventsJpaDao
implements AggregatedTabLookupDao {
    private static final Pattern DLM_NODE = Pattern.compile("^u(\\d+)l(\\d+)s(\\d+)$");
    private CriteriaQuery<AggregatedTabMappingImpl> findAllTabMappingsQuery;
    private EntityManagerCache entityManagerCache;
    private JdbcOperations portalJdbcOperations;
    private Ehcache layoutNodeIdNameResolutionCache;

    @Autowired
    @Qualifier(value="org.jasig.portal.events.aggr.tabrender.TabRenderAggregator.layoutNodeIdNameResolver")
    public void setLayoutNodeIdNameResolutionCache(Ehcache layoutNodeIdNameResolutionCache) {
        this.layoutNodeIdNameResolutionCache = layoutNodeIdNameResolutionCache;
    }

    @Autowired
    @Qualifier(value="PortalDb")
    public void setPortalJdbcOperations(JdbcOperations portalJdbcOperations) {
        this.portalJdbcOperations = portalJdbcOperations;
    }

    @Autowired
    public void setEntityManagerCache(EntityManagerCache entityManagerCache) {
        this.entityManagerCache = entityManagerCache;
    }

    public void afterPropertiesSet() throws Exception {
        this.findAllTabMappingsQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    @OpenEntityManager(unitName="AggrEventsDb")
    public AggregatedTabMapping getMappedTabForLayoutId(String layoutNodeId) {
        Tuple resolveTabName = this.resolveTabName(layoutNodeId);
        return this.getTabMapping((String)resolveTabName.first, (String)resolveTabName.second);
    }

    @OpenEntityManager(unitName="AggrEventsDb")
    public AggregatedTabMapping getTabMapping(String fragmentName, String tabName) {
        CacheKey key = CacheKey.build((String)this.getClass().getName(), (Serializable[])new Serializable[]{tabName});
        AggregatedTabMapping tabMapping = (AggregatedTabMapping)this.entityManagerCache.get("AggrEventsDb", (Serializable)key);
        if (tabMapping != null) {
            return tabMapping;
        }
        BaseJpaDao.NaturalIdQuery query = this.createNaturalIdQuery(AggregatedTabMappingImpl.class);
        query.using((Attribute)AggregatedTabMappingImpl_.fragmentName, (Object)fragmentName);
        query.using((Attribute)AggregatedTabMappingImpl_.tabName, (Object)tabName);
        tabMapping = (AggregatedTabMapping)query.load();
        if (tabMapping != null) {
            this.entityManagerCache.put("AggrEventsDb", (Serializable)key, (Object)tabMapping);
            return tabMapping;
        }
        return (AggregatedTabMapping)this.getTransactionOperations().execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Set<AggregatedTabMapping> getTabMappings() {
        TypedQuery cachedQuery = this.createCachedQuery(this.findAllTabMappingsQuery);
        cachedQuery.setFlushMode(FlushModeType.COMMIT);
        return new LinkedHashSet<AggregatedTabMapping>(cachedQuery.getResultList());
    }

    protected final Tuple<String, String> resolveTabName(String targetedLayoutNodeId) {
        String tabName;
        String fragmentName;
        Element element = this.layoutNodeIdNameResolutionCache.get((Serializable)((Object)targetedLayoutNodeId));
        if (element != null) {
            return (Tuple)element.getObjectValue();
        }
        if (targetedLayoutNodeId == null) {
            fragmentName = "CATCH_ALL_MISSING_TAB_OWNER";
            tabName = "Missing Tab";
        } else {
            Matcher nodeIdMatcher = DLM_NODE.matcher(targetedLayoutNodeId);
            if (nodeIdMatcher.matches()) {
                int userId = Integer.parseInt(nodeIdMatcher.group(1));
                int layoutId = Integer.parseInt(nodeIdMatcher.group(2));
                int nodeId = Integer.parseInt(nodeIdMatcher.group(3));
                List tabNameResult = this.portalJdbcOperations.queryForList("SELECT NAME FROM UP_LAYOUT_STRUCT where USER_ID = ? AND LAYOUT_ID = ? AND STRUCT_ID = ?", String.class, new Object[]{userId, layoutId, nodeId});
                tabName = tabNameResult.isEmpty() ? targetedLayoutNodeId : (String)tabNameResult.iterator().next();
                List userNameResult = this.portalJdbcOperations.queryForList("SELECT USER_NAME FROM UP_USER WHERE USER_ID=?", String.class, new Object[]{userId});
                fragmentName = userNameResult.isEmpty() ? "CATCH_ALL_MISSING_USER_OWNER" : (String)userNameResult.iterator().next();
            } else {
                fragmentName = "CATCH_ALL_PERSONAL_TAB_OWNER";
                tabName = "Personal Tab";
            }
        }
        Tuple tuple = new Tuple((Object)fragmentName, (Object)tabName);
        this.layoutNodeIdNameResolutionCache.put(new Element((Serializable)((Object)targetedLayoutNodeId), (Serializable)tuple));
        return tuple;
    }

    public AggregatedTabMapping getTabMapping(long tabMappingId) {
        return (AggregatedTabMapping)this.getEntityManager().find(AggregatedTabMappingImpl.class, (Object)tabMappingId);
    }

    static /* synthetic */ EntityManager access$000(JpaAggregatedTabLookupDao x0) {
        return x0.getEntityManager();
    }

    static /* synthetic */ Logger access$100(JpaAggregatedTabLookupDao x0) {
        return x0.logger;
    }

    static /* synthetic */ EntityManagerCache access$200(JpaAggregatedTabLookupDao x0) {
        return x0.entityManagerCache;
    }
}

