/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.handlers.db;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;
import org.jasig.portal.events.PortalEvent;
import org.joda.time.DateTime;

@Entity
@Table(name="UP_RAW_EVENTS")
@Inheritance(strategy=InheritanceType.JOINED)
@SequenceGenerator(name="UP_RAW_EVENTS_GEN", sequenceName="UP_RAW_EVENTS_SEQ", allocationSize=1000)
@TableGenerator(name="UP_RAW_EVENTS_GEN", pkColumnValue="UP_RAW_EVENTS_PROP", allocationSize=1000)
public class PersistentPortalEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UP_RAW_EVENTS_GEN")
    @Column(name="EVENT_ID")
    private final long id;
    @Index(name="IDX_UP_RAW_EVENTS_TIMESTAMP")
    @Column(name="TIMESTAMP", nullable=false, updatable=false)
    @Type(type="dateTime")
    private final DateTime timestamp;
    @Index(name="IDX_UP_RAW_EVENTS_SERVER_ID")
    @Column(name="SERVER_ID", length=200, nullable=false, updatable=false)
    private final String serverId;
    @Index(name="IDX_UP_RAW_EVENTS_SESSION_ID")
    @Column(name="SESSION_ID", length=500, nullable=false, updatable=false)
    private final String eventSessionId;
    @Index(name="IDX_UP_RAW_EVENTS_USER_NAME")
    @Column(name="USER_NAME", length=35, nullable=false, updatable=false)
    private final String userName;
    @Column(name="EVENT_TYPE", length=200, nullable=false, updatable=false)
    @Type(type="class")
    private final Class<PortalEvent> eventType;
    @Column(name="EVENT_DATA", nullable=false, updatable=false, length=10000)
    @Lob
    private final String eventData;
    @Index(name="IDX_UP_RAW_EVENTS_AGGREGATED")
    @Column(name="AGGREGATED")
    private Boolean aggregated = false;

    private PersistentPortalEvent() {
        this.id = -1L;
        this.eventData = null;
        this.timestamp = null;
        this.serverId = null;
        this.eventSessionId = null;
        this.userName = null;
        this.eventType = null;
    }

    PersistentPortalEvent(PortalEvent portalEvent, String eventData) {
        this.id = -1L;
        this.eventData = eventData;
        this.timestamp = new DateTime(portalEvent.getTimestamp());
        this.serverId = portalEvent.getServerId();
        this.eventSessionId = portalEvent.getEventSessionId();
        this.userName = portalEvent.getUserName();
        this.eventType = portalEvent.getClass();
    }

    public Class<PortalEvent> getEventType() {
        return this.eventType;
    }

    public String getEventData() {
        return this.eventData;
    }

    public boolean isAggregated() {
        Boolean a = this.aggregated;
        if (a == null) {
            this.aggregated = a = Boolean.valueOf(false);
        }
        return a;
    }

    void setAggregated(boolean aggregated) {
        this.aggregated = aggregated;
    }

    public String toString() {
        return this.eventData;
    }
}

