/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.fragment.subscribe.dao.jpa;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Parameter;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.ParameterExpression;
import org.apache.commons.lang.Validate;
import org.jasig.portal.fragment.subscribe.IUserFragmentSubscription;
import org.jasig.portal.fragment.subscribe.dao.IUserFragmentSubscriptionDao;
import org.jasig.portal.fragment.subscribe.dao.jpa.UserFragmentSubscriptionImpl;
import org.jasig.portal.jpa.BasePortalJpaDao;
import org.jasig.portal.security.IPerson;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Repository;

@Repository
public class JpaUserFragmentSubscriptionDaoImpl
extends BasePortalJpaDao
implements IUserFragmentSubscriptionDao {
    private CriteriaQuery<UserFragmentSubscriptionImpl> findUserFragmentInfoByPersonQuery;
    private CriteriaQuery<UserFragmentSubscriptionImpl> findUserFragmentInfoByPersonAndOwnerQuery;
    private CriteriaQuery<String> findUsersWithActiveSubscriptionsQuery;
    private ParameterExpression<Integer> userIdParameter;
    private ParameterExpression<String> fragmentOwnerParameter;

    public void afterPropertiesSet() throws Exception {
        this.userIdParameter = this.createParameterExpression(Integer.TYPE, "userId");
        this.fragmentOwnerParameter = this.createParameterExpression(String.class, "fragmentOwner");
        this.findUserFragmentInfoByPersonQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findUserFragmentInfoByPersonAndOwnerQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findUsersWithActiveSubscriptionsQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    @BasePortalJpaDao.PortalTransactional
    public IUserFragmentSubscription createUserFragmentInfo(IPerson person, IPerson fragmentOwner) {
        UserFragmentSubscriptionImpl userFragmentInfo = new UserFragmentSubscriptionImpl(person, fragmentOwner);
        this.getEntityManager().persist((Object)userFragmentInfo);
        return userFragmentInfo;
    }

    @BasePortalJpaDao.PortalTransactional
    public void deleteUserFragmentInfo(IUserFragmentSubscription userFragmentInfo) {
        Validate.notNull((Object)userFragmentInfo, (String)"user fragment info can not be null");
        userFragmentInfo.setInactive();
        this.getEntityManager().persist((Object)userFragmentInfo);
    }

    public List<IUserFragmentSubscription> getUserFragmentInfo(IPerson person) {
        TypedQuery query = this.createCachedQuery(this.findUserFragmentInfoByPersonQuery);
        query.setParameter((Parameter)this.userIdParameter, (Object)person.getID());
        List fragmentSubscriptions = query.getResultList();
        return new ArrayList<IUserFragmentSubscription>(fragmentSubscriptions);
    }

    public IUserFragmentSubscription getUserFragmentInfo(IPerson person, IPerson fragmentOwner) {
        TypedQuery query = this.createCachedQuery(this.findUserFragmentInfoByPersonAndOwnerQuery);
        query.setParameter((Parameter)this.userIdParameter, (Object)person.getID());
        query.setParameter((Parameter)this.fragmentOwnerParameter, (Object)fragmentOwner.getUserName());
        List fragmentSubscriptions = query.getResultList();
        return (IUserFragmentSubscription)DataAccessUtils.uniqueResult((Collection)fragmentSubscriptions);
    }

    public IUserFragmentSubscription getUserFragmentInfo(long userFragmentInfoId) {
        UserFragmentSubscriptionImpl userFragmentInfo = (UserFragmentSubscriptionImpl)this.getEntityManager().find(UserFragmentSubscriptionImpl.class, (Object)userFragmentInfoId);
        return userFragmentInfo;
    }

    @BasePortalJpaDao.PortalTransactional
    public void updateUserFragmentInfo(IUserFragmentSubscription userFragmentInfo) {
        Validate.notNull((Object)userFragmentInfo, (String)"user fragment info can not be null");
        this.getEntityManager().persist((Object)userFragmentInfo);
    }

    public List<String> getAllUsersWithActiveSubscriptions() {
        TypedQuery query = this.createCachedQuery(this.findUsersWithActiveSubscriptionsQuery);
        return query.getResultList();
    }

    static /* synthetic */ ParameterExpression access$000(JpaUserFragmentSubscriptionDaoImpl x0) {
        return x0.userIdParameter;
    }

    static /* synthetic */ ParameterExpression access$100(JpaUserFragmentSubscriptionDaoImpl x0) {
        return x0.fragmentOwnerParameter;
    }
}

