/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.groups.CompositeEntityIdentifier;
import org.jasig.portal.groups.GroupServiceConfiguration;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IGroupConstants;

public class CompositeEntityIdentifier
extends EntityIdentifier
implements IGroupConstants {
    protected static final String separator;
    private static final LoadingCache<String, Name> NAME_PARSE_CACHE;
    protected Name compositeKey;
    protected String cachedCompositeKey;
    protected String cachedLocalKey;
    protected Name cachedServiceName;

    public CompositeEntityIdentifier(String entityKey, Class entityType) throws GroupsException {
        super(entityKey, entityType);
        try {
            this.compositeKey = this.parseCompoundKey(entityKey);
        }
        catch (NamingException ne) {
            throw new GroupsException("Error in group key", (Throwable)ne);
        }
    }

    protected Name getCompositeKey() {
        return this.compositeKey;
    }

    public synchronized String getKey() {
        if (this.cachedCompositeKey == null) {
            this.cachedCompositeKey = this.getCompositeKey().toString();
        }
        return this.cachedCompositeKey;
    }

    public synchronized String getLocalKey() {
        if (this.cachedLocalKey == null) {
            this.cachedLocalKey = this.getCompositeKey().get(this.size() - 1);
        }
        return this.cachedLocalKey;
    }

    protected NameParser getParser() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public synchronized Name getServiceName() {
        if (this.size() < 2) {
            return null;
        }
        if (this.cachedServiceName == null) {
            this.cachedServiceName = this.getCompositeKey().getPrefix(this.size() - 1);
        }
        return this.cachedServiceName;
    }

    public Name newName() throws InvalidNameException {
        return new NameImpl();
    }

    public String popNode() throws InvalidNameException {
        return (String)this.getCompositeKey().remove(0);
    }

    public Name pushNode(String newNode) throws InvalidNameException {
        return this.getCompositeKey().add(0, newNode);
    }

    public synchronized void setCompositeKey(Name newCompositeKey) {
        this.compositeKey = newCompositeKey;
        this.cachedCompositeKey = null;
        this.cachedLocalKey = null;
        this.cachedServiceName = null;
    }

    public void setServiceName(Name newServiceName) throws InvalidNameException {
        Name newKey = this.newName().addAll(newServiceName).add(this.getLocalKey());
        this.setCompositeKey(newKey);
        this.cachedServiceName = newServiceName;
    }

    protected int size() {
        return this.getCompositeKey().size();
    }

    public String toString() {
        return "CompositeEntityIdentifier (" + this.type + "(" + this.getKey() + "))";
    }

    public Name parseCompoundKey(String key) throws NamingException {
        return (Name)NAME_PARSE_CACHE.getUnchecked((Object)key);
    }

    static {
        String sep;
        NAME_PARSE_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
        try {
            sep = GroupServiceConfiguration.getConfiguration().getNodeSeparator();
        }
        catch (Exception ex) {
            sep = ".";
        }
        separator = sep;
    }
}

