/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.groups.CompositeEntityIdentifier;
import org.jasig.portal.groups.GroupMemberImpl;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.IIndividualGroupService;
import org.jasig.portal.services.GroupService;

public class EntityGroupImpl
extends GroupMemberImpl
implements IEntityGroup {
    private String creatorID;
    private String name;
    private String description;
    protected IIndividualGroupService localGroupService;
    private final Log log = LogFactory.getLog(this.getClass());
    private Class leafEntityType;
    private Set memberGroupKeys;
    private Set memberEntityKeys;
    private boolean memberKeysInitialized;
    private HashMap addedMembers;
    private HashMap removedMembers;

    public EntityGroupImpl(String groupKey, Class entityType) throws GroupsException {
        super((EntityIdentifier)new CompositeEntityIdentifier(groupKey, EntityTypes.GROUP_ENTITY_TYPE));
        if (!this.isKnownEntityType(entityType)) {
            throw new GroupsException("Unknown entity type: " + entityType);
        }
        this.leafEntityType = entityType;
    }

    public void addMember(IGroupMember gm) throws GroupsException {
        try {
            this.checkProspectiveMember(gm);
        }
        catch (GroupsException ge) {
            throw new GroupsException("Could not add IGroupMember", (Throwable)ge);
        }
        if (!this.contains(gm)) {
            String cacheKey = gm.getEntityIdentifier().getKey();
            if (this.getRemovedMembers().containsKey(cacheKey)) {
                this.getRemovedMembers().remove(cacheKey);
            } else {
                this.getAddedMembers().put(cacheKey, gm);
            }
            if (this.memberKeysInitialized) {
                this.primAddMember(gm);
            }
        }
    }

    protected boolean areMemberKeysInitialized() {
        return this.memberKeysInitialized;
    }

    private void checkProspectiveMember(IGroupMember gm) throws GroupsException {
        if (gm.equals((Object)this)) {
            throw new GroupsException("Attempt to add " + gm + " to itself.");
        }
        if (this.getLeafType() != gm.getLeafType()) {
            throw new GroupsException(this + " and " + gm + " have different entity types.");
        }
        if (gm.isGroup() && gm.deepContains((IGroupMember)this)) {
            throw new GroupsException("Adding " + gm + " to " + this + " creates a circular reference.");
        }
    }

    protected void clearPendingUpdates() {
        this.addedMembers = null;
        this.removedMembers = null;
    }

    private Set copyMemberEntityKeys() throws GroupsException {
        return this.castAndCopyHashSet(this.getMemberEntityKeys());
    }

    private Set copyMemberGroupKeys() throws GroupsException {
        return this.castAndCopyHashSet(this.getMemberGroupKeys());
    }

    public boolean contains(IGroupMember gm) throws GroupsException {
        if (this.areMemberKeysInitialized()) {
            String cacheKey = gm.getKey();
            return this.getMemberGroupKeys().contains(cacheKey) || this.getMemberEntityKeys().contains(cacheKey);
        }
        return gm.isMemberOf((IGroupMember)this);
    }

    public boolean deepContains(IGroupMember gm) throws GroupsException {
        if (this.contains(gm)) {
            return true;
        }
        boolean found = false;
        Iterator it = this.getMemberGroups();
        while (it.hasNext() && !found) {
            IEntityGroup group = (IEntityGroup)it.next();
            if (group != null) {
                found = group.deepContains(gm);
                continue;
            }
            String msg = "Groups Integrety Error:  Group '" + this.getName() + "' refers to a child group that is no longer available";
            this.log.error((Object)msg);
        }
        return found;
    }

    public void delete() throws GroupsException {
        this.getLocalGroupService().deleteGroup((IEntityGroup)this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityGroupImpl)) {
            return false;
        }
        return this.getKey().equals(((IGroupMember)obj).getKey());
    }

    public HashMap getAddedMembers() {
        if (this.addedMembers == null) {
            this.addedMembers = new HashMap();
        }
        return this.addedMembers;
    }

    public Iterator getAllEntities() throws GroupsException {
        return this.primGetAllEntities(new HashSet()).iterator();
    }

    public Iterator getAllMembers() throws GroupsException {
        return this.primGetAllMembers(new HashSet()).iterator();
    }

    protected CompositeEntityIdentifier getCompositeEntityIdentifier() {
        return (CompositeEntityIdentifier)this.getEntityIdentifier();
    }

    public String getCreatorID() {
        return this.creatorID;
    }

    public String getDescription() {
        return this.description;
    }

    public Iterator getEntities() throws GroupsException {
        return this.getMemberEntities();
    }

    public EntityIdentifier getEntityIdentifier() {
        return this.getUnderlyingEntityIdentifier();
    }

    public String getEntityKey() {
        return this.getKey();
    }

    public Class getEntityType() {
        return this.leafEntityType;
    }

    public String getGroupID() {
        return this.getKey();
    }

    public Class getLeafType() {
        return this.leafEntityType;
    }

    protected IIndividualGroupService getLocalGroupService() {
        return this.localGroupService;
    }

    public String getLocalKey() {
        return this.getCompositeEntityIdentifier().getLocalKey();
    }

    protected Iterator getMemberEntities() throws GroupsException {
        ArrayList<IEntity> members = new ArrayList<IEntity>();
        for (String key : this.getMemberEntityKeys()) {
            members.add(this.getLocalGroupService().getEntity(key, this.getLeafType()));
        }
        return members.iterator();
    }

    private synchronized Set getMemberEntityKeys() throws GroupsException {
        if (!this.areMemberKeysInitialized()) {
            this.initializeMembers();
        }
        return this.memberEntityKeys;
    }

    private synchronized Set getMemberGroupKeys() throws GroupsException {
        if (!this.areMemberKeysInitialized()) {
            this.initializeMembers();
        }
        return this.memberGroupKeys;
    }

    public IEntityGroup getMemberGroupNamed(String name) throws GroupsException {
        Iterator itr = this.getMemberGroups();
        while (itr.hasNext()) {
            IGroupMember gm = (IGroupMember)itr.next();
            if (!((IEntityGroup)gm).getName().equals(name)) continue;
            return (IEntityGroup)gm;
        }
        return null;
    }

    protected Iterator getMemberGroups() throws GroupsException {
        ArrayList<IEntityGroup> members = new ArrayList<IEntityGroup>();
        for (String key : this.getMemberGroupKeys()) {
            members.add(GroupService.findGroup((String)key));
        }
        return members.iterator();
    }

    public Iterator getMembers() throws GroupsException {
        ArrayList members = new ArrayList(100);
        Iterator itr = null;
        itr = this.getMemberGroups();
        while (itr.hasNext()) {
            members.add(itr.next());
        }
        itr = this.getMemberEntities();
        while (itr.hasNext()) {
            members.add(itr.next());
        }
        return members.iterator();
    }

    public String getName() {
        return this.name;
    }

    public HashMap getRemovedMembers() {
        if (this.removedMembers == null) {
            this.removedMembers = new HashMap();
        }
        return this.removedMembers;
    }

    protected GroupService getService() throws GroupsException {
        return GroupService.instance();
    }

    public Name getServiceName() {
        return this.getCompositeEntityIdentifier().getServiceName();
    }

    public Class getType() {
        return EntityTypes.GROUP_ENTITY_TYPE;
    }

    public boolean hasAdds() {
        return this.addedMembers != null && this.addedMembers.size() > 0;
    }

    public boolean hasDeletes() {
        return this.removedMembers != null && this.removedMembers.size() > 0;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean hasMembers() throws GroupsException {
        return this.getMembers().hasNext();
    }

    private void initializeMembers() throws GroupsException {
        HashSet<String> groupKeys = new HashSet<String>();
        HashSet entityKeys = new HashSet(100);
        Iterator it = this.getLocalGroupService().findMembers((IEntityGroup)this);
        while (it.hasNext()) {
            IGroupMember gm = (IGroupMember)it.next();
            HashSet<String> cache = gm.isGroup() ? groupKeys : entityKeys;
            cache.add(gm.getKey());
        }
        this.setMemberEntityKeys(entityKeys);
        this.setMemberGroupKeys(groupKeys);
        this.setMemberKeysInitialized(true);
    }

    public boolean isDirty() {
        return this.hasAdds() || this.hasDeletes();
    }

    public boolean isEditable() throws GroupsException {
        return this.getLocalGroupService().isEditable((IEntityGroup)this);
    }

    public boolean isGroup() {
        return true;
    }

    protected void primAddMember(IGroupMember gm) throws GroupsException {
        Set cache = gm.isGroup() ? this.copyMemberGroupKeys() : this.copyMemberEntityKeys();
        cache.add(gm.getKey());
        if (gm.isGroup()) {
            this.setMemberGroupKeys(cache);
        } else {
            this.setMemberEntityKeys(cache);
        }
    }

    protected Set primGetAllEntities(Set entities) throws GroupsException {
        Iterator i = this.getMembers();
        while (i.hasNext()) {
            GroupMemberImpl gmi = (GroupMemberImpl)i.next();
            if (gmi.isEntity()) {
                entities.add(gmi);
                continue;
            }
            ((EntityGroupImpl)gmi).primGetAllEntities(entities);
        }
        return entities;
    }

    protected Set primGetAllMembers(Set s) throws GroupsException {
        Iterator i = this.getMembers();
        while (i.hasNext()) {
            GroupMemberImpl gmi = (GroupMemberImpl)i.next();
            s.add(gmi);
            if (!gmi.isGroup()) continue;
            ((EntityGroupImpl)gmi).primGetAllMembers(s);
        }
        return s;
    }

    protected void primRemoveMember(IGroupMember gm) throws GroupsException {
        Set cache = gm.isGroup() ? this.copyMemberGroupKeys() : this.copyMemberEntityKeys();
        cache.remove(gm.getKey());
        if (gm.isGroup()) {
            this.setMemberGroupKeys(cache);
        } else {
            this.setMemberEntityKeys(cache);
        }
    }

    public void primSetName(String newName) {
        this.name = newName;
    }

    public void removeMember(IGroupMember gm) throws GroupsException {
        String cacheKey = gm.getEntityIdentifier().getKey();
        if (this.getAddedMembers().containsKey(cacheKey)) {
            this.getAddedMembers().remove(cacheKey);
        } else {
            this.getRemovedMembers().put(cacheKey, gm);
        }
        this.primRemoveMember(gm);
    }

    public void setCreatorID(String newCreatorID) {
        this.creatorID = newCreatorID;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public void setLocalGroupService(IIndividualGroupService newIndividualGroupService) throws GroupsException {
        this.localGroupService = newIndividualGroupService;
        this.setServiceName(this.localGroupService.getServiceName());
    }

    private void setMemberKeysInitialized(boolean newMemberKeysInitialized) {
        this.memberKeysInitialized = newMemberKeysInitialized;
    }

    private synchronized void setMemberEntityKeys(Set newMemberEntityKeys) {
        this.memberEntityKeys = newMemberEntityKeys;
    }

    private synchronized void setMemberGroupKeys(Set newMemberGroupKeys) {
        this.memberGroupKeys = newMemberGroupKeys;
    }

    public void setName(String newName) throws GroupsException {
        this.primSetName(newName);
    }

    public void setServiceName(Name newServiceName) throws GroupsException {
        try {
            this.getCompositeEntityIdentifier().setServiceName(newServiceName);
        }
        catch (InvalidNameException ine) {
            throw new GroupsException("Problem setting service name", (Throwable)ine);
        }
    }

    public String toString() {
        return "EntityGroupImpl (" + this.getKey() + ") " + this.getName();
    }

    public void update() throws GroupsException {
        this.getLocalGroupService().updateGroup((IEntityGroup)this);
        this.clearPendingUpdates();
    }

    public void updateMembers() throws GroupsException {
        this.getLocalGroupService().updateGroupMembers((IEntityGroup)this);
        this.clearPendingUpdates();
    }
}

