/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.naming.Name;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.concurrency.CachingException;
import org.jasig.portal.concurrency.IEntityLock;
import org.jasig.portal.concurrency.LockingException;
import org.jasig.portal.groups.ComponentGroupServiceDescriptor;
import org.jasig.portal.groups.CompositeEntityIdentifier;
import org.jasig.portal.groups.EntityGroupImpl;
import org.jasig.portal.groups.GroupMemberImpl;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IEntityGroupStore;
import org.jasig.portal.groups.IEntityGroupStoreFactory;
import org.jasig.portal.groups.IEntitySearcher;
import org.jasig.portal.groups.IEntitySearcherFactory;
import org.jasig.portal.groups.IEntityStore;
import org.jasig.portal.groups.IEntityStoreFactory;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.IIndividualGroupService;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.jasig.portal.groups.ILockableGroupService;
import org.jasig.portal.groups.ReferenceCompositeGroupService;
import org.jasig.portal.services.EntityCachingService;
import org.jasig.portal.services.EntityLockService;
import org.jasig.portal.services.GroupService;

public class ReferenceIndividualGroupService
extends ReferenceCompositeGroupService
implements IIndividualGroupService,
ILockableGroupService {
    private static final Log log = LogFactory.getLog(ReferenceIndividualGroupService.class);
    protected ComponentGroupServiceDescriptor serviceDescriptor;
    protected IEntityGroupStore groupFactory;
    protected IEntitySearcher entitySearcher;

    public ReferenceIndividualGroupService() throws GroupsException {
        this(new ComponentGroupServiceDescriptor());
    }

    public ReferenceIndividualGroupService(ComponentGroupServiceDescriptor svcDescriptor) throws GroupsException {
        this.serviceDescriptor = svcDescriptor;
        this.initialize();
    }

    protected boolean cacheInUse() {
        return this.getServiceDescriptor().isCachingEnabled();
    }

    public void deleteGroup(IEntityGroup group) throws GroupsException {
        this.throwExceptionIfNotInternallyManaged();
        this.synchronizeGroupMembersOnDelete(group);
        this.getGroupStore().delete(group);
        if (this.cacheInUse()) {
            this.cacheRemove((IGroupMember)group);
        }
    }

    private void removeDeletedGroupFromContainingGroups(ILockableEntityGroup group) throws GroupsException {
        IEntityGroup containingGroup = null;
        ILockableEntityGroup lockableGroup2 = null;
        IEntityLock lock = null;
        ArrayList<ILockableEntityGroup> lockableGroups = new ArrayList<ILockableEntityGroup>();
        try {
            String lockOwner = group.getLock().getLockOwner();
            Iterator itr = group.getContainingGroups();
            while (itr.hasNext()) {
                containingGroup = (IEntityGroup)itr.next();
                lockableGroup2 = GroupService.findLockableGroup((String)containingGroup.getKey(), (String)lockOwner);
                if (lockableGroup2 == null) continue;
                lockableGroups.add(lockableGroup2);
            }
            for (ILockableEntityGroup lockableGroup2 : lockableGroups) {
                lockableGroup2.removeMember((IGroupMember)group);
                lockableGroup2.updateMembers();
            }
        }
        catch (GroupsException ge) {
            throw new GroupsException("Could not remove deleted group " + group.getKey() + " from parent", (Throwable)ge);
        }
        finally {
            Iterator itr = lockableGroups.iterator();
            while (itr.hasNext()) {
                lock = ((ILockableEntityGroup)itr.next()).getLock();
                try {
                    if (!lock.isValid()) continue;
                    lock.release();
                }
                catch (LockingException le) {
                    log.error((Object)"ReferenceIndividualGroupService.removeDeletedGroupFromContainingGroups(): Problem unlocking parent group", (Throwable)le);
                }
            }
        }
    }

    public void deleteGroup(ILockableEntityGroup group) throws GroupsException {
        block10: {
            this.throwExceptionIfNotInternallyManaged();
            try {
                if (group.getLock().isValid()) {
                    this.removeDeletedGroupFromContainingGroups(group);
                    this.deleteGroup((IEntityGroup)group);
                    break block10;
                }
                throw new GroupsException("Could not delete group " + group.getKey() + " has invalid lock.");
            }
            catch (LockingException le) {
                throw new GroupsException("Could not delete group " + group.getKey(), (Throwable)le);
            }
            finally {
                try {
                    group.getLock().release();
                }
                catch (LockingException le) {}
            }
        }
    }

    private EntityIdentifier[] filterEntities(EntityIdentifier[] entities, IEntityGroup ancestor) throws GroupsException {
        ArrayList<EntityIdentifier> ar = new ArrayList<EntityIdentifier>(entities.length);
        for (int i = 0; i < entities.length; ++i) {
            IGroupMember gm = this.getGroupMember(entities[i]);
            if (!ancestor.deepContains(gm)) continue;
            ar.add(entities[i]);
        }
        return ar.toArray(new EntityIdentifier[0]);
    }

    public Iterator findContainingGroups(IGroupMember gm) throws GroupsException {
        ArrayList<IEntityGroup> groups = new ArrayList<IEntityGroup>(10);
        IEntityGroup group = null;
        Iterator it = this.getGroupStore().findContainingGroups(gm);
        while (it.hasNext()) {
            group = (IEntityGroup)it.next();
            group.setLocalGroupService((IIndividualGroupService)this);
            groups.add(group);
            if (!this.cacheInUse()) continue;
            try {
                if (this.getGroupFromCache(group.getEntityIdentifier().getKey()) != null) continue;
                this.cacheAdd((IGroupMember)group);
            }
            catch (CachingException ce) {
                throw new GroupsException("Problem finding containing groups", (Throwable)ce);
            }
        }
        return groups.iterator();
    }

    public IEntityGroup findGroup(String key) throws GroupsException {
        return this.findGroup(this.newCompositeEntityIdentifier(key));
    }

    public IEntityGroup findGroup(CompositeEntityIdentifier ent) throws GroupsException {
        return this.cacheInUse() ? this.findGroupWithCache(ent) : this.primFindGroup(ent.getLocalKey());
    }

    protected IEntityGroup findGroupWithCache(String key) throws GroupsException {
        return this.findGroupWithCache(this.newCompositeEntityIdentifier(key));
    }

    protected IEntityGroup findGroupWithCache(CompositeEntityIdentifier ent) throws GroupsException {
        try {
            IEntityGroup group = this.getGroupFromCache(ent.getKey());
            if (group == null && (group = this.primFindGroup(ent.getLocalKey())) != null) {
                this.cacheAdd((IGroupMember)group);
            }
            return group;
        }
        catch (CachingException ce) {
            throw new GroupsException("Problem retrieving group " + ent.getKey(), (Throwable)ce);
        }
    }

    public ILockableEntityGroup findGroupWithLock(String key, String owner) throws GroupsException {
        return this.findGroupWithLock(key, owner, 0);
    }

    public ILockableEntityGroup findGroupWithLock(String key, String owner, int secs) throws GroupsException {
        this.throwExceptionIfNotInternallyManaged();
        Class groupType = EntityTypes.GROUP_ENTITY_TYPE;
        try {
            IEntityLock lock = secs == 0 ? EntityLockService.instance().newWriteLock(groupType, key, owner) : EntityLockService.instance().newWriteLock(groupType, key, owner, secs);
            ILockableEntityGroup group = this.groupFactory.findLockable(key);
            if (group == null) {
                lock.release();
            } else {
                group.setLock(lock);
                group.setLocalGroupService((IIndividualGroupService)this);
            }
            return group;
        }
        catch (LockingException le) {
            throw new GroupsException("Problem getting lock for group " + key, (Throwable)le);
        }
    }

    protected Iterator findLocalMemberGroups(IEntityGroup eg) throws GroupsException {
        ArrayList<IEntityGroup> groups = new ArrayList<IEntityGroup>(10);
        IEntityGroup group = null;
        Iterator it = this.getGroupStore().findMemberGroups(eg);
        while (it.hasNext()) {
            group = (IEntityGroup)it.next();
            if (group == null) {
                log.warn((Object)"A null IEntityGroup object was part of a list groupStore.findMemberGroups");
                continue;
            }
            group.setLocalGroupService((IIndividualGroupService)this);
            groups.add(group);
            if (!this.cacheInUse()) continue;
            try {
                if (this.getGroupFromCache(group.getEntityIdentifier().getKey()) != null) continue;
                this.cacheAdd((IGroupMember)group);
            }
            catch (CachingException ce) {
                throw new GroupsException("Problem finding member groups", (Throwable)ce);
            }
        }
        return groups.iterator();
    }

    public Iterator findMemberEntities(IEntityGroup group) throws GroupsException {
        return this.getGroupStore().findEntitiesForGroup(group);
    }

    public Iterator findMemberGroups(IEntityGroup eg) throws GroupsException {
        HashMap<String, IEntityGroup> groups = new HashMap<String, IEntityGroup>();
        IEntityGroup group = null;
        Iterator itr = this.findLocalMemberGroups(eg);
        while (itr.hasNext()) {
            group = (IEntityGroup)itr.next();
            groups.put(group.getKey(), group);
        }
        String[] memberGroupKeys = this.getGroupStore().findMemberGroupKeys(eg);
        for (int i = 0; i < memberGroupKeys.length; ++i) {
            if (groups.containsKey(memberGroupKeys[i]) || (group = GroupService.findGroup((String)memberGroupKeys[i])) == null) continue;
            groups.put(group.getKey(), group);
        }
        return groups.values().iterator();
    }

    public Iterator findMembers(IEntityGroup eg) throws GroupsException {
        ArrayList members = new ArrayList(10);
        Iterator it = null;
        it = this.findMemberGroups(eg);
        while (it.hasNext()) {
            members.add(it.next());
        }
        it = this.findMemberEntities(eg);
        while (it.hasNext()) {
            members.add(it.next());
        }
        return members.iterator();
    }

    public IEntity getEntity(String key, Class type) throws GroupsException {
        IEntity ent = this.primGetEntity(key, type);
        if (this.cacheInUse()) {
            try {
                IEntity cachedEnt = this.getEntityFromCache(ent.getEntityIdentifier().getKey());
                if (cachedEnt == null) {
                    this.cacheAdd((IGroupMember)ent);
                } else {
                    ent = cachedEnt;
                }
            }
            catch (CachingException ce) {
                throw new GroupsException("Problem retrieving group member " + type + "(" + key + ")", (Throwable)ce);
            }
        }
        return ent;
    }

    public IEntityStore getEntityFactory() {
        return this.entityFactory;
    }

    protected IEntityGroup getGroupFromCache(String key) throws CachingException {
        return (IEntityGroup)EntityCachingService.instance().get(EntityTypes.GROUP_ENTITY_TYPE, key);
    }

    public IGroupMember getGroupMember(String key, Class type) throws GroupsException {
        Object gm = null;
        gm = type == EntityTypes.GROUP_ENTITY_TYPE ? this.findGroup(key) : this.getEntity(key, type);
        return gm;
    }

    public IGroupMember getGroupMember(EntityIdentifier underlyingEntityIdentifier) throws GroupsException {
        return this.getGroupMember(underlyingEntityIdentifier.getKey(), underlyingEntityIdentifier.getType());
    }

    public IEntityGroupStore getGroupStore() throws GroupsException {
        return this.groupFactory;
    }

    protected ComponentGroupServiceDescriptor getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    private void initialize() throws GroupsException {
        String eMsg = null;
        String svcName = this.getServiceDescriptor().getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Service descriptor attributes: " + svcName));
        }
        for (String descriptorKey : this.getServiceDescriptor().keySet()) {
            Object descriptorValue = this.getServiceDescriptor().get((Object)descriptorKey);
            if (descriptorValue == null || !log.isDebugEnabled()) continue;
            log.debug((Object)("  " + descriptorKey + " : " + descriptorValue));
        }
        String groupStoreFactoryName = this.getServiceDescriptor().getGroupStoreFactoryName();
        String entityStoreFactoryName = this.getServiceDescriptor().getEntityStoreFactoryName();
        String entitySearcherFactoryName = this.getServiceDescriptor().getEntitySearcherFactoryName();
        if (groupStoreFactoryName == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("ReferenceGroupService.initialize(): (" + svcName + ") No Group Store factory specified in service descriptor."));
            }
        } else {
            try {
                IEntityGroupStoreFactory groupStoreFactory = (IEntityGroupStoreFactory)Class.forName(groupStoreFactoryName).newInstance();
                this.groupFactory = groupStoreFactory.newGroupStore(this.getServiceDescriptor());
            }
            catch (Exception e) {
                eMsg = "ReferenceIndividualGroupService.initialize(): Failed to instantiate group store (" + svcName + "): " + e;
                log.error((Object)eMsg);
                throw new GroupsException(eMsg, (Throwable)e);
            }
        }
        if (entityStoreFactoryName == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("ReferenceIndividualGroupService.initialize(): No Entity Store Factory specified in service descriptor (" + svcName + ")"));
            }
        } else {
            try {
                IEntityStoreFactory entityStoreFactory = (IEntityStoreFactory)Class.forName(entityStoreFactoryName).newInstance();
                this.entityFactory = entityStoreFactory.newEntityStore();
            }
            catch (Exception e) {
                eMsg = "ReferenceIndividualGroupService.initialize(): Failed to instantiate entity store " + e;
                log.error((Object)eMsg);
                throw new GroupsException(eMsg, (Throwable)e);
            }
        }
        if (entitySearcherFactoryName == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"ReferenceIndividualGroupService.initialize(): No Entity Searcher Factory specified in service descriptor.");
            }
        } else {
            try {
                IEntitySearcherFactory entitySearcherFactory = (IEntitySearcherFactory)Class.forName(entitySearcherFactoryName).newInstance();
                this.entitySearcher = entitySearcherFactory.newEntitySearcher();
            }
            catch (Exception e) {
                eMsg = "ReferenceIndividualGroupService.initialize(): Failed to instantiate entity searcher " + e;
                log.error((Object)eMsg);
                throw new GroupsException(eMsg, (Throwable)e);
            }
        }
    }

    public boolean isEditable(IEntityGroup group) throws GroupsException {
        return this.isInternallyManaged();
    }

    protected boolean isInternallyManaged() {
        return this.getServiceDescriptor().isInternallyManaged();
    }

    public boolean isLeafService() {
        return true;
    }

    public boolean isEditable() {
        return this.isInternallyManaged();
    }

    public IEntityGroup newGroup(Class type) throws GroupsException {
        this.throwExceptionIfNotInternallyManaged();
        IEntityGroup group = this.groupFactory.newInstance(type);
        group.setLocalGroupService((IIndividualGroupService)this);
        if (this.cacheInUse()) {
            this.cacheAdd((IGroupMember)group);
        }
        return group;
    }

    protected IEntityGroup primFindGroup(String localKey) throws GroupsException {
        IEntityGroup group = this.groupFactory.find(localKey);
        if (group != null) {
            group.setLocalGroupService((IIndividualGroupService)this);
        }
        return group;
    }

    private EntityIdentifier[] removeDuplicates(EntityIdentifier[] entities) {
        ArrayList<EntityIdentifier> ar = new ArrayList<EntityIdentifier>(entities.length);
        for (int i = 0; i < entities.length; ++i) {
            if (ar.contains(entities[i])) continue;
            ar.add(entities[i]);
        }
        return ar.toArray(new EntityIdentifier[0]);
    }

    public EntityIdentifier[] searchForEntities(String query, int method, Class type) throws GroupsException {
        return this.removeDuplicates(this.entitySearcher.searchForEntities(query, method, type));
    }

    public EntityIdentifier[] searchForEntities(String query, int method, Class type, IEntityGroup ancestor) throws GroupsException {
        return this.filterEntities(this.searchForEntities(query, method, type), ancestor);
    }

    public EntityIdentifier[] searchForGroups(String query, int method, Class leaftype) throws GroupsException {
        return this.removeDuplicates(this.groupFactory.searchForGroups(query, method, leaftype));
    }

    public EntityIdentifier[] searchForGroups(String query, int method, Class leaftype, IEntityGroup ancestor) throws GroupsException {
        return this.filterEntities(this.searchForGroups(query, method, leaftype), ancestor);
    }

    protected void throwExceptionIfNotInternallyManaged() throws GroupsException {
        if (!this.isInternallyManaged()) {
            throw new GroupsException("Group Service " + this.getServiceName() + " is not updatable.");
        }
    }

    public void updateGroup(IEntityGroup group) throws GroupsException {
        this.throwExceptionIfNotInternallyManaged();
        this.getGroupStore().update(group);
        if (this.cacheInUse()) {
            this.cacheUpdate((IGroupMember)group);
        }
        this.synchronizeGroupMembersOnUpdate(group);
    }

    public void updateGroup(ILockableEntityGroup group) throws GroupsException {
        this.updateGroup(group, false);
    }

    public void updateGroup(ILockableEntityGroup group, boolean renewLock) throws GroupsException {
        this.throwExceptionIfNotInternallyManaged();
        try {
            if (!group.getLock().isValid()) {
                throw new GroupsException("Could not update group " + group.getKey() + " has invalid lock.");
            }
            this.getGroupStore().update((IEntityGroup)group);
            if (this.cacheInUse()) {
                this.cacheRemove((IGroupMember)group);
            }
            this.synchronizeGroupMembersOnUpdate((IEntityGroup)group);
            if (renewLock) {
                group.getLock().renew();
            } else {
                group.getLock().release();
            }
        }
        catch (LockingException le) {
            throw new GroupsException("Problem updating group " + group.getKey(), (Throwable)le);
        }
    }

    public void updateGroupMembers(IEntityGroup group) throws GroupsException {
        this.throwExceptionIfNotInternallyManaged();
        this.getGroupStore().updateMembers(group);
        if (this.cacheInUse()) {
            this.cacheUpdate((IGroupMember)group);
        }
        this.synchronizeGroupMembersOnUpdate(group);
    }

    public void updateGroupMembers(ILockableEntityGroup group) throws GroupsException {
        this.updateGroupMembers(group, false);
    }

    public void updateGroupMembers(ILockableEntityGroup group, boolean renewLock) throws GroupsException {
        this.throwExceptionIfNotInternallyManaged();
        try {
            if (!group.getLock().isValid()) {
                throw new GroupsException("Could not update group " + group.getKey() + " has invalid lock.");
            }
            this.getGroupStore().updateMembers((IEntityGroup)group);
            if (this.cacheInUse()) {
                this.cacheRemove((IGroupMember)group);
            }
            this.synchronizeGroupMembersOnUpdate((IEntityGroup)group);
            if (renewLock) {
                group.getLock().renew();
            } else {
                group.getLock().release();
            }
        }
        catch (LockingException le) {
            throw new GroupsException("Problem updating group " + group.getKey(), (Throwable)le);
        }
    }

    protected IEntity primGetEntity(String key, Class type) throws GroupsException {
        return this.entityFactory.newInstance(key, type);
    }

    protected void synchronizeGroupMembersOnDelete(IEntityGroup group) throws GroupsException {
        GroupMemberImpl gmi = null;
        Iterator it = group.getMembers();
        while (it.hasNext()) {
            gmi = (GroupMemberImpl)it.next();
            gmi.removeGroup(group);
            if (!this.cacheInUse()) continue;
            this.cacheUpdate((IGroupMember)gmi);
        }
    }

    protected void synchronizeGroupMembersOnUpdate(IEntityGroup group) throws GroupsException {
        EntityGroupImpl egi = (EntityGroupImpl)group;
        GroupMemberImpl gmi2 = null;
        for (GroupMemberImpl gmi2 : egi.getAddedMembers().values()) {
            gmi2.addGroup((IEntityGroup)egi);
            if (!this.cacheInUse()) continue;
            this.cacheUpdate((IGroupMember)gmi2);
        }
        for (GroupMemberImpl gmi2 : egi.getRemovedMembers().values()) {
            gmi2.removeGroup((IEntityGroup)egi);
            if (!this.cacheInUse()) continue;
            this.cacheUpdate((IGroupMember)gmi2);
        }
    }

    public boolean contains(IEntityGroup group, IGroupMember member) throws GroupsException {
        return this.isForeign(member) && !this.isEditable() ? false : this.getGroupStore().contains(group, member);
    }

    protected boolean isForeign(IGroupMember member) {
        if (member.isEntity()) {
            return false;
        }
        Name memberSvcName = ((IEntityGroup)member).getServiceName();
        return !this.getServiceName().equals(memberSvcName);
    }
}

