/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups.filesystem;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.groups.EntityGroupImpl;
import org.jasig.portal.groups.EntityImpl;
import org.jasig.portal.groups.GroupServiceConfiguration;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IEntityGroupStore;
import org.jasig.portal.groups.IEntitySearcher;
import org.jasig.portal.groups.IEntityStore;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.jasig.portal.groups.filesystem.FileSystemGroupStore;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.GroupService;

public class FileSystemGroupStore
implements IEntityGroupStore,
IEntityStore,
IEntitySearcher {
    private static final Log log = LogFactory.getLog(FileSystemGroupStore.class);
    protected static char FORWARD_SLASH = (char)47;
    protected static char BACK_SLASH = (char)92;
    protected static String COMMENT = "#";
    protected static String GROUP_PREFIX = "group:";
    protected static char PERIOD = (char)46;
    protected static char SUBSTITUTE_PERIOD = (char)36;
    protected boolean useSubstitutePeriod = false;
    private static String DEBUG_CLASS_NAME = "FileSystemGroupStore";
    private String groupsRootPath;
    protected char goodSeparator;
    protected char badSeparator;
    private Map cache;
    private FilenameFilter fileFilter = new FileFilter(this, null);
    private Class defaultEntityType;

    public FileSystemGroupStore() {
        this(null);
    }

    public FileSystemGroupStore(GroupServiceConfiguration cfg) {
        this.initialize(cfg);
    }

    protected GroupHolder cacheGet(String key) {
        return (GroupHolder)this.getCache().get(key);
    }

    protected void cachePut(String key, Object val) {
        this.getCache().put(key, val);
    }

    protected String conformSeparatorChars(String s) {
        return s.replace(this.getBadSeparator(), this.getGoodSeparator());
    }

    public void delete(IEntityGroup group) throws GroupsException {
        throw new UnsupportedOperationException("FileSystemGroupStore.delete() not supported");
    }

    private IEntityGroup find(File file) throws GroupsException {
        return this.find(this.getKeyFromFile(file));
    }

    public IEntityGroup find(String key) throws GroupsException {
        if (log.isDebugEnabled()) {
            log.debug((Object)(DEBUG_CLASS_NAME + ".find(): group key: " + key));
        }
        String path = this.getFilePathFromKey(key);
        File f = new File(path);
        GroupHolder groupHolder = this.cacheGet(key);
        if (groupHolder == null || groupHolder.getLastModified() != f.lastModified()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(DEBUG_CLASS_NAME + ".find(): retrieving group from file system for " + path));
            }
            if (!f.exists()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(DEBUG_CLASS_NAME + ".find(): file does not exist: " + path));
                }
                return null;
            }
            IEntityGroup group = this.newInstance(f);
            groupHolder = new GroupHolder(this, group, f.lastModified());
            this.cachePut(key, (Object)groupHolder);
        }
        return groupHolder.getGroup();
    }

    protected Iterator findContainingGroups(IEntity ent) throws GroupsException {
        if (log.isDebugEnabled()) {
            log.debug((Object)(DEBUG_CLASS_NAME + ".findContainingGroups(): for " + ent));
        }
        ArrayList<IEntityGroup> groups = new ArrayList<IEntityGroup>();
        File root = this.getFileRoot(ent.getType());
        if (root != null) {
            File[] files = this.getAllFilesBelow(root);
            try {
                for (int i = 0; i < files.length; ++i) {
                    Collection ids = this.getEntityIdsFromFile(files[i]);
                    if (!ids.contains(ent.getKey())) continue;
                    groups.add(this.find(files[i]));
                }
            }
            catch (IOException ex) {
                throw new GroupsException("Problem reading group files", (Throwable)ex);
            }
        }
        return groups.iterator();
    }

    protected Iterator findContainingGroups(IEntityGroup group) throws GroupsException {
        if (log.isDebugEnabled()) {
            log.debug((Object)(DEBUG_CLASS_NAME + ".findContainingGroups(): for " + group));
        }
        ArrayList<IEntityGroup> groups = new ArrayList<IEntityGroup>();
        String typeName = group.getLeafType().getName();
        File parent = this.getFile(group).getParentFile();
        if (!parent.getName().equals(typeName)) {
            groups.add(this.find(parent));
        }
        File root = this.getFileRoot(group.getLeafType());
        File[] files = this.getAllFilesBelow(root);
        try {
            for (int i = 0; i < files.length; ++i) {
                Collection ids = this.getGroupIdsFromFile(files[i]);
                if (!ids.contains(group.getLocalKey())) continue;
                groups.add(this.find(files[i]));
            }
        }
        catch (IOException ex) {
            throw new GroupsException("Problem reading group files", (Throwable)ex);
        }
        return groups.iterator();
    }

    public Iterator findContainingGroups(IGroupMember gm) throws GroupsException {
        if (gm.isGroup()) {
            IEntityGroup group = (IEntityGroup)gm;
            return this.findContainingGroups(group);
        }
        IEntity ent = (IEntity)gm;
        return this.findContainingGroups(ent);
    }

    public Iterator findEntitiesForGroup(IEntityGroup group) throws GroupsException {
        if (log.isDebugEnabled()) {
            log.debug((Object)(DEBUG_CLASS_NAME + ".findEntitiesForGroup(): retrieving entities for group " + group));
        }
        Collection entities = null;
        File f = this.getFile(group);
        entities = f.isDirectory() ? Collections.EMPTY_LIST : this.getEntitiesFromFile(f);
        return entities.iterator();
    }

    public ILockableEntityGroup findLockable(String key) throws GroupsException {
        throw new UnsupportedOperationException(DEBUG_CLASS_NAME + ".findLockable() not supported");
    }

    public String[] findMemberGroupKeys(IEntityGroup group) throws GroupsException {
        String[] keys;
        File f = this.getFile(group);
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            keys = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                keys[i] = this.getKeyFromFile(files[i]);
            }
        } else {
            try {
                Collection groupKeys = this.getGroupIdsFromFile(f);
                keys = groupKeys.toArray(new String[groupKeys.size()]);
            }
            catch (IOException ex) {
                throw new GroupsException(DEBUG_CLASS_NAME + ".findMemberGroupKeys(): " + "problem finding group members", (Throwable)ex);
            }
        }
        return keys;
    }

    public Iterator findMemberGroups(IEntityGroup group) throws GroupsException {
        String[] keys = this.findMemberGroupKeys(group);
        ArrayList<IEntityGroup> groups = new ArrayList<IEntityGroup>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            groups.add(this.find(keys[i]));
        }
        return groups.iterator();
    }

    public Set getAllDirectoriesBelow(File dir) {
        HashSet allDirectories = new HashSet();
        if (dir.isDirectory()) {
            this.primGetAllDirectoriesBelow(dir, allDirectories);
        }
        return allDirectories;
    }

    public File[] getAllFilesBelow(File dir) {
        HashSet allFiles = new HashSet();
        if (dir.isDirectory()) {
            this.primGetAllFilesBelow(dir, allFiles);
        }
        return allFiles.toArray(new File[allFiles.size()]);
    }

    protected char getBadSeparator() {
        return this.badSeparator;
    }

    protected Map getCache() {
        return this.cache;
    }

    protected Class getDefaultEntityType() {
        return this.defaultEntityType;
    }

    protected Collection getEntitiesFromFile(File idFile) throws GroupsException {
        if (log.isDebugEnabled()) {
            log.debug((Object)(DEBUG_CLASS_NAME + "getEntitiesFromFile(): for " + idFile.getPath()));
        }
        Collection ids = null;
        Class type = this.getEntityType(idFile);
        if (EntityTypes.getEntityTypeID((Class)type) == null) {
            throw new GroupsException("Invalid entity type: " + type);
        }
        try {
            ids = this.getEntityIdsFromFile(idFile);
        }
        catch (Exception ex) {
            throw new GroupsException("Problem retrieving keys from file", (Throwable)ex);
        }
        ArrayList<IEntity> entities = new ArrayList<IEntity>(ids.size());
        for (String key : ids) {
            entities.add(GroupService.getEntity((String)key, (Class)type));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(DEBUG_CLASS_NAME + "getEntitiesFromFile(): Retrieved " + entities.size() + " entities"));
        }
        return entities;
    }

    protected Collection getEntityIdsFromFile(File idFile) throws IOException, FileNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)(DEBUG_CLASS_NAME + "getEntityIdsFromFile(): Reading " + idFile.getPath()));
        }
        Collection ids = this.getIdsFromFile(idFile, false);
        if (log.isDebugEnabled()) {
            log.debug((Object)(DEBUG_CLASS_NAME + "getEntityIdsFromFile(): Retrieved " + ids.size() + " IDs"));
        }
        return ids;
    }

    protected Class getEntityType(File f) {
        String path = f.getPath();
        String afterRootPath = null;
        Class<?> type = null;
        if (path.startsWith(this.getGroupsRootPath())) {
            afterRootPath = path.substring(this.getGroupsRootPath().length());
            int end = afterRootPath.indexOf(File.separatorChar);
            String typeName = afterRootPath.substring(0, end);
            try {
                type = Class.forName(typeName);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        return type;
    }

    protected File getFile(IEntityGroup group) {
        String key = this.getFilePathFromKey(group.getLocalKey());
        return new File(key);
    }

    protected String getFilePathFromKey(String key) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(DEBUG_CLASS_NAME + ".getFilePathFromKey(): for key: " + key));
        }
        String groupKey = this.useSubstitutePeriod ? key.replace(SUBSTITUTE_PERIOD, PERIOD) : key;
        String fullKey = this.getGroupsRootPath() + groupKey;
        if (log.isDebugEnabled()) {
            log.debug((Object)(DEBUG_CLASS_NAME + ".getFilePathFromKey(): full key: " + fullKey));
        }
        return this.conformSeparatorChars(fullKey);
    }

    protected File getFileRoot(Class type) {
        String path = this.getGroupsRootPath() + type.getName();
        File f = new File(path);
        return f.exists() ? f : null;
    }

    protected char getGoodSeparator() {
        return this.goodSeparator;
    }

    protected Collection getGroupIdsFromFile(File idFile) throws IOException, FileNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)(DEBUG_CLASS_NAME + "getGroupIdsFromFile(): Reading " + idFile.getPath()));
        }
        Collection ids = this.getIdsFromFile(idFile, true);
        if (log.isDebugEnabled()) {
            log.debug((Object)(DEBUG_CLASS_NAME + "getGroupIdsFromFile(): Retrieved " + ids.size() + " IDs"));
        }
        return ids;
    }

    public String getGroupsRootPath() {
        return this.groupsRootPath;
    }

    protected Collection getIdsFromFile(File idFile, boolean groupIds) throws IOException, FileNotFoundException {
        HashSet<String> ids = new HashSet<String>();
        BufferedReader br = new BufferedReader(new FileReader(idFile));
        String line = br.readLine();
        while (line != null) {
            StringTokenizer st;
            String tok;
            if (!(line = line.trim()).startsWith(COMMENT) && line.length() > 0 && (tok = (st = new StringTokenizer(line)).nextToken()) != null) {
                if (tok.startsWith(GROUP_PREFIX)) {
                    if (groupIds) {
                        ids.add(tok.substring(GROUP_PREFIX.length()));
                    }
                } else if (!groupIds) {
                    ids.add(tok);
                }
            }
            line = br.readLine();
        }
        br.close();
        return ids;
    }

    protected String getKeyFromFile(File f) {
        String key = null;
        if (f.getPath().startsWith(this.getGroupsRootPath())) {
            key = f.getPath().substring(this.getGroupsRootPath().length());
            if (this.useSubstitutePeriod) {
                key = key.replace(PERIOD, SUBSTITUTE_PERIOD);
            }
        }
        return key;
    }

    protected void initialize(GroupServiceConfiguration cfg) {
        String sep;
        this.cache = Collections.synchronizedMap(new HashMap());
        this.goodSeparator = File.separatorChar;
        this.badSeparator = this.goodSeparator == FORWARD_SLASH ? BACK_SLASH : FORWARD_SLASH;
        this.defaultEntityType = IPerson.class;
        GroupServiceConfiguration config = cfg;
        if (config == null) {
            try {
                config = GroupServiceConfiguration.getConfiguration();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        if ((sep = config.getNodeSeparator()) != null) {
            String period = String.valueOf(PERIOD);
            this.useSubstitutePeriod = sep.equals(period);
        }
    }

    private IEntityGroup newInstance(File f) throws GroupsException {
        String key = this.getKeyFromFile(f);
        String name = f.getName();
        Class cl = this.getEntityType(f);
        return this.newInstance(key, cl, name);
    }

    public IEntityGroup newInstance(Class entityType) throws GroupsException {
        throw new UnsupportedOperationException(DEBUG_CLASS_NAME + ".newInstance(Class cl) not supported");
    }

    public IEntity newInstance(String key) throws GroupsException {
        return this.newInstance(key, this.getDefaultEntityType());
    }

    public IEntity newInstance(String key, Class type) throws GroupsException {
        if (EntityTypes.getEntityTypeID((Class)type) == null) {
            throw new GroupsException("Invalid group type: " + type);
        }
        return new EntityImpl(key, type);
    }

    private IEntityGroup newInstance(String newKey, Class newType, String newName) throws GroupsException {
        EntityGroupImpl egi = new EntityGroupImpl(newKey, newType);
        egi.primSetName(newName);
        return egi;
    }

    private void primGetAllDirectoriesBelow(File dir, Set allDirectories) {
        File[] files = dir.listFiles(this.fileFilter);
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            this.primGetAllDirectoriesBelow(files[i], allDirectories);
            allDirectories.add(files[i]);
        }
    }

    private void primGetAllFilesBelow(File dir, Set allFiles) {
        File[] files = dir.listFiles(this.fileFilter);
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.primGetAllFilesBelow(files[i], allFiles);
                continue;
            }
            allFiles.add(files[i]);
        }
    }

    public EntityIdentifier[] searchForEntities(String query, int method, Class type) throws GroupsException {
        return new EntityIdentifier[0];
    }

    public EntityIdentifier[] searchForGroups(String query, int searchMethod, Class leafType) throws GroupsException {
        ArrayList<EntityIdentifier> ids = new ArrayList<EntityIdentifier>();
        File baseDir = this.getFileRoot(leafType);
        if (log.isDebugEnabled()) {
            log.debug((Object)(DEBUG_CLASS_NAME + "searchForGroups(): " + query + " method: " + searchMethod + " type: " + leafType));
        }
        if (baseDir != null) {
            String nameFilter = null;
            switch (searchMethod) {
                case 1: {
                    nameFilter = query;
                    break;
                }
                case 2: {
                    nameFilter = query + ".*";
                    break;
                }
                case 3: {
                    nameFilter = ".*" + query;
                    break;
                }
                case 4: {
                    nameFilter = ".*" + query + ".*";
                    break;
                }
                default: {
                    throw new GroupsException(DEBUG_CLASS_NAME + ".searchForGroups(): Unknown search method: " + searchMethod);
                }
            }
            Pattern namePattern = Pattern.compile(nameFilter);
            1 filter = new /* Unavailable Anonymous Inner Class!! */;
            Set allDirs = this.getAllDirectoriesBelow(baseDir);
            allDirs.add(baseDir);
            Iterator itr = allDirs.iterator();
            while (itr.hasNext()) {
                File[] files = ((File)itr.next()).listFiles((FilenameFilter)filter);
                for (int filesIdx = 0; filesIdx < files.length; ++filesIdx) {
                    String key = this.getKeyFromFile(files[filesIdx]);
                    EntityIdentifier ei = new EntityIdentifier(key, EntityTypes.GROUP_ENTITY_TYPE);
                    ids.add(ei);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(DEBUG_CLASS_NAME + ".searchForGroups(): found " + ids.size() + " files."));
        }
        return ids.toArray(new EntityIdentifier[ids.size()]);
    }

    protected void setCache(Map newCache) {
        this.cache = newCache;
    }

    protected void setGroupsRootPath(String newGroupsRootPath) {
        this.groupsRootPath = this.conformSeparatorChars(newGroupsRootPath) + this.getGoodSeparator();
    }

    public void update(IEntityGroup group) throws GroupsException {
        throw new UnsupportedOperationException(DEBUG_CLASS_NAME + ".update() not supported");
    }

    public void updateMembers(IEntityGroup group) throws GroupsException {
        throw new UnsupportedOperationException(DEBUG_CLASS_NAME + ".updateMembers() not supported");
    }

    public boolean contains(IEntityGroup group, IGroupMember member) throws GroupsException {
        File f = this.getFile(group);
        return f.isDirectory() ? this.directoryContains(f, member) : this.fileContains(f, member);
    }

    private boolean fileContains(File file, IGroupMember member) throws GroupsException {
        Collection ids = null;
        try {
            ids = member.isEntity() ? this.getEntityIdsFromFile(file) : this.getGroupIdsFromFile(file);
        }
        catch (Exception ex) {
            throw new GroupsException("Error retrieving ids from file", (Throwable)ex);
        }
        return ids.contains(member.getKey());
    }

    private boolean directoryContains(File directory, IGroupMember member) {
        boolean found = false;
        if (member.isGroup()) {
            File memberFile = this.getFile((IEntityGroup)member);
            File[] files = directory.listFiles();
            int i = 0;
            while (i < files.length & !found) {
                found = files[i].equals(memberFile);
                ++i;
            }
        }
        return found;
    }

    public boolean containsGroupNamed(IEntityGroup group, String name) throws GroupsException {
        boolean found = false;
        Iterator itr = this.findMemberGroups(group);
        while (itr.hasNext() && !found) {
            String otherName = ((IEntityGroup)itr.next()).getName();
            found = otherName != null && otherName.equals(name);
        }
        return found;
    }
}

