/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups.local.searchers;

import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IBasicEntity;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.local.ITypedEntitySearcher;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PortletDefinitionSearcher
implements ITypedEntitySearcher {
    private static final Log log = LogFactory.getLog(PortletDefinitionSearcher.class);
    private IPortletDefinitionRegistry portletDefinitionRegistry;

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    public EntityIdentifier[] searchForEntities(String query, int method) throws GroupsException {
        boolean allowPartial = true;
        switch (method) {
            case 1: {
                allowPartial = false;
                break;
            }
            case 2: {
                query = query + "%";
                break;
            }
            case 3: {
                query = "%" + query;
                break;
            }
            case 4: {
                query = "%" + query + "%";
                break;
            }
            default: {
                throw new GroupsException("Unknown search type");
            }
        }
        List definitions = this.portletDefinitionRegistry.searchForPortlets(query, allowPartial);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + definitions.size() + " matching definitions for query " + query));
        }
        EntityIdentifier[] identifiers = new EntityIdentifier[definitions.size()];
        ListIterator defIter = definitions.listIterator();
        while (defIter.hasNext()) {
            IPortletDefinition definition = (IPortletDefinition)defIter.next();
            identifiers[defIter.previousIndex()] = new EntityIdentifier(definition.getPortletDefinitionId().getStringId(), this.getType());
        }
        return identifiers;
    }

    public Class<? extends IBasicEntity> getType() {
        return IPortletDefinition.class;
    }
}

