/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups.pags;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.groups.EntityImpl;
import org.jasig.portal.groups.EntityTestingGroupImpl;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IEntityGroupStore;
import org.jasig.portal.groups.IEntitySearcher;
import org.jasig.portal.groups.IEntityStore;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.jasig.portal.groups.pags.IPersonAttributesConfiguration;
import org.jasig.portal.groups.pags.IPersonTester;
import org.jasig.portal.groups.pags.PersonAttributesGroupStore;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.PersonFactory;
import org.jasig.portal.security.provider.RestrictedPerson;
import org.jasig.portal.spring.locator.PersonAttributeDaoLocator;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
public class PersonAttributesGroupStore
implements IEntityGroupStore,
IEntityStore,
IEntitySearcher {
    private static final Log log = LogFactory.getLog(PersonAttributesGroupStore.class);
    private static final Class<IPerson> IPERSON_CLASS = IPerson.class;
    private static final EntityIdentifier[] EMPTY_SEARCH_RESULTS = new EntityIdentifier[0];
    private Properties props;
    private Map groupDefinitions;
    private Map<String, IEntityGroup> groups = new HashMap();
    private Map<String, List> containingGroups = new HashMap();

    public PersonAttributesGroupStore() {
        try {
            this.props = new Properties();
            this.props.load(PersonAttributesGroupStore.class.getResourceAsStream("/properties/groups/pags.properties"));
            IPersonAttributesConfiguration config = this.getConfig(this.props.getProperty("org.jasig.portal.groups.pags.PersonAttributesGroupStore.configurationClass"));
            this.groupDefinitions = config.getConfig();
            this.initGroups();
        }
        catch (Exception e) {
            throw new RuntimeException("Problem initializing groups", e);
        }
    }

    private IPersonAttributesConfiguration getConfig(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> configClass = Class.forName(className);
        Object o = configClass.newInstance();
        return (IPersonAttributesConfiguration)o;
    }

    private void initGroups() throws GroupsException {
        Iterator i = null;
        Collection groupDefs = this.groupDefinitions.values();
        for (GroupDefinition groupDef : groupDefs) {
            EntityTestingGroupImpl group = new EntityTestingGroupImpl(groupDef.getKey(), IPERSON_CLASS);
            group.setName(groupDef.getName());
            group.setDescription(groupDef.getDescription());
            this.cachePut((IEntityGroup)group);
        }
        this.cacheContainingGroupsForGroups();
    }

    private IPersonTester initializeTester(String tester, String attribute, String value) {
        try {
            Class<?> testerClass = Class.forName(tester);
            Constructor<?> c = testerClass.getConstructor(String.class, String.class);
            Object o = c.newInstance(attribute, value);
            return (IPersonTester)o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private IEntityGroup cacheGet(String key) {
        return (IEntityGroup)this.groups.get(key);
    }

    private void cachePut(IEntityGroup group) {
        this.groups.put(group.getLocalKey(), group);
    }

    public boolean contains(IEntityGroup group, IGroupMember member) throws GroupsException {
        GroupDefinition groupDef = (GroupDefinition)this.groupDefinitions.get(group.getLocalKey());
        if (member.isGroup()) {
            String key = ((IEntityGroup)member).getLocalKey();
            return groupDef.hasMember(key);
        }
        if (member.getEntityType() != IPERSON_CLASS) {
            return false;
        }
        RestrictedPerson person = null;
        try {
            IPersonAttributeDao pa = PersonAttributeDaoLocator.getPersonAttributeDao();
            IPersonAttributes personAttributes = pa.getPerson(member.getKey());
            RestrictedPerson rp = PersonFactory.createRestrictedPerson();
            if (personAttributes != null) {
                rp.setAttributes(personAttributes.getAttributes());
            }
            person = rp;
        }
        catch (Exception ex) {
            log.error((Object)("Exception acquiring attributes for member " + member + " while checking if group " + group + " contains this member."), (Throwable)ex);
            return false;
        }
        return this.testRecursively(groupDef, (IPerson)person, member);
    }

    public void delete(IEntityGroup group) throws GroupsException {
        throw new UnsupportedOperationException("PersonAttributesGroupStore: Method delete() not supported.");
    }

    public IEntityGroup find(String key) throws GroupsException {
        return (IEntityGroup)this.groups.get(key);
    }

    private void cacheContainingGroupsForGroups() throws GroupsException {
        Iterator i = null;
        ArrayList<IEntityGroup> parentGroupsList = new ArrayList<IEntityGroup>();
        for (GroupDefinition groupDef : this.groupDefinitions.values()) {
            if (GroupDefinition.access$000((GroupDefinition)groupDef).isEmpty()) continue;
            parentGroupsList.add(this.cacheGet(groupDef.getKey()));
        }
        IEntityGroup[] parentGroupsArray = parentGroupsList.toArray(new IEntityGroup[parentGroupsList.size()]);
        for (IEntityGroup childGroup : this.groups.values()) {
            parentGroupsList = new ArrayList(5);
            for (int idx = 0; idx < parentGroupsArray.length; ++idx) {
                if (!this.contains(parentGroupsArray[idx], (IGroupMember)childGroup)) continue;
                parentGroupsList.add(parentGroupsArray[idx]);
            }
            this.containingGroups.put(childGroup.getLocalKey(), parentGroupsList);
        }
    }

    private boolean testRecursively(GroupDefinition groupDef, IPerson person, IGroupMember member) throws GroupsException {
        if (!groupDef.contains(person)) {
            return false;
        }
        IEntityGroup group = this.cacheGet(groupDef.getKey());
        IEntityGroup parentGroup = null;
        Set allParents = this.primGetAllContainingGroups(group, new HashSet());
        boolean testPassed = true;
        Iterator i = allParents.iterator();
        while (i.hasNext() && testPassed) {
            parentGroup = (IEntityGroup)i.next();
            GroupDefinition parentGroupDef = (GroupDefinition)this.groupDefinitions.get(parentGroup.getLocalKey());
            testPassed = parentGroupDef.test(person);
        }
        if (!testPassed && log.isWarnEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("PAGS group=").append(group.getKey());
            sb.append(" contained person=").append(member.getKey());
            sb.append(", but the person failed to be contained in ");
            sb.append("ancesters of this group");
            sb.append(parentGroup != null ? " (parentGroup=" + parentGroup.getKey() + ")" : "");
            sb.append(". This may indicate a ");
            sb.append("misconfigured PAGS group ");
            sb.append("store. Please check PAGSGroupStoreConfig.xml.");
            log.warn((Object)sb.toString());
        }
        return testPassed;
    }

    private Set<IEntityGroup> primGetAllContainingGroups(IEntityGroup group, Set<IEntityGroup> s) throws GroupsException {
        Iterator i = this.findContainingGroups((IGroupMember)group);
        while (i.hasNext()) {
            IEntityGroup parentGroup = (IEntityGroup)i.next();
            s.add(parentGroup);
            this.primGetAllContainingGroups(parentGroup, s);
        }
        return s;
    }

    public Iterator findContainingGroups(IGroupMember member) throws GroupsException {
        return member.isEntity() ? this.findContainingGroupsForEntity((IEntity)member) : this.findContainingGroupsForGroup((IEntityGroup)member);
    }

    private Iterator findContainingGroupsForGroup(IEntityGroup group) {
        List parents = (List)this.containingGroups.get(group.getLocalKey());
        return parents != null ? parents.iterator() : Collections.EMPTY_LIST.iterator();
    }

    private Iterator<IEntityGroup> findContainingGroupsForEntity(IEntity member) throws GroupsException {
        ArrayList<IEntityGroup> results = new ArrayList<IEntityGroup>();
        for (IEntityGroup group : this.groups.values()) {
            if (!this.contains(group, (IGroupMember)member)) continue;
            results.add(group);
        }
        return results.iterator();
    }

    public Iterator findEntitiesForGroup(IEntityGroup group) throws GroupsException {
        return Collections.EMPTY_LIST.iterator();
    }

    public ILockableEntityGroup findLockable(String key) throws GroupsException {
        throw new UnsupportedOperationException("PersonAttributesGroupStore: Method findLockable() not supported");
    }

    public String[] findMemberGroupKeys(IEntityGroup group) throws GroupsException {
        ArrayList keys = new ArrayList();
        GroupDefinition groupDef = (GroupDefinition)this.groupDefinitions.get(group.getLocalKey());
        if (groupDef != null) {
            Iterator i = GroupDefinition.access$000((GroupDefinition)groupDef).iterator();
            while (i.hasNext()) {
                keys.add(i.next());
            }
        }
        return keys.toArray(new String[0]);
    }

    public Iterator<IEntityGroup> findMemberGroups(IEntityGroup group) throws GroupsException {
        String[] keys = this.findMemberGroupKeys(group);
        ArrayList<IEntityGroup> results = new ArrayList<IEntityGroup>();
        for (int i = 0; i < keys.length; ++i) {
            IEntityGroup g = this.cacheGet(keys[i]);
            if (g == null) {
                log.warn((Object)("Couldn't find a group with key '" + keys[i] + "' referenced by '" + group.getKey() + "'. Please check PAGSGroupStoreConfig.xml"));
            }
            results.add(g);
        }
        return results.iterator();
    }

    public IEntityGroup newInstance(Class entityType) throws GroupsException {
        throw new UnsupportedOperationException("PersonAttributesGroupStore: Method newInstance() not supported");
    }

    public EntityIdentifier[] searchForGroups(String query, int method, Class leaftype) throws GroupsException {
        if (leaftype != IPERSON_CLASS) {
            return EMPTY_SEARCH_RESULTS;
        }
        ArrayList<EntityIdentifier> results = new ArrayList<EntityIdentifier>();
        switch (method) {
            case 1: {
                for (IEntityGroup g : this.groups.values()) {
                    if (!g.getName().equalsIgnoreCase(query)) continue;
                    results.add(g.getEntityIdentifier());
                }
                break;
            }
            case 2: {
                for (IEntityGroup g : this.groups.values()) {
                    if (!g.getName().toUpperCase().startsWith(query.toUpperCase())) continue;
                    results.add(g.getEntityIdentifier());
                }
                break;
            }
            case 3: {
                for (IEntityGroup g : this.groups.values()) {
                    if (!g.getName().toUpperCase().endsWith(query.toUpperCase())) continue;
                    results.add(g.getEntityIdentifier());
                }
                break;
            }
            case 4: {
                for (IEntityGroup g : this.groups.values()) {
                    if (g.getName().toUpperCase().indexOf(query.toUpperCase()) == -1) continue;
                    results.add(g.getEntityIdentifier());
                }
                break;
            }
        }
        return results.toArray(new EntityIdentifier[0]);
    }

    public void update(IEntityGroup group) throws GroupsException {
        throw new UnsupportedOperationException("PersonAttributesGroupStore: Method update() not supported.");
    }

    public void updateMembers(IEntityGroup group) throws GroupsException {
        throw new UnsupportedOperationException("PersonAttributesGroupStore: Method updateMembers() not supported.");
    }

    public IEntity newInstance(String key, Class type) throws GroupsException {
        if (EntityTypes.getEntityTypeID((Class)type) == null) {
            throw new GroupsException("Invalid entity type: " + type.getName());
        }
        return new EntityImpl(key, type);
    }

    public IEntity newInstance(String key) throws GroupsException {
        return new EntityImpl(key, null);
    }

    public EntityIdentifier[] searchForEntities(String query, int method, Class type) throws GroupsException {
        return EMPTY_SEARCH_RESULTS;
    }
}

