/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.hibernate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.jasig.portal.hibernate.DelegatingHibernateIntegrator;
import org.jasig.portal.hibernate.HibernateConfigurationAwareInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingHibernateIntegrator
implements Integrator {
    private static final Set<HibernateConfigurationAwareInjector> configurationAwareBeans = new HashSet();
    private static final Map<String, HibernateConfiguration> hibernateInfoMap = new HashMap();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerConfigurationAwareBeans(HibernateConfigurationAwareInjector configurationAwareBean) {
        Set set = configurationAwareBeans;
        synchronized (set) {
            for (Map.Entry configEntry : hibernateInfoMap.entrySet()) {
                configurationAwareBean.setConfiguration((String)configEntry.getKey(), (HibernateConfiguration)configEntry.getValue());
            }
            configurationAwareBeans.add(configurationAwareBean);
        }
    }

    public static void unregisterConfigurationAwareBeans(HibernateConfigurationAwareInjector configurationAwareBean) {
        configurationAwareBeans.remove(configurationAwareBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        String persistenceUnitName = configuration.getProperty("persistenceUnitName");
        if (persistenceUnitName == null) {
            this.logger.warn("Hibernate Configuration does not have '" + persistenceUnitName + "' set. It will not be considered for injecting into HibernateConfigurationAware beans: " + configuration);
            return;
        }
        HibernateConfiguration hibernateConfiguration = new HibernateConfiguration(configuration, sessionFactory, serviceRegistry);
        Set set = configurationAwareBeans;
        synchronized (set) {
            hibernateInfoMap.put(persistenceUnitName, hibernateConfiguration);
            for (HibernateConfigurationAwareInjector configurationAwareBean : configurationAwareBeans) {
                configurationAwareBean.setConfiguration(persistenceUnitName, hibernateConfiguration);
            }
        }
    }

    public void integrate(MetadataImplementor metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        throw new UnsupportedOperationException("TODO REWRITE CODE AFTER HIBERNATE SWITCHES TO METAMODEL");
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }
}

